/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.update;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.update.UpdateSource;

public class UpdateChecker {
    private final CustomRecipes plugin;
    private final UpdateSource source;
    private final String resourceId;
    private final String githubRepo;
    private String latestVersion = null;
    private String currentVersion;
    private boolean updateAvailable = false;
    private int checkTaskId = -1;

    public UpdateChecker(CustomRecipes plugin, UpdateSource source, String resourceId, String githubRepo) {
        this.plugin = plugin;
        this.source = source;
        this.resourceId = resourceId;
        this.githubRepo = githubRepo;
        this.currentVersion = plugin.getDescription().getVersion();
    }

    public void startPeriodicCheck() {
        if (this.source == UpdateSource.DISABLED) {
            return;
        }
        this.checkForUpdates();
        this.checkTaskId = this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::checkForUpdatesLive, 36000L, 36000L).getTaskId();
    }

    public void stopPeriodicCheck() {
        if (this.checkTaskId != -1) {
            this.plugin.getServer().getScheduler().cancelTask(this.checkTaskId);
            this.checkTaskId = -1;
        }
    }

    public void checkForUpdates() {
        if (this.source == UpdateSource.DISABLED) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            block5: {
                try {
                    String fetchedVersion = this.fetchVersion();
                    if (fetchedVersion != null) {
                        this.latestVersion = fetchedVersion;
                        if (!this.currentVersion.equals(this.latestVersion)) {
                            this.updateAvailable = true;
                            this.plugin.getLogger().info("New version available: " + this.latestVersion + " (Current: " + this.currentVersion + ")");
                        } else {
                            this.plugin.getLogger().info("You are running the latest version!");
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to check for updates: " + e.getMessage());
                    if (!this.plugin.isDebugMode()) break block5;
                    e.printStackTrace();
                }
            }
        });
    }

    private void checkForUpdatesLive() {
        block5: {
            if (this.source == UpdateSource.DISABLED) {
                return;
            }
            try {
                String fetchedVersion = this.fetchVersion();
                if (fetchedVersion != null) {
                    this.latestVersion = fetchedVersion;
                    if (!this.currentVersion.equals(this.latestVersion)) {
                        this.updateAvailable = true;
                        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, this::notifyOnlineAdmins);
                        this.plugin.getLogger().info("Update available: " + this.latestVersion + " - Notifying online admins");
                    }
                }
            }
            catch (Exception e) {
                if (!this.plugin.isDebugMode()) break block5;
                this.plugin.getLogger().warning("Update check failed: " + e.getMessage());
            }
        }
    }

    private String fetchVersion() throws Exception {
        if (this.source == UpdateSource.SPIGOT) {
            return this.checkSpigot();
        }
        if (this.source == UpdateSource.GITHUB) {
            return this.checkGitHub();
        }
        return null;
    }

    private String checkSpigot() throws Exception {
        URL url = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String string = reader.readLine();
            return string;
        }
    }

    private String checkGitHub() throws Exception {
        URL url = new URL("https://api.github.com/repos/" + this.githubRepo + "/releases/latest");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/vnd.github.v3+json");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String json = response.toString();
            int tagIndex = json.indexOf("\"tag_name\":");
            if (tagIndex != -1) {
                int end;
                int start = json.indexOf("\"", tagIndex + 11) + 1;
                String tag = json.substring(start, end = json.indexOf("\"", start));
                String string = tag.startsWith("v") ? tag.substring(1) : tag;
                return string;
            }
        }
        return null;
    }

    public void notifyOnlineAdmins() {
        if (!this.updateAvailable) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("customrecipes.update.notify")) continue;
            this.sendUpdateNotification(player);
        }
    }

    public void sendUpdateNotification(Player player) {
        String downloadUrl = this.getDownloadUrl();
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.sendMessage((Component)Component.empty());
            player.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.DARK_GRAY));
            Component title = ((TextComponent)Component.text((String)"  \u2728 ", (TextColor)NamedTextColor.YELLOW).append(Component.text((String)"CustomRecipes Update Available!", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true))).append((Component)Component.text((String)" \u2728", (TextColor)NamedTextColor.YELLOW));
            player.sendMessage(title);
            player.sendMessage((Component)Component.empty());
            player.sendMessage(Component.text((String)"  Current Version: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)this.currentVersion, (TextColor)NamedTextColor.RED)));
            player.sendMessage(Component.text((String)"  Latest Version: ", (TextColor)NamedTextColor.GRAY).append(Component.text((String)this.latestVersion, (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.BOLD, true)));
            player.sendMessage((Component)Component.empty());
            Component downloadButton = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  [", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)"Download Update", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).clickEvent(ClickEvent.openUrl((String)downloadUrl))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to open download page", (TextColor)NamedTextColor.YELLOW)));
            Component changelogButton = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"  [", (TextColor)NamedTextColor.DARK_GRAY).append(Component.text((String)"View Changelog", (TextColor)NamedTextColor.LIGHT_PURPLE).decoration(TextDecoration.BOLD, true))).append((Component)Component.text((String)"]", (TextColor)NamedTextColor.DARK_GRAY))).clickEvent(ClickEvent.openUrl((String)this.getChangelogUrl()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to view what's new", (TextColor)NamedTextColor.YELLOW)));
            player.sendMessage(downloadButton);
            player.sendMessage(changelogButton);
            player.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.DARK_GRAY));
            player.sendMessage((Component)Component.empty());
            try {
                player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 0.5f, 1.0f);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }, 10L);
    }

    public String getDownloadUrl() {
        if (this.source == UpdateSource.SPIGOT) {
            return "https://www.spigotmc.org/resources/" + this.resourceId + "/";
        }
        if (this.source == UpdateSource.GITHUB) {
            return "https://github.com/" + this.githubRepo + "/releases/latest";
        }
        return null;
    }

    public String getChangelogUrl() {
        if (this.source == UpdateSource.GITHUB) {
            return "https://github.com/" + this.githubRepo + "/releases/tag/v" + this.latestVersion;
        }
        return this.getDownloadUrl();
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

