/*
 * Decompiled with CFR 0.152.
 */
package org.hikarii.customrecipes.update;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.hikarii.customrecipes.CustomRecipes;
import org.hikarii.customrecipes.update.UpdateChecker;

public class UpdateNotifier
implements Listener {
    private final CustomRecipes plugin;
    private final UpdateChecker updateChecker;

    public UpdateNotifier(CustomRecipes plugin, UpdateChecker updateChecker) {
        this.plugin = plugin;
        this.updateChecker = updateChecker;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.hasPermission("customrecipes.update.notify")) {
            return;
        }
        if (this.updateChecker.isUpdateAvailable()) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.updateChecker.sendUpdateNotification(player), 40L);
        }
    }

    private void sendUpdateNotification(Player player) {
        String currentVersion = this.plugin.getDescription().getVersion();
        String latestVersion = this.updateChecker.getLatestVersion();
        String downloadUrl = this.updateChecker.getDownloadUrl();
        player.sendMessage((Component)Component.empty());
        player.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.DARK_GRAY));
        player.sendMessage(Component.text((String)"  CustomRecipes Update Available!", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.BOLD, true));
        player.sendMessage((Component)Component.empty());
        player.sendMessage(Component.text((String)"  Current Version: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)currentVersion, (TextColor)NamedTextColor.RED)));
        player.sendMessage(Component.text((String)"  Latest Version: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)latestVersion, (TextColor)NamedTextColor.GREEN)));
        player.sendMessage((Component)Component.empty());
        Component downloadButton = ((TextComponent)((TextComponent)Component.text((String)"  [Download Update]", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.BOLD, true)).clickEvent(ClickEvent.openUrl((String)downloadUrl))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to open download page", (TextColor)NamedTextColor.YELLOW)));
        player.sendMessage(downloadButton);
        player.sendMessage((Component)Component.text((String)"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", (TextColor)NamedTextColor.DARK_GRAY));
        player.sendMessage((Component)Component.empty());
    }
}

