/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid.generators;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.noise.PerlinOctaveGenerator;
import world.bentobox.skygrid.generators.SkyGridBiomes;

public class SkyGridBiomeProvider
extends BiomeProvider {
    private static final Random RAND = new Random();
    private final Map<World.Environment, PerlinOctaveGenerator> temperatureGenMap = new ConcurrentHashMap<World.Environment, PerlinOctaveGenerator>();
    private final Map<World.Environment, PerlinOctaveGenerator> rainfallGenMap = new ConcurrentHashMap<World.Environment, PerlinOctaveGenerator>();

    public Biome getBiome(WorldInfo worldInfo, int realX, int y, int realZ) {
        if (worldInfo.getEnvironment() == World.Environment.NORMAL && y < 0) {
            return this.caveBiome(y);
        }
        PerlinOctaveGenerator temperatureGen = this.temperatureGenMap.computeIfAbsent(worldInfo.getEnvironment(), wf -> {
            PerlinOctaveGenerator tg = new PerlinOctaveGenerator(worldInfo.getSeed(), 16);
            tg.setScale(0.01);
            return tg;
        });
        PerlinOctaveGenerator rainfallGen = this.rainfallGenMap.computeIfAbsent(worldInfo.getEnvironment(), wf -> {
            PerlinOctaveGenerator rg = new PerlinOctaveGenerator(worldInfo.getSeed() + 1L, 15);
            rg.setScale(0.01);
            return rg;
        });
        Map<SkyGridBiomes, Double> biomes = SkyGridBiomes.getBiomes(worldInfo.getEnvironment(), Math.abs(temperatureGen.noise((double)realX, (double)realZ, 0.5, 0.5) * 100.0), Math.abs(rainfallGen.noise((double)realX, (double)realZ, 0.5, 0.5) * 100.0));
        double maxNoiz = 0.0;
        SkyGridBiomes maxBiome = null;
        for (Map.Entry<SkyGridBiomes, Double> biome : biomes.entrySet()) {
            if (!(biome.getValue() >= maxNoiz)) continue;
            maxNoiz = biome.getValue();
            maxBiome = biome.getKey();
        }
        return ((SkyGridBiomes)Objects.requireNonNull(maxBiome)).biome;
    }

    private Biome caveBiome(int y) {
        if (y < -52) {
            return Biome.DEEP_DARK;
        }
        return RAND.nextBoolean() ? Biome.LUSH_CAVES : Biome.DRIPSTONE_CAVES;
    }

    public List<Biome> getBiomes(WorldInfo worldInfo) {
        return Arrays.stream(SkyGridBiomes.values()).map(SkyGridBiomes::getBiome).toList();
    }
}

