/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.database.objects.adapters.Adapter;
import world.bentobox.bentobox.database.objects.adapters.FlagBooleanSerializer;

@StoreAt(filename="config.yml", path="addons/SkyGrid")
@ConfigComment.Line(value={@ConfigComment(value="SkyGrid Configuration [version]"), @ConfigComment(value="")})
public class Settings
implements WorldSettings {
    @ConfigComment.Line(value={@ConfigComment(value="Island Command. What command users will run to access their island."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="skygrid.command.island")
    private String playerCommandAliases = "skygrid sg";
    @ConfigComment.Line(value={@ConfigComment(value="The island admin command."), @ConfigComment(value="To define alias, just separate commands with white space.")})
    @ConfigEntry(path="skygrid.command.admin")
    private String adminCommandAliases = "sgadmin sga";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for new player command call."), @ConfigComment(value="Sub-command of main player command that will be run on first player command call."), @ConfigComment(value="By default it is sub-command 'create'.")})
    @ConfigEntry(path="skygrid.command.new-player-action", since="1.16.0")
    private String defaultNewPlayerAction = "create";
    @ConfigComment.Line(value={@ConfigComment(value="The default action for player command."), @ConfigComment(value="Sub-command of main player command that will be run on each player command call."), @ConfigComment(value="By default it is sub-command 'go'.")})
    @ConfigEntry(path="skygrid.command.default-action", since="1.16.0")
    private String defaultPlayerAction = "go";
    @ConfigComment(value="Number of unique items per chest")
    @ConfigEntry(path="world.chest-fill.overworld")
    private int chestFill = 5;
    @ConfigComment(value="Nether chest fill setting")
    @ConfigEntry(path="world.chest-fill.nether")
    private int chestFillNether = 5;
    @ConfigComment(value="The End chest fill setting")
    @ConfigEntry(path="world.chest-fill.end")
    private int chestFillEnd = 5;
    @ConfigComment.Line(value={@ConfigComment(value="Chest items will be taken randomly from this list according to the relative probabilities given"), @ConfigComment(value="Format: Material : Probability"), @ConfigComment(value="Material values can be found at https://hub.spigotmc.org/javadocs/spigot/org/bukkit/Material.html")})
    @ConfigEntry(path="world.chest-items.overworld")
    private Map<Material, Integer> chestItemsOverworld = new EnumMap<Material, Integer>(Material.class);
    @ConfigEntry(path="world.chest-items.nether")
    private Map<Material, Integer> chestItemsNether = new EnumMap<Material, Integer>(Material.class);
    @ConfigEntry(path="world.chest-items.end")
    private Map<Material, Integer> chestItemsEnd = new EnumMap<Material, Integer>(Material.class);
    @ConfigComment.Line(value={@ConfigComment(value="World block types. If the material cannot be placed, bedrock will be used."), @ConfigComment(value="Format: Material : Probability"), @ConfigComment(value="Block types must be Bukkit Material types."), @ConfigComment(value="Chests have different items in them in different world types."), @ConfigComment(value="Over world blocks. Beware of making too many chests, they can lag a lot.")})
    @ConfigEntry(path="world.blocks")
    private Map<Material, Integer> blocks = new EnumMap<Material, Integer>(Material.class);
    @ConfigComment(value="Generate SkyGrid Nether - if this is false, the nether world will not be made")
    @ConfigEntry(path="world.nether.generate")
    private boolean netherGenerate = true;
    @ConfigComment.Line(value={@ConfigComment(value="Nether block types"), @ConfigComment(value="Beware with glowstone and lava - the lighting calcs will lag the"), @ConfigComment(value="server badly if there are too many blocks.")})
    @ConfigEntry(path="world.nether.blocks")
    private Map<Material, Integer> netherBlocks = new EnumMap<Material, Integer>(Material.class);
    @ConfigComment.Line(value={@ConfigComment(value="This option indicates if nether portals should be linked via dimensions."), @ConfigComment(value="Option will simulate vanilla portal mechanics that links portals together"), @ConfigComment(value="or creates a new portal, if there is not a portal in that dimension.")})
    @ConfigEntry(path="world.nether.create-and-link-portals", since="1.16")
    private boolean makeNetherPortals = false;
    @ConfigComment(value="Generate SkyGrid End - if this is false, the end world will not be made")
    @ConfigEntry(path="world.end.generate")
    private boolean endGenerate = true;
    @ConfigComment(value="The End blocks.")
    @ConfigEntry(path="world.end.blocks")
    private Map<Material, Integer> endBlocks = new EnumMap<Material, Integer>(Material.class);
    private boolean makeEndPortals = true;
    @ConfigComment(value="The probability of a frame being created in a chunk. Frames are always at y=0.")
    @ConfigEntry(path="world.end-frame-probability")
    private double endFrameProb = 0.1;
    @ConfigComment(value="Friendly name for this world. Used in admin commands. Must be a single word")
    @ConfigEntry(path="world.friendly-name")
    private String friendlyName = "SkyGrid";
    @ConfigComment.Line(value={@ConfigComment(value="Name of the world - if it does not exist then it will be generated."), @ConfigComment(value="It acts like a prefix for nether and end")})
    @ConfigEntry(path="world.world-name")
    private String worldName = "skygrid-world";
    @ConfigComment.Line(value={@ConfigComment(value="World difficulty setting - PEACEFUL, EASY, NORMAL, HARD"), @ConfigComment(value="Other plugins may override this setting")})
    @ConfigEntry(path="world.difficulty")
    private Difficulty difficulty = Difficulty.NORMAL;
    @ConfigComment(value="Start at these coordinates.")
    @ConfigEntry(path="world.start-x", needsReset=true)
    private int islandStartX = 0;
    @ConfigEntry(path="world.start-z", needsReset=true)
    private int islandStartZ = 0;
    @ConfigComment.Line(value={@ConfigComment(value="SkyGrid height"), @ConfigComment(value="This is the height of the top sky grid layer. 255 max.")})
    @ConfigEntry(path="world.skygrid-height")
    private int islandHeight = 128;
    @ConfigComment.Line(value={@ConfigComment(value="The number of concurrent areas a player can have"), @ConfigComment(value="A value of 0 will use the BentoBox config.yml default")})
    @ConfigEntry(path="world.concurrent-area")
    private int concurrentIslands = 0;
    @ConfigComment(value="Disallow team members from having their own area.")
    @ConfigEntry(path="world.disallow-team-member-areas")
    private boolean disallowTeamMemberIslands = true;
    @ConfigComment.Line(value={@ConfigComment(value="End Frame height"), @ConfigComment(value="This is the height where end frames will generate.")})
    @ConfigEntry(path="world.end-frame-height", since="1.20.0")
    private int endFrameHeight = 3;
    @ConfigComment(value="Space around new players in blocks (will be rounded up to nearest 16 blocks)")
    @ConfigEntry(path="world.space-around-players")
    private int islandDistance = 1000;
    @ConfigComment(value="Default protection radius around player's home (so total size is 2x this)")
    @ConfigEntry(path="world.protection-range")
    private int islandProtectionRange = 50;
    @ConfigComment.Line(value={@ConfigComment(value="The default game mode for this world. Players will be set to this mode when they create"), @ConfigComment(value="a new island for example. Options are SURVIVAL, CREATIVE, ADVENTURE, SPECTATOR")})
    @ConfigEntry(path="world.default-game-mode")
    private GameMode defaultGameMode = GameMode.SURVIVAL;
    @ConfigComment.Line(value={@ConfigComment(value="The maximum number of players a player can ban at any one time in this game mode."), @ConfigComment(value="The permission acidarea.ban.maxlimit.X where X is a number can also be used per player"), @ConfigComment(value="-1 = unlimited")})
    @ConfigEntry(path="world.ban-limit")
    private int banLimit = -1;
    @ConfigComment(value="Mob white list - these mobs will NOT be removed when logging in or doing /island")
    @ConfigEntry(path="world.remove-mobs-whitelist")
    private Set<EntityType> removeMobsWhitelist = new HashSet<EntityType>();
    @ConfigComment(value="World flags. These are boolean settings for various flags for this world")
    @ConfigEntry(path="world.flags")
    private Map<String, Boolean> worldFlags = new HashMap<String, Boolean>();
    @ConfigComment.Line(value={@ConfigComment(value="These are the default protection settings protected areas."), @ConfigComment(value="The value is the minimum island rank required to do the action"), @ConfigComment(value="Ranks are: Visitor = 0, Member = 900, Owner = 1000")})
    @ConfigEntry(path="world.default-protection-flags")
    private Map<String, Integer> defaultIslandFlagNames = new HashMap<String, Integer>();
    @ConfigComment(value="These are the default settings for new protected areas")
    @ConfigEntry(path="world.default-settings")
    @Adapter(value=FlagBooleanSerializer.class)
    private Map<String, Integer> defaultIslandSettingNames = new HashMap<String, Integer>();
    @ConfigComment.Line(value={@ConfigComment(value="These settings/flags are hidden from users"), @ConfigComment(value="Ops can toggle hiding in-game using SHIFT-LEFT-CLICK on flags in settings")})
    @ConfigEntry(path="world.hidden-flags")
    private List<String> hiddenFlags = new ArrayList<String>();
    @ConfigComment(value="Visitor banned commands - Visitors to islands cannot use these commands in this world")
    @ConfigEntry(path="world.visitor-banned-commands")
    private List<String> visitorBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Falling banned commands - players cannot use these commands when falling"), @ConfigComment(value="if the PREVENT_TELEPORT_WHEN_FALLING world setting flag is active")})
    @ConfigEntry(path="world.falling-banned-commands")
    private List<String> fallingBannedCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Default max team size"), @ConfigComment(value="Permission size cannot be less than the default below. ")})
    @ConfigEntry(path="area.max-team-size")
    private int maxTeamSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of coop rank members per area"), @ConfigComment(value="Players can have the skygrid.coop.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="area.max-coop-size", since="1.13.0")
    private int maxCoopSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of trusted rank members per area"), @ConfigComment(value="Players can have the skygrid.trust.maxsize.<number> permission to be bigger but"), @ConfigComment(value="permission size cannot be less than the default below. ")})
    @ConfigEntry(path="area.max-trusted-size", since="1.13.0")
    private int maxTrustSize = 4;
    @ConfigComment.Line(value={@ConfigComment(value="Default maximum number of homes a player can have. Min = 1"), @ConfigComment(value="Accessed via /sg sethome <number> or /sg go <number>")})
    @ConfigEntry(path="area.max-homes")
    private int maxHomes = 5;
    @ConfigComment.Line(value={@ConfigComment(value="How many resets a player is allowed (override with /sgadmin clearresets <player>)"), @ConfigComment(value="Value of -1 means unlimited, 0 means hardcore - no resets."), @ConfigComment(value="Example, 2 resets means they get 2 resets or 3 islands lifetime")})
    @ConfigEntry(path="area.reset.reset-limit")
    private int resetLimit = -1;
    @ConfigComment.Line(value={@ConfigComment(value="Kicked or leaving players lose resets"), @ConfigComment(value="Players who leave a team will lose a reset chance"), @ConfigComment(value="If a player has zero resets left and leaves a team, they cannot make a new"), @ConfigComment(value="island by themselves and can only join a team."), @ConfigComment(value="Leave this true to avoid players exploiting free islands")})
    @ConfigEntry(path="area.reset.leavers-lose-reset")
    private boolean leaversLoseReset = false;
    @ConfigComment.Line(value={@ConfigComment(value="Allow kicked players to keep their inventory."), @ConfigComment(value="Overrides the on-leave inventory reset for kicked players.")})
    @ConfigEntry(path="area.reset.kicked-keep-inventory")
    private boolean kickedKeepInventory = false;
    @ConfigComment.Line(value={@ConfigComment(value="What should reset when the player joins or starts new"), @ConfigComment(value="Reset Money - if this is true, will reset the player's money to the starting money"), @ConfigComment(value="Recommendation is that this is set to true, but if you run multi-worlds"), @ConfigComment(value="make sure your economy handles multi-worlds too.")})
    @ConfigEntry(path="area.reset.on-join.money")
    private boolean onJoinResetMoney = false;
    @ConfigComment.Line(value={@ConfigComment(value="Reset inventory - if true, the player's inventory will be cleared."), @ConfigComment(value="Note: if you have MultiInv running or a similar inventory control plugin, that"), @ConfigComment(value="plugin may still reset the inventory when the world changes.")})
    @ConfigEntry(path="area.reset.on-join.inventory")
    private boolean onJoinResetInventory = false;
    @ConfigComment(value="Reset health - if true, the player's health will be reset.")
    @ConfigEntry(path="area.reset.on-join.health")
    private boolean onJoinResetHealth = true;
    @ConfigComment(value="Reset hunger - if true, the player's hunger will be reset.")
    @ConfigEntry(path="area.reset.on-join.hunger")
    private boolean onJoinResetHunger = true;
    @ConfigComment(value="Reset experience points - if true, the player's experience will be reset.")
    @ConfigEntry(path="area.reset.on-join.exp")
    private boolean onJoinResetXP = false;
    @ConfigComment(value="Reset Ender Chest - if true, the player's Ender Chest will be cleared.")
    @ConfigEntry(path="area.reset.on-join.ender-chest")
    private boolean onJoinResetEnderChest = false;
    @ConfigComment.Line(value={@ConfigComment(value="What should reset when the player leaves or is kicked"), @ConfigComment(value="Reset Money - if this is true, will reset the player's money to the starting money"), @ConfigComment(value="Recommendation is that this is set to true, but if you run multi-worlds"), @ConfigComment(value="make sure your economy handles multi-worlds too.")})
    @ConfigEntry(path="area.reset.on-leave.money")
    private boolean onLeaveResetMoney = false;
    @ConfigComment.Line(value={@ConfigComment(value="Reset inventory - if true, the player's inventory will be cleared."), @ConfigComment(value="Note: if you have MultiInv running or a similar inventory control plugin, that"), @ConfigComment(value="plugin may still reset the inventory when the world changes.")})
    @ConfigEntry(path="area.reset.on-leave.inventory")
    private boolean onLeaveResetInventory = false;
    @ConfigComment(value="Reset health - if true, the player's health will be reset.")
    @ConfigEntry(path="area.reset.on-leave.health")
    private boolean onLeaveResetHealth = false;
    @ConfigComment(value="Reset hunger - if true, the player's hunger will be reset.")
    @ConfigEntry(path="area.reset.on-leave.hunger")
    private boolean onLeaveResetHunger = false;
    @ConfigComment(value="Reset experience - if true, the player's experience will be reset.")
    @ConfigEntry(path="area.reset.on-leave.exp")
    private boolean onLeaveResetXP = false;
    @ConfigComment(value="Reset Ender Chest - if true, the player's Ender Chest will be cleared.")
    @ConfigEntry(path="area.reset.on-leave.ender-chest")
    private boolean onLeaveResetEnderChest = false;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles the automatic area creation upon the player's first login on your server."), @ConfigComment(value="If set to true,"), @ConfigComment(value="   * Upon connecting to your server for the first time, the player will be told that"), @ConfigComment(value="    an area will be created for him."), @ConfigComment(value="  * An area will be created for the player without needing him to run the create command."), @ConfigComment(value="If set to false, this will disable this feature entirely."), @ConfigComment(value="Warning:"), @ConfigComment(value="  * If you are running multiple gamemodes on your server, and all of them have"), @ConfigComment(value="    this feature enabled, an area in all the gamemodes will be created simultaneously."), @ConfigComment(value="    However, it is impossible to know on which area the player will be teleported to afterwards."), @ConfigComment(value="  * Area creation can be resource-intensive, please consider the options below to help mitigate"), @ConfigComment(value="    the potential issues, especially if you expect a lot of players to connect to your server"), @ConfigComment(value="    in a limited period of time.")})
    @ConfigEntry(path="area.create-area-on-first-login.enable")
    private boolean createIslandOnFirstLoginEnabled;
    @ConfigComment.Line(value={@ConfigComment(value="Time in seconds after the player logged in, before his area gets created."), @ConfigComment(value="If set to 0 or less, the island will be created directly upon the player's login."), @ConfigComment(value="It is recommended to keep this value under a minute's time.")})
    @ConfigEntry(path="area.create-area-on-first-login.delay")
    private int createIslandOnFirstLoginDelay = 5;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles whether the area creation should be aborted if the player logged off while the"), @ConfigComment(value="delay (see the option above) has not worn off yet."), @ConfigComment(value="If set to true,"), @ConfigComment(value="  * If the player has logged off the server while the delay (see the option above) has not"), @ConfigComment(value="    worn off yet, this will cancel the area creation."), @ConfigComment(value="  * If the player relogs afterward, since he will not be recognized as a new player, no area"), @ConfigComment(value="    would be created for him."), @ConfigComment(value="  * If the area creation started before the player logged off, it will continue."), @ConfigComment(value="If set to false, the player's area will be created even if he went offline in the meantime."), @ConfigComment(value="Note this option has no effect if the delay (see the option above) is set to 0 or less.")})
    @ConfigEntry(path="area.create-area-on-first-login.abort-on-logout")
    private boolean createIslandOnFirstLoginAbortOnLogout = true;
    @ConfigComment.Line(value={@ConfigComment(value="List of commands to run when a player joins."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'bsbadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="area.commands.on-join")
    private List<String> onJoinCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="list of commands to run when a player leaves."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'bsbadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="area.commands.on-leave")
    private List<String> onLeaveCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="List of commands that should be executed when the player respawns after death if Flags.ISLAND_RESPAWN is true."), @ConfigComment(value="These commands are run by the console, unless otherwise stated using the [SUDO] prefix,"), @ConfigComment(value="in which case they are executed by the player."), @ConfigComment(value=""), @ConfigComment(value="Available placeholders for the commands are the following:"), @ConfigComment(value="   * [name]: name of the player"), @ConfigComment(value=""), @ConfigComment(value="Here are some examples of valid commands to execute:"), @ConfigComment(value="   * '[SUDO] bbox version'"), @ConfigComment(value="   * 'bsbadmin deaths set [player] 0'"), @ConfigComment(value=""), @ConfigComment(value="Note that player-executed commands might not work, as these commands can be run with said player being offline.")})
    @ConfigEntry(path="area.commands.on-respawn", since="1.14.0")
    private List<String> onRespawnCommands = new ArrayList<String>();
    @ConfigComment(value="Allow setting home in the nether. Only available on nether islands, not vanilla nether.")
    @ConfigEntry(path="area.sethome.nether.allow")
    private boolean allowSetHomeInNether = true;
    @ConfigEntry(path="area.sethome.nether.require-confirmation")
    private boolean requireConfirmationToSetHomeInNether = true;
    @ConfigComment(value="Allow setting home in the end. Only available on end islands, not vanilla end.")
    @ConfigEntry(path="area.sethome.the-end.allow")
    private boolean allowSetHomeInTheEnd = true;
    @ConfigEntry(path="area.sethome.the-end.require-confirmation")
    private boolean requireConfirmationToSetHomeInTheEnd = true;
    @ConfigComment(value="Whether deaths are counted or not.")
    @ConfigEntry(path="area.deaths.counted")
    private boolean deathsCounted = true;
    @ConfigComment(value="Maximum number of deaths to count. The death count can be used by add-ons.")
    @ConfigEntry(path="area.deaths.max")
    private int deathsMax = 10;
    @ConfigComment(value="When a player joins a team, reset their death count")
    @ConfigEntry(path="area.deaths.team-join-reset")
    private boolean teamJoinDeathReset = true;
    @ConfigComment(value="Reset player death count when they start reset")
    @ConfigEntry(path="area.deaths.reset-on-new-island")
    private boolean deathsResetOnNewIsland = true;
    @ConfigComment.Line(value={@ConfigComment(value="Geo restrict mobs."), @ConfigComment(value="Mobs that exit the protected space where they were spawned will be removed.")})
    @ConfigEntry(path="protection.geo-limit-settings")
    private List<String> geoLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="SkyGrid blocked mobs."), @ConfigComment(value="List of mobs that should not spawn in SkyGrid.")})
    @ConfigEntry(path="protection.block-mobs")
    private List<String> mobLimitSettings = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="Invincible visitors. List of damages that will not affect visitors."), @ConfigComment(value="Make list blank if visitors should receive all damages")})
    @ConfigEntry(path="protection.invincible-visitors")
    private List<String> ivSettings = new ArrayList<String>();
    @ConfigComment(value="These settings should not be edited")
    @ConfigEntry(path="do-not-edit-these-settings.reset-epoch")
    private long resetEpoch = 0L;

    public Map<Material, Integer> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(Map<Material, Integer> blocks) {
        this.blocks = blocks;
    }

    public Map<Material, Integer> getNetherBlocks() {
        return this.netherBlocks;
    }

    public void setNetherBlocks(Map<Material, Integer> netherBlocks) {
        this.netherBlocks = netherBlocks;
    }

    public Map<Material, Integer> getEndBlocks() {
        return this.endBlocks;
    }

    public void setEndBlocks(Map<Material, Integer> endBlocks) {
        this.endBlocks = endBlocks;
    }

    public double getEndFrameProb() {
        return this.endFrameProb;
    }

    public void setEndFrameProb(double endFrameProb) {
        this.endFrameProb = endFrameProb;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
    }

    public int getIslandStartX() {
        return this.islandStartX;
    }

    public void setIslandStartX(int islandStartX) {
        this.islandStartX = islandStartX;
    }

    public int getIslandStartZ() {
        return this.islandStartZ;
    }

    public void setIslandStartZ(int islandStartZ) {
        this.islandStartZ = islandStartZ;
    }

    public int getIslandHeight() {
        if (this.islandHeight > 255) {
            this.islandHeight = 255;
        } else if (this.islandHeight < -64) {
            this.islandHeight = -64;
        }
        return this.islandHeight;
    }

    public void setIslandHeight(int islandHeight) {
        if (islandHeight > 255) {
            islandHeight = 255;
        } else if (islandHeight < -64) {
            islandHeight = -64;
        }
        this.islandHeight = islandHeight;
    }

    public int getIslandDistance() {
        return this.islandDistance;
    }

    public void setIslandDistance(int islandDistance) {
        this.islandDistance = islandDistance;
    }

    public int getIslandProtectionRange() {
        return this.islandProtectionRange;
    }

    public void setIslandProtectionRange(int islandProtectionRange) {
        this.islandProtectionRange = islandProtectionRange;
    }

    public GameMode getDefaultGameMode() {
        return this.defaultGameMode;
    }

    public void setDefaultGameMode(GameMode defaultGameMode) {
        this.defaultGameMode = defaultGameMode;
    }

    public int getBanLimit() {
        return this.banLimit;
    }

    public void setBanLimit(int banLimit) {
        this.banLimit = banLimit;
    }

    public boolean isNetherGenerate() {
        return this.netherGenerate;
    }

    public void setNetherGenerate(boolean netherGenerate) {
        this.netherGenerate = netherGenerate;
    }

    public boolean isEndGenerate() {
        return this.endGenerate;
    }

    public void setEndGenerate(boolean endGenerate) {
        this.endGenerate = endGenerate;
    }

    public Set<EntityType> getRemoveMobsWhitelist() {
        return this.removeMobsWhitelist;
    }

    public void setRemoveMobsWhitelist(Set<EntityType> removeMobsWhitelist) {
        this.removeMobsWhitelist = removeMobsWhitelist;
    }

    public Map<String, Boolean> getWorldFlags() {
        return this.worldFlags;
    }

    public void setWorldFlags(Map<String, Boolean> worldFlags) {
        this.worldFlags = worldFlags;
    }

    @Deprecated
    public Map<Flag, Integer> getDefaultIslandFlags() {
        return Collections.emptyMap();
    }

    public Map<String, Integer> getDefaultIslandFlagNames() {
        return this.defaultIslandFlagNames;
    }

    public void setDefaultIslandFlagNames(Map<String, Integer> defaultIslandFlags) {
        this.defaultIslandFlagNames = defaultIslandFlags;
    }

    @Deprecated
    public Map<Flag, Integer> getDefaultIslandSettings() {
        return Collections.emptyMap();
    }

    public Map<String, Integer> getDefaultIslandSettingNames() {
        return this.defaultIslandSettingNames;
    }

    public void setDefaultIslandSettingNames(Map<String, Integer> defaultIslandSettings) {
        this.defaultIslandSettingNames = defaultIslandSettings;
    }

    public List<String> getHiddenFlags() {
        return this.hiddenFlags;
    }

    public void setHiddenFlags(List<String> hiddenFlags) {
        this.hiddenFlags = hiddenFlags;
    }

    public List<String> getVisitorBannedCommands() {
        return this.visitorBannedCommands;
    }

    public void setVisitorBannedCommands(List<String> visitorBannedCommands) {
        this.visitorBannedCommands = visitorBannedCommands;
    }

    public List<String> getFallingBannedCommands() {
        return this.fallingBannedCommands;
    }

    public void setFallingBannedCommands(List<String> fallingBannedCommands) {
        this.fallingBannedCommands = fallingBannedCommands;
    }

    public int getMaxTeamSize() {
        return this.maxTeamSize;
    }

    public void setMaxTeamSize(int maxTeamSize) {
        this.maxTeamSize = maxTeamSize;
    }

    public int getResetLimit() {
        return this.resetLimit;
    }

    public void setResetLimit(int resetLimit) {
        this.resetLimit = resetLimit;
    }

    public boolean isLeaversLoseReset() {
        return this.leaversLoseReset;
    }

    public void setLeaversLoseReset(boolean leaversLoseReset) {
        this.leaversLoseReset = leaversLoseReset;
    }

    public boolean isKickedKeepInventory() {
        return this.kickedKeepInventory;
    }

    public boolean isCreateIslandOnFirstLoginEnabled() {
        return this.createIslandOnFirstLoginEnabled;
    }

    public int getCreateIslandOnFirstLoginDelay() {
        return this.createIslandOnFirstLoginDelay;
    }

    public boolean isCreateIslandOnFirstLoginAbortOnLogout() {
        return this.createIslandOnFirstLoginAbortOnLogout;
    }

    public void setKickedKeepInventory(boolean kickedKeepInventory) {
        this.kickedKeepInventory = kickedKeepInventory;
    }

    public boolean isOnJoinResetMoney() {
        return this.onJoinResetMoney;
    }

    public void setOnJoinResetMoney(boolean onJoinResetMoney) {
        this.onJoinResetMoney = onJoinResetMoney;
    }

    public boolean isOnJoinResetInventory() {
        return this.onJoinResetInventory;
    }

    public void setOnJoinResetInventory(boolean onJoinResetInventory) {
        this.onJoinResetInventory = onJoinResetInventory;
    }

    public boolean isOnJoinResetEnderChest() {
        return this.onJoinResetEnderChest;
    }

    public void setOnJoinResetEnderChest(boolean onJoinResetEnderChest) {
        this.onJoinResetEnderChest = onJoinResetEnderChest;
    }

    public boolean isOnLeaveResetMoney() {
        return this.onLeaveResetMoney;
    }

    public void setOnLeaveResetMoney(boolean onLeaveResetMoney) {
        this.onLeaveResetMoney = onLeaveResetMoney;
    }

    public boolean isOnLeaveResetInventory() {
        return this.onLeaveResetInventory;
    }

    public void setOnLeaveResetInventory(boolean onLeaveResetInventory) {
        this.onLeaveResetInventory = onLeaveResetInventory;
    }

    public boolean isOnLeaveResetEnderChest() {
        return this.onLeaveResetEnderChest;
    }

    public void setOnLeaveResetEnderChest(boolean onLeaveResetEnderChest) {
        this.onLeaveResetEnderChest = onLeaveResetEnderChest;
    }

    public boolean isAllowSetHomeInNether() {
        return this.allowSetHomeInNether;
    }

    public void setAllowSetHomeInNether(boolean allowSetHomeInNether) {
        this.allowSetHomeInNether = allowSetHomeInNether;
    }

    public boolean isRequireConfirmationToSetHomeInNether() {
        return this.requireConfirmationToSetHomeInNether;
    }

    public void setRequireConfirmationToSetHomeInNether(boolean requireConfirmationToSetHomeInNether) {
        this.requireConfirmationToSetHomeInNether = requireConfirmationToSetHomeInNether;
    }

    public boolean isAllowSetHomeInTheEnd() {
        return this.allowSetHomeInTheEnd;
    }

    public void setAllowSetHomeInTheEnd(boolean allowSetHomeInTheEnd) {
        this.allowSetHomeInTheEnd = allowSetHomeInTheEnd;
    }

    public boolean isRequireConfirmationToSetHomeInTheEnd() {
        return this.requireConfirmationToSetHomeInTheEnd;
    }

    public void setRequireConfirmationToSetHomeInTheEnd(boolean requireConfirmationToSetHomeInTheEnd) {
        this.requireConfirmationToSetHomeInTheEnd = requireConfirmationToSetHomeInTheEnd;
    }

    public boolean isDeathsCounted() {
        return this.deathsCounted;
    }

    public void setDeathsCounted(boolean deathsCounted) {
        this.deathsCounted = deathsCounted;
    }

    public int getDeathsMax() {
        return this.deathsMax;
    }

    public void setDeathsMax(int deathsMax) {
        this.deathsMax = deathsMax;
    }

    public boolean isTeamJoinDeathReset() {
        return this.teamJoinDeathReset;
    }

    public void setTeamJoinDeathReset(boolean teamJoinDeathReset) {
        this.teamJoinDeathReset = teamJoinDeathReset;
    }

    public List<String> getGeoLimitSettings() {
        return this.geoLimitSettings;
    }

    public void setGeoLimitSettings(List<String> geoLimitSettings) {
        this.geoLimitSettings = geoLimitSettings;
    }

    public List<String> getIvSettings() {
        return this.ivSettings;
    }

    public void setIvSettings(List<String> ivSettings) {
        this.ivSettings = ivSettings;
    }

    public long getResetEpoch() {
        return this.resetEpoch;
    }

    public void setResetEpoch(long resetEpoch) {
        this.resetEpoch = resetEpoch;
    }

    public int getIslandXOffset() {
        return 0;
    }

    public int getIslandZOffset() {
        return 0;
    }

    public int getMaxHomes() {
        return this.maxHomes;
    }

    public int getMaxIslands() {
        return -1;
    }

    public int getNetherSpawnRadius() {
        return 0;
    }

    public String getPermissionPrefix() {
        return "skygrid";
    }

    public int getSeaHeight() {
        return 0;
    }

    public boolean isDragonSpawn() {
        return false;
    }

    public boolean isEndIslands() {
        return true;
    }

    public boolean isNetherIslands() {
        return true;
    }

    public boolean isUseOwnGenerator() {
        return false;
    }

    public boolean isWaterUnsafe() {
        return false;
    }

    public String getPlayerCommandAliases() {
        return this.playerCommandAliases;
    }

    public void setPlayerCommandAliases(String playerCommandAliases) {
        this.playerCommandAliases = playerCommandAliases;
    }

    public String getAdminCommandAliases() {
        return this.adminCommandAliases;
    }

    public void setAdminCommandAliases(String adminCommandAliases) {
        this.adminCommandAliases = adminCommandAliases;
    }

    public int getChestFill() {
        return this.chestFill;
    }

    public void setChestFill(int chestFill) {
        this.chestFill = chestFill;
    }

    public int getChestFillNether() {
        return this.chestFillNether;
    }

    public void setChestFillNether(int chestFillNether) {
        this.chestFillNether = chestFillNether;
    }

    public int getChestFillEnd() {
        return this.chestFillEnd;
    }

    public void setChestFillEnd(int chestFillEnd) {
        this.chestFillEnd = chestFillEnd;
    }

    public Map<Material, Integer> getChestItemsOverworld() {
        return this.chestItemsOverworld;
    }

    public void setChestItemsOverworld(Map<Material, Integer> chestItemsOverworld) {
        this.chestItemsOverworld = chestItemsOverworld;
    }

    public Map<Material, Integer> getChestItemsNether() {
        return this.chestItemsNether;
    }

    public void setChestItemsNether(Map<Material, Integer> chestItemsNether) {
        this.chestItemsNether = chestItemsNether;
    }

    public Map<Material, Integer> getChestItemsEnd() {
        return this.chestItemsEnd;
    }

    public void setChestItemsEnd(Map<Material, Integer> chestItemsEnd) {
        this.chestItemsEnd = chestItemsEnd;
    }

    public boolean isDeathsResetOnNewIsland() {
        return this.deathsResetOnNewIsland;
    }

    public void setDeathsResetOnNewIsland(boolean deathsResetOnNewIsland) {
        this.deathsResetOnNewIsland = deathsResetOnNewIsland;
    }

    public List<String> getOnJoinCommands() {
        return Objects.requireNonNullElseGet(this.onJoinCommands, ArrayList::new);
    }

    public void setOnJoinCommands(List<String> onJoinCommands) {
        this.onJoinCommands = onJoinCommands;
    }

    public List<String> getOnLeaveCommands() {
        return Objects.requireNonNullElseGet(this.onLeaveCommands, ArrayList::new);
    }

    public void setOnLeaveCommands(List<String> onLeaveCommands) {
        this.onLeaveCommands = onLeaveCommands;
    }

    public List<String> getOnRespawnCommands() {
        return Objects.requireNonNullElseGet(this.onRespawnCommands, ArrayList::new);
    }

    public void setOnRespawnCommands(List<String> onRespawnCommands) {
        this.onRespawnCommands = onRespawnCommands;
    }

    public boolean isOnJoinResetHealth() {
        return this.onJoinResetHealth;
    }

    public void setOnJoinResetHealth(boolean onJoinResetHealth) {
        this.onJoinResetHealth = onJoinResetHealth;
    }

    public boolean isOnJoinResetHunger() {
        return this.onJoinResetHunger;
    }

    public void setOnJoinResetHunger(boolean onJoinResetHunger) {
        this.onJoinResetHunger = onJoinResetHunger;
    }

    public boolean isOnJoinResetXP() {
        return this.onJoinResetXP;
    }

    public void setOnJoinResetXP(boolean onJoinResetXP) {
        this.onJoinResetXP = onJoinResetXP;
    }

    public boolean isOnLeaveResetHealth() {
        return this.onLeaveResetHealth;
    }

    public void setOnLeaveResetHealth(boolean onLeaveResetHealth) {
        this.onLeaveResetHealth = onLeaveResetHealth;
    }

    public boolean isOnLeaveResetHunger() {
        return this.onLeaveResetHunger;
    }

    public void setOnLeaveResetHunger(boolean onLeaveResetHunger) {
        this.onLeaveResetHunger = onLeaveResetHunger;
    }

    public boolean isOnLeaveResetXP() {
        return this.onLeaveResetXP;
    }

    public void setOnLeaveResetXP(boolean onLeaveResetXP) {
        this.onLeaveResetXP = onLeaveResetXP;
    }

    public void setCreateIslandOnFirstLoginEnabled(boolean createIslandOnFirstLoginEnabled) {
        this.createIslandOnFirstLoginEnabled = createIslandOnFirstLoginEnabled;
    }

    public void setCreateIslandOnFirstLoginDelay(int createIslandOnFirstLoginDelay) {
        this.createIslandOnFirstLoginDelay = createIslandOnFirstLoginDelay;
    }

    public void setCreateIslandOnFirstLoginAbortOnLogout(boolean createIslandOnFirstLoginAbortOnLogout) {
        this.createIslandOnFirstLoginAbortOnLogout = createIslandOnFirstLoginAbortOnLogout;
    }

    public int getMaxCoopSize() {
        return this.maxCoopSize;
    }

    public void setMaxCoopSize(int maxCoopSize) {
        this.maxCoopSize = maxCoopSize;
    }

    public int getMaxTrustSize() {
        return this.maxTrustSize;
    }

    public void setMaxTrustSize(int maxTrustSize) {
        this.maxTrustSize = maxTrustSize;
    }

    public String getDefaultNewPlayerAction() {
        return this.defaultNewPlayerAction;
    }

    public void setDefaultNewPlayerAction(String defaultNewPlayerAction) {
        this.defaultNewPlayerAction = defaultNewPlayerAction;
    }

    public String getDefaultPlayerAction() {
        return this.defaultPlayerAction;
    }

    public void setDefaultPlayerAction(String defaultPlayerAction) {
        this.defaultPlayerAction = defaultPlayerAction;
    }

    public List<String> getMobLimitSettings() {
        return this.mobLimitSettings;
    }

    public void setMobLimitSettings(List<String> mobLimitSettings) {
        this.mobLimitSettings = mobLimitSettings;
    }

    public boolean isMakeNetherPortals() {
        return this.makeNetherPortals;
    }

    public boolean isMakeEndPortals() {
        return this.makeEndPortals;
    }

    public void setMakeNetherPortals(boolean makeNetherPortals) {
        this.makeNetherPortals = makeNetherPortals;
    }

    public void setMakeEndPortals(boolean makeEndPortals) {
        this.makeEndPortals = makeEndPortals;
    }

    public boolean isCheckForBlocks() {
        return false;
    }

    public void setMaxHomes(int maxHomes) {
        this.maxHomes = maxHomes;
    }

    public int getEndFrameHeight() {
        return this.endFrameHeight;
    }

    public void setEndFrameHeight(int endFrameHeight) {
        this.endFrameHeight = endFrameHeight;
    }

    public int getConcurrentIslands() {
        if (this.concurrentIslands <= 0) {
            return BentoBox.getInstance().getSettings().getIslandNumber();
        }
        return this.concurrentIslands;
    }

    public void setConcurrentIslands(int concurrentIslands) {
        this.concurrentIslands = concurrentIslands;
    }

    public boolean isDisallowTeamMemberIslands() {
        return this.disallowTeamMemberIslands;
    }

    public void setDisallowTeamMemberIslands(boolean disallowTeamMemberIslands) {
        this.disallowTeamMemberIslands = disallowTeamMemberIslands;
    }
}

