/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid;

import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.admin.DefaultAdminCommand;
import world.bentobox.bentobox.api.commands.island.DefaultPlayerCommand;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.configuration.WorldSettings;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.lists.Flags;
import world.bentobox.skygrid.Settings;
import world.bentobox.skygrid.generators.SkyGridBiomeProvider;
import world.bentobox.skygrid.generators.SkyGridGen;
import world.bentobox.skygrid.generators.WorldStyles;
import world.bentobox.skygrid.listeners.EndPortalListener;

public class SkyGrid
extends GameModeAddon {
    private static final String NETHER = "_nether";
    private static final String THE_END = "_the_end";
    private Settings settings;
    private WorldStyles worldStyles;
    private SkyGridGen gen;
    private final Config<Settings> configObject = new Config((Addon)this, Settings.class);

    public void onLoad() {
        this.saveDefaultConfig();
        this.loadSettings();
    }

    private void loadSettings() {
        this.settings = (Settings)this.configObject.loadConfigObject();
        if (this.settings == null) {
            this.logError("SkyGrid settings could not load! Addon disabled.");
            this.setState(Addon.State.DISABLED);
            return;
        }
        this.saveWorldSettings();
        this.worldStyles = new WorldStyles(this);
        this.gen = new SkyGridGen(this);
        this.playerCommand = new DefaultPlayerCommand(this, this){};
        this.adminCommand = new DefaultAdminCommand(this, this){};
    }

    public void onEnable() {
        Flags.values().stream().filter(f -> f.getType().equals((Object)Flag.Type.PROTECTION)).forEach(f -> f.setDefaultSetting(this.getOverWorld(), true));
        this.registerListener(new EndPortalListener(this));
    }

    public void onDisable() {
    }

    public void onReload() {
        this.loadSettings();
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void createWorlds() {
        String worldName = this.settings.getWorldName().toLowerCase();
        if (this.getServer().getWorld(worldName) == null) {
            this.getLogger().info("Creating SkyGrid world ...");
        }
        SkyGridBiomeProvider bp = new SkyGridBiomeProvider();
        this.islandWorld = WorldCreator.name((String)worldName).environment(World.Environment.NORMAL).generator((ChunkGenerator)this.gen).biomeProvider((BiomeProvider)bp).createWorld();
        if (this.settings.isNetherGenerate()) {
            if (this.getServer().getWorld(worldName + NETHER) == null) {
                this.log("Creating SkyGrid's Nether...");
            }
            this.netherWorld = WorldCreator.name((String)(worldName + NETHER)).generator((ChunkGenerator)this.gen).environment(World.Environment.NETHER).biomeProvider((BiomeProvider)bp).createWorld();
        }
        if (this.settings.isEndGenerate()) {
            if (this.getServer().getWorld(worldName + THE_END) == null) {
                this.log("Creating SkyGrid's End World...");
            }
            this.endWorld = WorldCreator.name((String)(worldName + THE_END)).generator((ChunkGenerator)this.gen).environment(World.Environment.THE_END).biomeProvider((BiomeProvider)bp).createWorld();
        }
    }

    public WorldSettings getWorldSettings() {
        return this.getSettings();
    }

    public WorldStyles getWorldStyles() {
        return this.worldStyles;
    }

    public @NonNull ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return this.gen;
    }

    public void saveWorldSettings() {
        if (this.settings != null) {
            this.configObject.saveConfigObject((Object)this.settings);
        }
    }

    public boolean isUsesNewChunkGeneration() {
        return true;
    }
}

