/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid.generators;

import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import org.bukkit.Material;

public class BlockProbability {
    private final NavigableMap<Integer, Material> probMap = new TreeMap<Integer, Material>();
    private int total = 0;

    public void addBlock(Material material, int prob) {
        this.total += prob;
        this.probMap.put(this.total, material);
    }

    public Material getBlock(Random random, boolean bottom, boolean noLiquid) {
        Material temp = (Material)this.probMap.get(random.nextInt(this.total));
        if (temp == null) {
            temp = this.probMap.ceilingEntry(random.nextInt(this.total)).getValue();
        }
        if (temp == null) {
            temp = this.probMap.firstEntry().getValue();
        }
        if (bottom && temp.equals((Object)Material.CACTUS)) {
            return this.getBlock(random, true, noLiquid);
        }
        if (noLiquid && (temp.equals((Object)Material.WATER) || temp.equals((Object)Material.LAVA))) {
            return this.getBlock(random, bottom, true);
        }
        return temp;
    }

    public int getSize() {
        return this.probMap.size();
    }

    public boolean isEmpty() {
        return this.probMap.isEmpty();
    }
}

