/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid.generators;

import java.util.EnumMap;
import java.util.Map;
import org.bukkit.World;
import org.bukkit.block.Biome;

public enum SkyGridBiomes {
    PLAINS(World.Environment.NORMAL, Biome.PLAINS, 40.0, 30.0),
    DESERT(World.Environment.NORMAL, Biome.DESERT, 60.0, 4.0),
    BADLANDS(World.Environment.NORMAL, Biome.BADLANDS, 90.0, 1.0),
    FOREST(World.Environment.NORMAL, Biome.FOREST, 50.0, 60.0),
    FLOWER_FOREST(World.Environment.NORMAL, Biome.FLOWER_FOREST, 50.0, 60.0),
    BIRCH_FOREST(World.Environment.NORMAL, Biome.BIRCH_FOREST, 50.0, 59.0),
    CHERRY_GROVE(World.Environment.NORMAL, Biome.CHERRY_GROVE, 45.0, 35.0),
    SWAMP(World.Environment.NORMAL, Biome.SWAMP, 40.0, 70.0),
    JUNGLE(World.Environment.NORMAL, Biome.JUNGLE, 60.0, 50.0),
    BAMBOO_JUNGLE(World.Environment.NORMAL, Biome.BAMBOO_JUNGLE, 60.0, 49.0),
    SAVANNA(World.Environment.NORMAL, Biome.SAVANNA, 40.0, 10.0),
    TAIGA(World.Environment.NORMAL, Biome.TAIGA, 30.0, 5.0),
    MUSHROOM_FIELDS(World.Environment.NORMAL, Biome.MUSHROOM_FIELDS, 50.0, 50.0),
    SNOWY_PLAINS(World.Environment.NORMAL, Biome.SNOWY_PLAINS, 0.0, 100.0),
    SNOWY_TAIGA(World.Environment.NORMAL, Biome.SNOWY_TAIGA, 0.0, 15.0),
    FROZEN_RIVER(World.Environment.NORMAL, Biome.FROZEN_RIVER, 10.0, 10.0),
    SNOWY_BEACH(World.Environment.NORMAL, Biome.SNOWY_BEACH, 10.0, 100.0),
    STONY_PEAKS(World.Environment.NORMAL, Biome.STONY_PEAKS, 20.0, 60.0),
    NETHER_WASTES(World.Environment.NETHER, Biome.NETHER_WASTES, 40.0, 30.0),
    SOUL_SAND_VALLEY(World.Environment.NETHER, Biome.SOUL_SAND_VALLEY, 40.0, 70.0),
    CRIMSON_FOREST(World.Environment.NETHER, Biome.CRIMSON_FOREST, 50.0, 60.0),
    WARPED_FOREST(World.Environment.NETHER, Biome.WARPED_FOREST, 20.0, 60.0),
    BASALT_DELTAS(World.Environment.NETHER, Biome.BASALT_DELTAS, 20.0, 50.0),
    THE_END(World.Environment.THE_END, Biome.THE_END, 40.0, 30.0),
    SMALL_END_ISLANDS(World.Environment.THE_END, Biome.SMALL_END_ISLANDS, 0.0, 100.0),
    END_MIDLANDS(World.Environment.THE_END, Biome.END_MIDLANDS, 50.0, 60.0),
    END_HIGHLANDS(World.Environment.THE_END, Biome.END_HIGHLANDS, 20.0, 60.0),
    END_BARRENS(World.Environment.THE_END, Biome.END_BARRENS, 60.0, 4.0);

    public final World.Environment env;
    public final Biome biome;
    public final double optimumTemperature;
    public final double optimumRainfall;

    private SkyGridBiomes(World.Environment env, Biome biome, double temp, double rain) {
        this.env = env;
        this.biome = biome;
        this.optimumTemperature = temp;
        this.optimumRainfall = rain;
    }

    public static Map<SkyGridBiomes, Double> getBiomes(World.Environment env, double temp, double rain) {
        EnumMap<SkyGridBiomes, Double> biomes = new EnumMap<SkyGridBiomes, Double>(SkyGridBiomes.class);
        SkyGridBiomes closestBiome = null;
        SkyGridBiomes secondClosestBiome = null;
        SkyGridBiomes thirdClosestBiome = null;
        double closestDist = 1.0E7;
        double secondClosestDist = 1.0E7;
        double thirdClosestDist = 1.0E7;
        for (SkyGridBiomes biome : SkyGridBiomes.values()) {
            if (!env.equals((Object)biome.env)) continue;
            double dist = SkyGridBiomes.getSquaredDistance(biome, temp, rain);
            if (dist <= closestDist) {
                thirdClosestDist = secondClosestDist;
                thirdClosestBiome = secondClosestBiome;
                secondClosestDist = closestDist;
                secondClosestBiome = closestBiome;
                closestDist = dist;
                closestBiome = biome;
                continue;
            }
            if (dist <= secondClosestDist) {
                thirdClosestDist = secondClosestDist;
                thirdClosestBiome = secondClosestBiome;
                secondClosestDist = dist;
                secondClosestBiome = biome;
                continue;
            }
            if (!(dist <= thirdClosestDist)) continue;
            thirdClosestDist = dist;
            thirdClosestBiome = biome;
        }
        biomes.put(closestBiome, 10.0 / Math.sqrt(closestDist));
        biomes.put(secondClosestBiome, 10.0 / Math.sqrt(secondClosestDist));
        biomes.put(thirdClosestBiome, 10.0 / Math.sqrt(thirdClosestDist));
        return biomes;
    }

    private static double getSquaredDistance(SkyGridBiomes biome, double temp, double rain) {
        return Math.abs((biome.optimumTemperature - temp) * (biome.optimumTemperature - temp) + (biome.optimumRainfall - rain) * (biome.optimumRainfall - rain));
    }

    public Biome getBiome() {
        return this.biome;
    }
}

