/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid.generators;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import world.bentobox.skygrid.SkyGrid;
import world.bentobox.skygrid.generators.SkyGridPop;

public class SkyGridGen
extends ChunkGenerator {
    private final SkyGrid addon;
    private final BlockPopulator populator;

    public SkyGridGen(SkyGrid addon) {
        this.addon = addon;
        this.populator = new SkyGridPop(addon);
    }

    public void generateNoise(WorldInfo worldInfo, Random r, int chunkX, int chunkZ, ChunkGenerator.ChunkData result) {
        Random rand = new Random(worldInfo.getSeed());
        result.setRegion(0, Math.min(this.addon.getSettings().getIslandHeight() + 1, worldInfo.getMaxHeight() - 1), 0, 16, worldInfo.getMaxHeight(), 16, Material.AIR);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = this.addon.getSettings().getIslandHeight(); y >= worldInfo.getMinHeight(); --y) {
                    if (Math.floorMod(x, 4) != 0 || Math.floorMod(z, 4) != 0 || Math.floorMod(y, 4) != 0) {
                        result.setBlock(x, y, z, Material.AIR);
                        continue;
                    }
                    Material m = result.getBlockData(x, y, z).getMaterial();
                    if (m != Material.AIR && m != Material.WATER) continue;
                    Material nextBlock = this.addon.getWorldStyles().get(worldInfo.getEnvironment()).getProb().getBlock(rand, y == worldInfo.getMinHeight(), true);
                    this.checkPlants(nextBlock, x, y, z, result);
                }
            }
        }
    }

    private boolean checkPlants(Material nextBlock, int x, int y, int z, ChunkGenerator.ChunkData result) {
        if (Tag.SAPLINGS.isTagged((Keyed)nextBlock) || Tag.FLOWERS.isTagged((Keyed)nextBlock) || Tag.ITEMS_VILLAGER_PLANTABLE_SEEDS.isTagged((Keyed)nextBlock)) {
            result.setBlock(x, y, z, Material.DIRT);
            result.setBlock(x, y + 1, z, nextBlock);
        } else {
            switch (nextBlock) {
                case CACTUS: 
                case DEAD_BUSH: {
                    result.setBlock(x, y, z, Material.SANDSTONE);
                    result.setBlock(x, y, z, Material.SAND);
                    result.setBlock(x, y + 2, z, nextBlock);
                    break;
                }
                case NETHER_WART: {
                    result.setBlock(x, y, z, Material.SOUL_SAND);
                    result.setBlock(x, y + 1, z, nextBlock);
                    break;
                }
                case END_ROD: 
                case CHORUS_PLANT: {
                    result.setBlock(x, y, z, Material.END_STONE);
                    result.setBlock(x, y + 1, z, nextBlock);
                    break;
                }
                case SUGAR_CANE: {
                    result.setBlock(x, y, z, Material.SANDSTONE);
                    result.setBlock(x, y + 1, z, Material.SAND);
                    result.setBlock(x, y + 2, z, nextBlock);
                    result.setBlock(x + 1, y + 1, z, Material.WATER);
                    break;
                }
                case SHORT_GRASS: 
                case TALL_GRASS: {
                    result.setBlock(x, y, z, Material.DIRT);
                    result.setBlock(x, y + 1, z, nextBlock);
                    break;
                }
                case RED_MUSHROOM: 
                case BROWN_MUSHROOM: {
                    result.setBlock(x, y, z, Material.PODZOL);
                    result.setBlock(x, y + 1, z, nextBlock);
                    break;
                }
                default: {
                    result.setBlock(x, y, z, nextBlock);
                    return false;
                }
            }
        }
        return true;
    }

    public List<BlockPopulator> getDefaultPopulators(World world) {
        ArrayList<BlockPopulator> list = new ArrayList<BlockPopulator>();
        list.addAll(super.getDefaultPopulators(world));
        list.add(this.populator);
        return list;
    }

    public Location getFixedSpawnLocation(World world, Random random) {
        return new Location(world, 0.0, (double)this.addon.getSettings().getIslandHeight() + 2.0, 0.0);
    }

    public boolean shouldGenerateNoise() {
        return true;
    }

    public boolean shouldGenerateSurface() {
        return true;
    }

    public boolean shouldGenerateCaves() {
        return true;
    }

    public boolean shouldGenerateDecorations() {
        return true;
    }

    public boolean shouldGenerateMobs() {
        return true;
    }

    public boolean shouldGenerateStructures() {
        return true;
    }
}

