/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.skygrid.generators;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.EndPortalFrame;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import world.bentobox.skygrid.SkyGrid;
import world.bentobox.skygrid.generators.RandomSeries;

public class SkyGridPop
extends BlockPopulator {
    private static final RandomSeries slt = new RandomSeries(27);
    private final int islandHeight;
    private final SkyGrid addon;
    private final NavigableMap<Integer, Material> chestItemsWorld = new TreeMap<Integer, Material>();
    private final NavigableMap<Integer, Material> chestItemsNether = new TreeMap<Integer, Material>();
    private final NavigableMap<Integer, Material> chestItemsEnd = new TreeMap<Integer, Material>();
    private int worldTotal;
    private int netherTotal;
    private int endTotal;
    private Map<UUID, Random> rand = new ConcurrentHashMap<UUID, Random>();
    private Random random = new Random();
    private static final Material[] SAPLING_TYPE = new Material[]{Material.ACACIA_SAPLING, Material.BIRCH_SAPLING, Material.DARK_OAK_SAPLING, Material.JUNGLE_SAPLING, Material.OAK_SAPLING, Material.SPRUCE_SAPLING};
    private static final String LOADED = "Loaded ";

    public SkyGridPop(SkyGrid addon) {
        this.addon = addon;
        this.islandHeight = addon.getSettings().getIslandHeight();
        for (Map.Entry<Material, Integer> en : addon.getSettings().getChestItemsOverworld().entrySet()) {
            if (en.getKey().isItem()) {
                this.worldTotal += en.getValue().intValue();
                this.chestItemsWorld.put(this.worldTotal, en.getKey());
                continue;
            }
            addon.logWarning(String.valueOf(en.getKey()) + " is not an item so cannot go in a chest.");
        }
        for (Map.Entry<Material, Integer> en : addon.getSettings().getChestItemsNether().entrySet()) {
            if (en.getKey().isItem()) {
                this.netherTotal += en.getValue().intValue();
                this.chestItemsNether.put(this.netherTotal, en.getKey());
                continue;
            }
            addon.logWarning(String.valueOf(en.getKey()) + " is not an item so cannot go in a chest.");
        }
        for (Map.Entry<Material, Integer> en : addon.getSettings().getChestItemsEnd().entrySet()) {
            if (en.getKey().isItem()) {
                this.endTotal += en.getValue().intValue();
                this.chestItemsEnd.put(this.endTotal, en.getKey());
                continue;
            }
            addon.logWarning(String.valueOf(en.getKey()) + " is not an item so cannot go in a chest.");
        }
        addon.log(LOADED + this.chestItemsWorld.size() + " chest items for world");
        addon.log(LOADED + this.chestItemsNether.size() + " chest items for nether world");
        addon.log(LOADED + this.chestItemsEnd.size() + " chest items for end world");
    }

    private Location getLoc(World world, int x, int y, int z, int chunkX, int chunkZ) {
        Vector v = new Vector(x, y, z);
        return v.add(new Vector(chunkX << 4, 0, chunkZ << 4)).toLocation(world);
    }

    public void populate(WorldInfo worldInfo, Random random, int chunkX, int chunkZ, LimitedRegion region) {
        random = this.rand.computeIfAbsent(worldInfo.getUID(), b -> new Random(worldInfo.getSeed()));
        World world = Bukkit.getWorld((UUID)worldInfo.getUID());
        for (int x = 0; x < 16; x += 4) {
            for (int z = 0; z < 16; z += 4) {
                for (int y = worldInfo.getMinHeight(); y <= this.islandHeight; y += 4) {
                    Location loc = this.getLoc(world, x, y, z, chunkX, chunkZ);
                    this.alterBlocks(region, loc, worldInfo.getEnvironment());
                }
            }
        }
        if (this.addon.getSettings().isEndGenerate() && worldInfo.getEnvironment().equals((Object)World.Environment.NORMAL) && random.nextDouble() < this.addon.getSettings().getEndFrameProb()) {
            this.makeEndPortal(region, chunkX, chunkZ);
        }
    }

    private void alterBlocks(LimitedRegion region, Location loc, World.Environment environment) {
        Material m = region.getBlockData(loc).getMaterial();
        switch (m) {
            case CHEST: {
                this.setChest(region, loc, environment);
                break;
            }
            case SPAWNER: {
                this.setSpawner(region, loc, environment);
                break;
            }
            case DIRT: {
                if (!Tag.SAPLINGS.isTagged((Keyed)m)) break;
                if (region.getBiome(loc).equals((Object)Biome.DESERT)) {
                    region.setType(loc, Material.SAND);
                    break;
                }
                this.setSaplingType(region, loc);
                break;
            }
        }
    }

    private void makeEndPortal(LimitedRegion region, int chunkX, int chunkZ) {
        int y = this.addon.getSettings().getEndFrameHeight();
        for (int xx = 1; xx < 6; ++xx) {
            for (int zz = 1; zz < 6; ++zz) {
                if (xx == zz || xx == 1 && zz == 5 || xx == 5 && zz == 1 || xx > 1 && xx < 5 && zz > 1 && zz < 5) continue;
                int x = xx + (chunkX << 4);
                int z = zz + (chunkZ << 4);
                region.setType(x, y, z, Material.END_PORTAL_FRAME);
                EndPortalFrame endFrame = (EndPortalFrame)region.getBlockData(x, y, z);
                endFrame.setEye(this.random.nextDouble() < 0.8);
                if (zz == 1) {
                    endFrame.setFacing(BlockFace.SOUTH);
                } else if (zz == 5) {
                    endFrame.setFacing(BlockFace.NORTH);
                } else if (xx == 1) {
                    endFrame.setFacing(BlockFace.EAST);
                } else {
                    endFrame.setFacing(BlockFace.WEST);
                }
                region.setBlockData(x, y, z, (BlockData)endFrame);
            }
        }
    }

    private void setSaplingType(LimitedRegion region, Location loc) {
        Material sapling = switch (region.getBiome(loc).getKey().getKey()) {
            case "jungle" -> Material.JUNGLE_SAPLING;
            case "plains" -> {
                if (this.random.nextBoolean()) {
                    yield Material.BIRCH_SAPLING;
                }
                yield Material.OAK_SAPLING;
            }
            case "taiga" -> Material.SPRUCE_SAPLING;
            case "swamp" -> Material.MANGROVE_PROPAGULE;
            case "desert" -> Material.DEAD_BUSH;
            case "badlands" -> Material.DEAD_BUSH;
            case "cherry_grove" -> Material.CHERRY_SAPLING;
            case "bamboo_jungle" -> Material.BAMBOO;
            case "savana" -> Material.ACACIA_SAPLING;
            case "birch_forest" -> Material.BIRCH_SAPLING;
            case "mushroom_fields" -> {
                if (this.random.nextBoolean()) {
                    yield Material.RED_MUSHROOM;
                }
                yield Material.BROWN_MUSHROOM;
            }
            default -> SAPLING_TYPE[this.random.nextInt(6)];
        };
        region.setType(loc.add(new Vector(0, 1, 0)), sapling);
    }

    private void setSpawner(LimitedRegion region, Location loc, World.Environment environment) {
        CreatureSpawner spawner = (CreatureSpawner)region.getBlockState(loc);
        NavigableMap<Integer, EntityType> spawns = this.addon.getWorldStyles().get(environment).getSpawns();
        int randKey = this.random.nextInt((Integer)spawns.lastKey());
        EntityType type = spawns.ceilingEntry(randKey).getValue();
        spawner.setDelay(120);
        spawner.setSpawnedType(type);
        spawner.update(true, false);
    }

    private void setChest(LimitedRegion region, Location loc, World.Environment environment) {
        Chest chest = (Chest)region.getBlockState(loc);
        Inventory inv = chest.getBlockInventory();
        slt.reset();
        switch (environment) {
            case NETHER: {
                this.fillChest(inv, this.chestItemsNether, this.addon.getSettings().getChestFillNether(), this.netherTotal);
                break;
            }
            case THE_END: {
                this.fillChest(inv, this.chestItemsEnd, this.addon.getSettings().getChestFillEnd(), this.endTotal);
                break;
            }
            default: {
                this.fillChest(inv, this.chestItemsWorld, this.addon.getSettings().getChestFill(), this.worldTotal);
            }
        }
    }

    private void fillChest(Inventory inv, NavigableMap<Integer, Material> probMap, int chestFill, int total) {
        for (int i = 0; !probMap.isEmpty() && i < chestFill && i < 27; ++i) {
            Material temp = (Material)probMap.get(this.random.nextInt(total));
            if (temp == null) {
                temp = probMap.ceilingEntry(this.random.nextInt(total)).getValue();
            }
            if (temp == null) {
                temp = probMap.firstEntry().getValue();
            }
            inv.setItem(slt.next(), new ItemStack(temp));
        }
    }
}

