/*
 * Decompiled with CFR 0.152.
 */
package com.reviewx;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ReviewX
extends JavaPlugin
implements Listener {
    private File reviewsFolder;
    private List<String> reviewFiles = new ArrayList<String>();
    private int readIndex = 0;
    private Map<UUID, ReviewSession> activeSessions = new HashMap<UUID, ReviewSession>();
    private static final String GUI_TITLE = String.valueOf((Object)ChatColor.DARK_PURPLE) + "ReviewX - Submit a Review";

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.reviewsFolder = new File(this.getDataFolder(), "reviews");
        if (!this.reviewsFolder.exists()) {
            this.reviewsFolder.mkdirs();
        }
        this.loadReviewFiles();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getLogger().info("ReviewX has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("ReviewX has been disabled!");
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("review")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Only players can use this command!");
                return true;
            }
            Player player = (Player)sender;
            if (!this.checkCooldown(player)) {
                long remainingTime = this.getCooldownTime(player);
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You need to wait " + this.formatTime(remainingTime) + " before submitting another review.");
                return true;
            }
            if (this.activeSessions.containsKey(player.getUniqueId())) {
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You are already writing a review!");
                return true;
            }
            this.openReviewGui(player);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("readreviews")) {
            if (!sender.hasPermission("reviewx.read")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to read reviews!");
                return true;
            }
            if (this.reviewFiles.isEmpty()) {
                sender.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "There are no reviews to read!");
                return true;
            }
            if (args.length > 0 && args[0].equalsIgnoreCase("next")) {
                this.readIndex = (this.readIndex + 1) % this.reviewFiles.size();
            } else if (args.length > 0 && args[0].equalsIgnoreCase("prev")) {
                this.readIndex = (this.readIndex - 1 + this.reviewFiles.size()) % this.reviewFiles.size();
            } else if (args.length > 0 && args[0].equalsIgnoreCase("list")) {
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Available reviews: " + this.reviewFiles.size());
                for (int i = 0; i < this.reviewFiles.size(); ++i) {
                    String filename = this.reviewFiles.get(i);
                    sender.sendMessage(String.valueOf((Object)ChatColor.GRAY) + "[" + (i + 1) + "] " + String.valueOf((Object)ChatColor.YELLOW) + filename);
                }
                return true;
            }
            try {
                String filename = this.reviewFiles.get(this.readIndex);
                Path filePath = Paths.get(this.reviewsFolder.getPath(), filename);
                String content = new String(Files.readAllBytes(filePath));
                sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Review " + (this.readIndex + 1) + " of " + this.reviewFiles.size() + ": " + String.valueOf((Object)ChatColor.YELLOW) + filename);
                sender.sendMessage(String.valueOf((Object)ChatColor.WHITE) + content);
                sender.sendMessage(String.valueOf((Object)ChatColor.GRAY) + "Use /readreviews next or /readreviews prev to navigate reviews.");
            }
            catch (IOException e) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "Error reading review file!");
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onBookEdit(PlayerEditBookEvent event) {
        BookMeta meta = event.getNewBookMeta();
        if (meta.hasTitle() && meta.getTitle().startsWith("ReviewX:")) {
            Player player = event.getPlayer();
            List<String> pages = meta.getPages();
            if (pages.isEmpty() || pages.get(0).trim().isEmpty()) {
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Your review cannot be empty!");
                return;
            }
            this.saveReview(player, meta);
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                if (player.getInventory().getItemInMainHand().getType() == Material.WRITTEN_BOOK || player.getInventory().getItemInMainHand().getType() == Material.WRITABLE_BOOK) {
                    player.getInventory().setItemInMainHand(null);
                }
                if (player.getInventory().getItemInOffHand().getType() == Material.WRITTEN_BOOK || player.getInventory().getItemInOffHand().getType() == Material.WRITABLE_BOOK) {
                    player.getInventory().setItemInOffHand(null);
                }
                player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Your review has been submitted. Thank you!");
            });
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        ItemStack clickedItem = event.getCurrentItem();
        if (event.getView().getTitle().equals(GUI_TITLE)) {
            event.setCancelled(true);
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            if (clickedItem.getType() == Material.EMERALD_BLOCK && clickedItem.getItemMeta().getDisplayName().contains("Submit Review")) {
                ReviewSession session = this.activeSessions.get(player.getUniqueId());
                if (session != null && !session.getContent().isEmpty()) {
                    this.saveReviewFromSession(player, session);
                    player.closeInventory();
                    this.activeSessions.remove(player.getUniqueId());
                    player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Your review has been submitted. Thank you!");
                    this.setCooldown(player);
                } else {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You cannot submit an empty review!");
                }
            } else if (clickedItem.getType() == Material.BOOK && clickedItem.getItemMeta().getDisplayName().contains("Write Review")) {
                player.closeInventory();
                if (!this.activeSessions.containsKey(player.getUniqueId())) {
                    this.activeSessions.put(player.getUniqueId(), new ReviewSession(this));
                }
                ReviewSession session = this.activeSessions.get(player.getUniqueId());
                session.setWritingInChat(true);
                this.openReviewInputInterface(player);
            } else if (clickedItem.getType() == Material.REDSTONE_BLOCK && clickedItem.getItemMeta().getDisplayName().contains("Cancel")) {
                player.closeInventory();
                this.activeSessions.remove(player.getUniqueId());
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Review cancelled.");
            }
        } else if (event.getView().getTitle().equals(String.valueOf((Object)ChatColor.DARK_PURPLE) + "Submit Your Review")) {
            event.setCancelled(true);
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            ReviewSession session = this.activeSessions.get(player.getUniqueId());
            if (clickedItem.getType() == Material.EMERALD_BLOCK) {
                if (session != null && !session.getContent().isEmpty()) {
                    this.saveReviewFromSession(player, session);
                    player.closeInventory();
                    this.activeSessions.remove(player.getUniqueId());
                    player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Your review has been submitted. Thank you!");
                    this.setCooldown(player);
                } else {
                    player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Please type your review before submitting!");
                }
            } else if (clickedItem.getType() == Material.REDSTONE_BLOCK) {
                player.closeInventory();
                this.activeSessions.remove(player.getUniqueId());
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Review cancelled.");
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        ReviewSession session;
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (event.getView().getTitle().equals(GUI_TITLE) && (session = this.activeSessions.get(player.getUniqueId())) != null && !session.isWritingInChat()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                if (this.activeSessions.containsKey(player.getUniqueId())) {
                    player.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "You can continue your review by using /review again.");
                }
            }, 1L);
        }
    }

    private void updateReviewInputInterface(Player player, String reviewContent) {
        InventoryView view = player.getOpenInventory();
        Inventory inventory = view.getTopInventory();
        if (view.getTitle().equals(String.valueOf((Object)ChatColor.DARK_PURPLE) + "Submit Your Review")) {
            ItemStack reviewItem = inventory.getItem(11);
            if (reviewItem != null) {
                ItemMeta reviewMeta = reviewItem.getItemMeta();
                reviewMeta.setDisplayName(String.valueOf((Object)ChatColor.GREEN) + "Your Review");
                ArrayList<String> reviewLore = new ArrayList<String>();
                String contentToShow = reviewContent;
                if (contentToShow.length() > 40) {
                    reviewLore.add(String.valueOf((Object)ChatColor.WHITE) + contentToShow.substring(0, 37) + "...");
                } else {
                    reviewLore.add(String.valueOf((Object)ChatColor.WHITE) + contentToShow);
                }
                reviewMeta.setLore(reviewLore);
                reviewItem.setItemMeta(reviewMeta);
            }
            ItemStack submitButton = new ItemStack(Material.EMERALD_BLOCK);
            ItemMeta submitMeta = submitButton.getItemMeta();
            submitMeta.setDisplayName(String.valueOf((Object)ChatColor.GREEN) + "Submit Review");
            ArrayList<String> submitLore = new ArrayList<String>();
            submitLore.add(String.valueOf((Object)ChatColor.GRAY) + "Click to submit your review");
            submitMeta.setLore(submitLore);
            submitButton.setItemMeta(submitMeta);
            inventory.setItem(15, submitButton);
            ItemStack instructions = inventory.getItem(4);
            if (instructions != null) {
                ItemMeta instructionsMeta = instructions.getItemMeta();
                instructionsMeta.setDisplayName(String.valueOf((Object)ChatColor.YELLOW) + "Review Ready");
                ArrayList<String> instructionsLore = new ArrayList<String>();
                instructionsLore.add(String.valueOf((Object)ChatColor.GRAY) + "Your review has been recorded");
                instructionsLore.add(String.valueOf((Object)ChatColor.GRAY) + "Click Submit to confirm");
                instructionsMeta.setLore(instructionsLore);
                instructions.setItemMeta(instructionsMeta);
            }
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        ReviewSession session = this.activeSessions.get(player.getUniqueId());
        if (session != null && session.isWritingInChat()) {
            event.setCancelled(true);
            session.setContent(message);
            session.setWritingInChat(false);
            Bukkit.getScheduler().runTask((Plugin)this, () -> {
                this.openReviewInputInterface(player);
                this.updateReviewInputInterface(player, message);
            });
        }
    }

    private void openReviewInputInterface(Player player) {
        Inventory gui = Bukkit.createInventory(null, 27, String.valueOf((Object)ChatColor.DARK_PURPLE) + "Submit Your Review");
        ItemStack instructions = new ItemStack(Material.PAPER);
        ItemMeta instructionsMeta = instructions.getItemMeta();
        instructionsMeta.setDisplayName(String.valueOf((Object)ChatColor.YELLOW) + "Type your review in chat");
        ArrayList<String> instructionsLore = new ArrayList<String>();
        instructionsLore.add(String.valueOf((Object)ChatColor.GRAY) + "Type your review in chat (one line)");
        instructionsLore.add(String.valueOf((Object)ChatColor.GRAY) + "Then click the Submit button below");
        instructionsMeta.setLore(instructionsLore);
        instructions.setItemMeta(instructionsMeta);
        gui.setItem(4, instructions);
        ItemStack submitButton = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta submitMeta = submitButton.getItemMeta();
        submitMeta.setDisplayName(String.valueOf((Object)ChatColor.GRAY) + "Submit Review");
        ArrayList<String> submitLore = new ArrayList<String>();
        submitLore.add(String.valueOf((Object)ChatColor.GRAY) + "Type your review in chat first");
        submitMeta.setLore(submitLore);
        submitButton.setItemMeta(submitMeta);
        gui.setItem(15, submitButton);
        ItemStack cancelButton = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf((Object)ChatColor.RED) + "Cancel");
        ArrayList<String> cancelLore = new ArrayList<String>();
        cancelLore.add(String.valueOf((Object)ChatColor.GRAY) + "Click to cancel your review");
        cancelMeta.setLore(cancelLore);
        cancelButton.setItemMeta(cancelMeta);
        gui.setItem(22, cancelButton);
        ItemStack reviewContent = new ItemStack(Material.WRITABLE_BOOK);
        ItemMeta reviewMeta = reviewContent.getItemMeta();
        reviewMeta.setDisplayName(String.valueOf((Object)ChatColor.GREEN) + "Your Review");
        ArrayList<String> reviewLore = new ArrayList<String>();
        reviewLore.add(String.valueOf((Object)ChatColor.GRAY) + "Type in chat to add your review");
        reviewMeta.setLore(reviewLore);
        reviewContent.setItemMeta(reviewMeta);
        gui.setItem(11, reviewContent);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            gui.setItem(i, filler);
        }
        player.openInventory(gui);
        player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Please type your review in chat now (one line only).");
    }

    private void openReviewGui(Player player) {
        Inventory gui = Bukkit.createInventory(null, 27, GUI_TITLE);
        ReviewSession session = this.activeSessions.get(player.getUniqueId());
        if (session == null) {
            session = new ReviewSession(this);
            this.activeSessions.put(player.getUniqueId(), session);
        }
        ItemStack bookItem = new ItemStack(Material.BOOK);
        ItemMeta bookMeta = bookItem.getItemMeta();
        bookMeta.setDisplayName(String.valueOf((Object)ChatColor.GREEN) + "Write Review");
        ArrayList<String> bookLore = new ArrayList<String>();
        bookLore.add(String.valueOf((Object)ChatColor.GRAY) + "Click to write your review in chat");
        bookLore.add("");
        if (!session.getContent().isEmpty()) {
            bookLore.add(String.valueOf((Object)ChatColor.YELLOW) + "Current review:");
            String[] lines = session.getContent().split("\n");
            for (int i = 0; i < Math.min(3, lines.length); ++i) {
                Object line = lines[i];
                if (((String)line).length() > 30) {
                    line = ((String)line).substring(0, 27) + "...";
                }
                bookLore.add(String.valueOf((Object)ChatColor.GRAY) + (String)line);
            }
            if (lines.length > 3) {
                bookLore.add(String.valueOf((Object)ChatColor.GRAY) + "...");
            }
        } else {
            bookLore.add(String.valueOf((Object)ChatColor.YELLOW) + "No content yet");
        }
        bookMeta.setLore(bookLore);
        bookItem.setItemMeta(bookMeta);
        gui.setItem(11, bookItem);
        ItemStack submitButton = new ItemStack(Material.EMERALD_BLOCK);
        ItemMeta submitMeta = submitButton.getItemMeta();
        submitMeta.setDisplayName(String.valueOf((Object)ChatColor.GREEN) + "Submit Review");
        ArrayList<String> submitLore = new ArrayList<String>();
        submitLore.add(String.valueOf((Object)ChatColor.GRAY) + "Click to submit your review");
        submitMeta.setLore(submitLore);
        submitButton.setItemMeta(submitMeta);
        gui.setItem(15, submitButton);
        ItemStack cancelButton = new ItemStack(Material.REDSTONE_BLOCK);
        ItemMeta cancelMeta = cancelButton.getItemMeta();
        cancelMeta.setDisplayName(String.valueOf((Object)ChatColor.RED) + "Cancel");
        ArrayList<String> cancelLore = new ArrayList<String>();
        cancelLore.add(String.valueOf((Object)ChatColor.GRAY) + "Click to cancel your review");
        cancelMeta.setLore(cancelLore);
        cancelButton.setItemMeta(cancelMeta);
        gui.setItem(22, cancelButton);
        ItemStack infoItem = new ItemStack(Material.PAPER);
        ItemMeta infoMeta = infoItem.getItemMeta();
        infoMeta.setDisplayName(String.valueOf((Object)ChatColor.YELLOW) + "How to Submit a Review");
        ArrayList<String> infoLore = new ArrayList<String>();
        infoLore.add(String.valueOf((Object)ChatColor.GRAY) + "1. Click on the book to write your review");
        infoLore.add(String.valueOf((Object)ChatColor.GRAY) + "2. Type your review in chat");
        infoLore.add(String.valueOf((Object)ChatColor.GRAY) + "3. Type '/submit' when you're finished");
        infoLore.add(String.valueOf((Object)ChatColor.GRAY) + "4. Or type '/cancel' to cancel");
        infoMeta.setLore(infoLore);
        infoItem.setItemMeta(infoMeta);
        gui.setItem(4, infoItem);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fillerMeta = filler.getItemMeta();
        fillerMeta.setDisplayName(" ");
        filler.setItemMeta(fillerMeta);
        for (int i = 0; i < gui.getSize(); ++i) {
            if (gui.getItem(i) != null) continue;
            gui.setItem(i, filler);
        }
        player.openInventory(gui);
    }

    private void saveReviewFromSession(Player player, ReviewSession session) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = dateFormat.format(new Date());
            String filename = player.getName() + "_" + timestamp + ".txt";
            File reviewFile = new File(this.reviewsFolder, filename);
            FileWriter writer = new FileWriter(reviewFile);
            writer.write("Player: " + player.getName() + "\n");
            writer.write("UUID: " + String.valueOf(player.getUniqueId()) + "\n");
            writer.write("Time: " + timestamp + "\n");
            writer.write("Review:\n\n");
            writer.write(session.getContent());
            writer.close();
            this.reviewFiles.add(filename);
            this.getLogger().info(player.getName() + " submitted a review.");
            if (this.getConfig().getBoolean("notify-admins-on-submit")) {
                for (Player player2 : Bukkit.getOnlinePlayers()) {
                    if (!player2.hasPermission("reviewx.read")) continue;
                    player2.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "[ReviewX] " + String.valueOf((Object)ChatColor.YELLOW) + player.getName() + String.valueOf((Object)ChatColor.GREEN) + " has submitted a new review! Use /readreviews to read it.");
                }
            }
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Error saving your review!");
            e.printStackTrace();
        }
    }

    private void saveReview(Player player, BookMeta meta) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            String timestamp = dateFormat.format(new Date());
            String filename = player.getName() + "_" + timestamp + ".txt";
            File reviewFile = new File(this.reviewsFolder, filename);
            FileWriter writer = new FileWriter(reviewFile);
            writer.write("Player: " + player.getName() + "\n");
            writer.write("UUID: " + String.valueOf(player.getUniqueId()) + "\n");
            writer.write("Time: " + timestamp + "\n");
            writer.write("Review:\n\n");
            for (String string : meta.getPages()) {
                writer.write(string + "\n\n");
            }
            writer.close();
            this.reviewFiles.add(filename);
            this.getLogger().info(player.getName() + " submitted a review.");
            this.setCooldown(player);
            if (this.getConfig().getBoolean("notify-admins-on-submit")) {
                for (Player player2 : Bukkit.getOnlinePlayers()) {
                    if (!player2.hasPermission("reviewx.read")) continue;
                    player2.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "[ReviewX] " + String.valueOf((Object)ChatColor.YELLOW) + player.getName() + String.valueOf((Object)ChatColor.GREEN) + " has submitted a new review! Use /readreviews to read it.");
                }
            }
        }
        catch (IOException e) {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Error saving your review!");
            e.printStackTrace();
        }
    }

    private void loadReviewFiles() {
        this.reviewFiles.clear();
        File[] files = this.reviewsFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                this.reviewFiles.add(file.getName());
            }
        }
    }

    private boolean checkCooldown(Player player) {
        if (player.hasPermission("reviewx.nocooldown")) {
            return true;
        }
        long cooldownTime = this.getConfig().getLong("cooldown-time") * 1000L;
        if (cooldownTime <= 0L) {
            return true;
        }
        String lastUseTimeStr = this.getConfig().getString("cooldowns." + String.valueOf(player.getUniqueId()));
        if (lastUseTimeStr == null) {
            return true;
        }
        try {
            long lastUseTime = Long.parseLong(lastUseTimeStr);
            long currentTime = System.currentTimeMillis();
            return currentTime - lastUseTime >= cooldownTime;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    private long getCooldownTime(Player player) {
        long cooldownTime = this.getConfig().getLong("cooldown-time") * 1000L;
        String lastUseTimeStr = this.getConfig().getString("cooldowns." + String.valueOf(player.getUniqueId()));
        if (lastUseTimeStr == null) {
            return 0L;
        }
        try {
            long lastUseTime = Long.parseLong(lastUseTimeStr);
            long currentTime = System.currentTimeMillis();
            long timeElapsed = currentTime - lastUseTime;
            return Math.max(0L, cooldownTime - timeElapsed);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private void setCooldown(Player player) {
        if (this.getConfig().getLong("cooldown-time") <= 0L || player.hasPermission("reviewx.nocooldown")) {
            return;
        }
        this.getConfig().set("cooldowns." + String.valueOf(player.getUniqueId()), System.currentTimeMillis());
        this.saveConfig();
    }

    private String formatTime(long milliseconds) {
        long seconds = milliseconds / 1000L;
        long minutes = seconds / 60L;
        seconds %= 60L;
        if (minutes > 0L) {
            return minutes + " minute(s) and " + seconds + " second(s)";
        }
        return seconds + " second(s)";
    }

    private class ReviewSession {
        private StringBuilder content = new StringBuilder();
        private boolean writingInChat = false;

        private ReviewSession(ReviewX reviewX) {
        }

        public void addLine(String line) {
            if (this.content.length() > 0) {
                this.content.append("\n");
            }
            this.content.append(line);
        }

        public void setContent(String text) {
            this.content = new StringBuilder(text);
        }

        public String getContent() {
            return this.content.toString();
        }

        public void setWritingInChat(boolean writing) {
            this.writingInChat = writing;
        }

        public boolean isWritingInChat() {
            return this.writingInChat;
        }
    }
}

