/*
 * Decompiled with CFR 0.152.
 */
package me.vewa.rmbnametags;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vewa.rmbnametags.ReloadCommand;
import me.vewa.rmbnametags.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class RMBNametags
extends JavaPlugin
implements Listener {
    private Scoreboard board;
    private Team hiddenNamesTeam;
    private int displayTime;
    private String nameFormat;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getLogger().info("Config loaded: display-time=" + this.displayTime + "s, format=" + this.nameFormat);
        new Metrics(this, 22888);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("rmbnametags_reload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getLogger().info("Events and command registered successfully.");
        this.board = Bukkit.getScoreboardManager().getNewScoreboard();
        this.hiddenNamesTeam = this.board.registerNewTeam("hiddenNames");
        this.hiddenNamesTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        this.getLogger().info("Custom scoreboard created, hiddenNames team registered.");
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.hidePlayerName(player);
        }
    }

    public void onDisable() {
    }

    public void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.displayTime = config.getInt("display-time", 3);
        this.nameFormat = config.getString("name-format", "&6{PLAYER_NAME}");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.hidePlayerName(event.getPlayer());
    }

    private void hidePlayerName(Player player) {
        this.hiddenNamesTeam.addEntry(player.getName());
        player.setScoreboard(this.board);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player clickedPlayer = (Player)event.getRightClicked();
        if (clickedPlayer.isInvisible()) {
            return;
        }
        Player clickingPlayer = event.getPlayer();
        this.showPlayerNameInActionbar(clickingPlayer, clickedPlayer);
    }

    private void showPlayerNameInActionbar(final Player clickingPlayer, Player clickedPlayer) {
        String formattedName = this.colorize(this.nameFormat.replace("{PLAYER_NAME}", clickedPlayer.getName()));
        clickingPlayer.sendActionBar(formattedName);
        new BukkitRunnable(this){
            final /* synthetic */ RMBNametags this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                clickingPlayer.sendActionBar("");
            }
        }.runTaskLater((Plugin)this, (long)this.displayTime * 20L);
    }

    private String colorize(String input) {
        Pattern hexPattern = Pattern.compile("#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String color = matcher.group(1);
            matcher.appendReplacement(buffer, net.md_5.bungee.api.ChatColor.of((String)("#" + color)).toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }
}

