/*
 * Decompiled with CFR 0.152.
 */
package me.vewa.rmbnametags;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.vewa.rmbnametags.ReloadCommand;
import me.vewa.rmbnametags.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class RMBNametags
extends JavaPlugin
implements Listener {
    private static final Pattern HEX_PATTERN = Pattern.compile("#([A-Fa-f0-9]{6})");
    private Scoreboard board;
    private Team hiddenNamesTeam;
    private int displayTimeSeconds;
    private String nameFormat;
    private boolean respectInvisibility;
    private DisplayLocation displayLocation;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        new Metrics(this, 22888);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.getCommand("rmbnametags_reload") != null) {
            this.getCommand("rmbnametags_reload").setExecutor((CommandExecutor)new ReloadCommand(this));
        }
        this.board = Bukkit.getScoreboardManager().getNewScoreboard();
        this.hiddenNamesTeam = this.board.registerNewTeam("hiddenNames");
        this.hiddenNamesTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        this.hiddenNamesTeam.setCanSeeFriendlyInvisibles(false);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.hidePlayerName(player);
        }
        this.getLogger().info(() -> String.format("Config loaded: display-time=%ds, format=%s, respect-invisibility=%s, display-location=%s", new Object[]{this.displayTimeSeconds, this.nameFormat, this.respectInvisibility, this.displayLocation}));
    }

    public void onDisable() {
    }

    public void loadConfig() {
        this.reloadConfig();
        FileConfiguration cfg = this.getConfig();
        this.displayTimeSeconds = Math.max(0, cfg.getInt("display-time", 3));
        this.nameFormat = cfg.getString("name-format", "&6{PLAYER_NAME}");
        this.respectInvisibility = cfg.getBoolean("respect-invisibility", true);
        this.displayLocation = DisplayLocation.fromConfig(cfg.getString("display-location", "actionbar"));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.hidePlayerName(event.getPlayer());
    }

    private void hidePlayerName(Player player) {
        if (!this.hiddenNamesTeam.hasEntry(player.getName())) {
            this.hiddenNamesTeam.addEntry(player.getName());
        }
        player.setScoreboard(this.board);
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!(event.getRightClicked() instanceof Player)) {
            return;
        }
        Player clickedPlayer = (Player)event.getRightClicked();
        if (this.respectInvisibility && this.isEffectivelyInvisible(clickedPlayer)) {
            return;
        }
        this.showConfigured(event.getPlayer(), clickedPlayer);
    }

    private boolean isEffectivelyInvisible(Player player) {
        return player.hasPotionEffect(PotionEffectType.INVISIBILITY) || player.isInvisible();
    }

    private void showConfigured(final Player viewer, Player target) {
        String formatted = this.colorize(this.nameFormat.replace("{PLAYER_NAME}", target.getName()));
        switch (this.displayLocation.ordinal()) {
            case 1: {
                int stay = Math.max(1, this.displayTimeSeconds) * 20;
                viewer.sendTitle("", formatted, 0, stay, 10);
                break;
            }
            default: {
                viewer.sendActionBar(formatted);
                if (this.displayTimeSeconds <= 0) break;
                new BukkitRunnable(this){
                    final /* synthetic */ RMBNametags this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public void run() {
                        viewer.sendActionBar("");
                    }
                }.runTaskLater((Plugin)this, (long)this.displayTimeSeconds * 20L);
            }
        }
    }

    private String colorize(String input) {
        Matcher m = HEX_PATTERN.matcher(input);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            String color = m.group(1);
            m.appendReplacement(buf, net.md_5.bungee.api.ChatColor.of((String)("#" + color)).toString());
        }
        m.appendTail(buf);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buf.toString());
    }

    private static enum DisplayLocation {
        ACTIONBAR,
        SUBTITLE;


        static DisplayLocation fromConfig(String raw) {
            if (raw == null) {
                return ACTIONBAR;
            }
            switch (raw.trim().toUpperCase(Locale.ROOT)) {
                case "SUBTITLE": {
                    return SUBTITLE;
                }
            }
            return ACTIONBAR;
        }
    }
}

