/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healthbarplus.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.numbits.healthbarplus.core.NameplateHealthScraper;
import dev.numbits.healthbarplus.keybind.KeybindManager;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5617;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_922.class})
public abstract class LivingEntityRendererHpBarMixin<T extends class_1309>
extends class_897<T> {
    private static final float HP_BAR_WIDTH = 100.0f;
    private static final float HP_BAR_HEIGHT = 10.0f;
    private static final float HP_BAR_Y = 4.0f;

    protected LivingEntityRendererHpBarMixin(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Inject(method={"render(Lnet/minecraft/entity/LivingEntity;FFLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;I)V"}, at={@At(value="TAIL")})
    private void hpbar$renderHpBar(T entity, float f, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, CallbackInfo ci) {
        class_1657 player;
        block10: {
            block9: {
                if (!(entity instanceof class_1657)) break block9;
                player = (class_1657)entity;
                if (KeybindManager.enabled) break block10;
            }
            return;
        }
        class_310 client = class_310.method_1551();
        class_746 localPlayer = client.field_1724;
        if (localPlayer == null) {
            return;
        }
        if (player == localPlayer) {
            return;
        }
        if (player.method_29504() || player.method_7325()) {
            return;
        }
        NameplateHealthScraper.HealthInfo info = NameplateHealthScraper.getHealthInfo(player);
        if (info == null) {
            return;
        }
        float maxHealth = player.method_6063();
        if (maxHealth <= 0.0f) {
            return;
        }
        float health = class_3532.method_15363((float)info.health, (float)0.0f, (float)maxHealth);
        float ratio = maxHealth > 0.0f ? health / maxHealth : 0.0f;
        double distanceSq = this.field_4676.method_23168((class_1297)player);
        if (distanceSq > 1024.0) {
            return;
        }
        matrices.method_22903();
        double yOffset = player.method_17682() + 1.1f;
        matrices.method_22904(0.0, yOffset, 0.0);
        class_4184 camera = client.field_1773.method_19418();
        float camYaw = camera.method_19330();
        float camPitch = camera.method_19329();
        matrices.method_22907(class_7833.field_40715.rotationDegrees(camYaw));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(camPitch));
        float scale = 0.025f;
        matrices.method_22905(-scale, -scale, scale);
        class_327 textRenderer = client.field_1772;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        this.drawHpBarQuad(matrices, ratio);
        int hpInt = Math.round(health);
        int maxHpInt = Math.round(maxHealth);
        class_5250 hpText = class_2561.method_43470((String)String.valueOf(hpInt)).method_27694(style -> style.method_36139(0xFFFFFF));
        class_5250 slashTxt = class_2561.method_43470((String)" / ").method_27694(style -> style.method_36139(0xE0E0E0));
        class_5250 maxText = class_2561.method_43470((String)String.valueOf(maxHpInt)).method_27694(style -> style.method_36139(0xFFFFFF));
        class_5250 numberText = class_2561.method_43473().method_10852((class_2561)hpText).method_10852((class_2561)slashTxt).method_10852((class_2561)maxText);
        float textWidth = textRenderer.method_27525((class_5348)numberText);
        float numberX = -textWidth / 2.0f;
        Objects.requireNonNull(textRenderer);
        float fontH = 9.0f;
        float verticalOffset = 1.3f;
        float numberY = 4.0f + (10.0f - fontH) / 2.0f + verticalOffset;
        textRenderer.method_30882((class_2561)numberText, numberX, numberY, 0xFFFFFF, false, matrix4f, vertexConsumers, class_327.class_6415.field_33994, 0, light);
        matrices.method_22909();
    }

    private void drawHpBarQuad(class_4587 matrices, float ratio) {
        ratio = class_3532.method_15363((float)ratio, (float)0.0f, (float)1.0f);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        float barWidth = 100.0f;
        float barHeight = 10.0f;
        float x = -barWidth / 2.0f;
        float y = 4.0f;
        int backgroundColor = 0x70000000;
        int borderColor = -16777216;
        int baseColor = ratio > 0.66f ? -13172840 : (ratio > 0.33f ? -6050 : -46518);
        int topColor = this.adjustColorBrightness(baseColor, 1.2f);
        int bottomColor = this.adjustColorBrightness(baseColor, 0.75);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        this.putQuad(buffer, matrix4f, x, y, barWidth, barHeight, backgroundColor);
        float inset = 2.0f;
        float innerX = x + inset;
        float innerY = y + inset;
        float innerWidth = barWidth - inset * 2.0f;
        float innerHeight = barHeight - inset * 2.0f;
        float filledInnerWidth = innerWidth * ratio;
        if (filledInnerWidth > 0.0f) {
            float halfHeight = innerHeight / 2.0f;
            this.putQuadGradientHorizontal(buffer, matrix4f, innerX, innerY, filledInnerWidth, halfHeight, topColor, topColor);
            this.putQuadGradientHorizontal(buffer, matrix4f, innerX, innerY + halfHeight, filledInnerWidth, halfHeight, bottomColor, bottomColor);
            int highlightColor = 0x30FFFFFF;
            this.putQuad(buffer, matrix4f, innerX, innerY, filledInnerWidth, 1.0f, highlightColor);
        }
        float b = 1.0f;
        this.putQuad(buffer, matrix4f, x, y - b, barWidth, b, borderColor);
        this.putQuad(buffer, matrix4f, x, y + barHeight, barWidth, b, borderColor);
        this.putQuad(buffer, matrix4f, x - b, y - b, b, barHeight + 2.0f * b, borderColor);
        this.putQuad(buffer, matrix4f, x + barWidth, y - b, b, barHeight + 2.0f * b, borderColor);
        tessellator.method_1350();
        RenderSystem.disableBlend();
    }

    private void putQuad(class_287 buffer, Matrix4f matrix4f, float x, float y, float w, float h, int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        float x1 = x;
        float x2 = x + w;
        float y1 = y;
        float y2 = y + h;
        buffer.method_22918(matrix4f, x1, y1, 0.0f).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix4f, x1, y2, 0.0f).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix4f, x2, y2, 0.0f).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix4f, x2, y1, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    private void putQuadGradientHorizontal(class_287 buffer, Matrix4f matrix4f, float x, float y, float w, float h, int leftColor, int rightColor) {
        float aL = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float rL = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float gL = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float bL = (float)(leftColor & 0xFF) / 255.0f;
        float aR = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float rR = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float gR = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float bR = (float)(rightColor & 0xFF) / 255.0f;
        float x1 = x;
        float x2 = x + w;
        float y1 = y;
        float y2 = y + h;
        buffer.method_22918(matrix4f, x1, y1, 0.0f).method_22915(rL, gL, bL, aL).method_1344();
        buffer.method_22918(matrix4f, x1, y2, 0.0f).method_22915(rL, gL, bL, aL).method_1344();
        buffer.method_22918(matrix4f, x2, y2, 0.0f).method_22915(rR, gR, bR, aR).method_1344();
        buffer.method_22918(matrix4f, x2, y1, 0.0f).method_22915(rR, gR, bR, aR).method_1344();
    }

    private int adjustColorBrightness(int argb, double factor) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        r = (int)class_3532.method_15350((double)((double)r * factor), (double)0.0, (double)255.0);
        g = (int)class_3532.method_15350((double)((double)g * factor), (double)0.0, (double)255.0);
        b = (int)class_3532.method_15350((double)((double)b * factor), (double)0.0, (double)255.0);
        return a << 24 | r << 16 | g << 8 | b;
    }
}

