/*
 * Decompiled with CFR 0.152.
 */
package dev.numbits.healthbarplus.utils;

import dev.numbits.healthbarplus.HealthBarPlus;
import dev.numbits.healthbarplus.utils.ModInfoUtil;
import java.util.Collection;
import net.fabricmc.loader.api.metadata.Person;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthBarPlus.class);
    private static final String PREFIX = "[" + HealthBarPlus.class.getSimpleName() + "]";

    private LoggerUtil() {
    }

    public static void log(String message) {
        LOGGER.info("{} {}", (Object)PREFIX, (Object)LoggerUtil.safe(message));
    }

    public static void warn(String message) {
        LOGGER.warn("{} {}", (Object)PREFIX, (Object)LoggerUtil.safe(message));
    }

    public static void error(String message) {
        LOGGER.error("{} {}", (Object)PREFIX, (Object)LoggerUtil.safe(message));
    }

    public static void logModInfo() {
        String version = ModInfoUtil.getVersion();
        Collection<Person> authors = ModInfoUtil.getAuthors();
        String authorsStr = authors.stream().map(Person::getName).reduce((a, b) -> a + ", " + b).orElse("unknown");
        String msg = String.format("version=%s | authors=%s", version, authorsStr);
        LoggerUtil.log(msg);
    }

    private static String safe(String message) {
        return message == null ? "(null)" : message;
    }
}

