/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.hubeconbundle.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.hubeconbundle.HubandeconMod;
import net.mcreator.hubeconbundle.procedures.TicketRedeemSell10Procedure;
import net.mcreator.hubeconbundle.procedures.TicketRedeemSell1Procedure;
import net.mcreator.hubeconbundle.procedures.TicketRedeemSell20Procedure;
import net.mcreator.hubeconbundle.procedures.TicketRedeemSell50Procedure;
import net.mcreator.hubeconbundle.world.inventory.TicketRedeemGuiMaxMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class TicketRedeemGuiMaxButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public TicketRedeemGuiMaxButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public TicketRedeemGuiMaxButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(TicketRedeemGuiMaxButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(TicketRedeemGuiMaxButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            TicketRedeemGuiMaxButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = TicketRedeemGuiMaxMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TicketRedeemSell1Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            TicketRedeemSell10Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            TicketRedeemSell20Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            TicketRedeemSell50Procedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        HubandeconMod.addNetworkMessage(TicketRedeemGuiMaxButtonMessage.class, TicketRedeemGuiMaxButtonMessage::buffer, TicketRedeemGuiMaxButtonMessage::new, TicketRedeemGuiMaxButtonMessage::handler);
    }
}

