/*
 * Decompiled with CFR 0.152.
 */
package com.github.theredbrain.netheritebuckets.block.cauldron;

import com.github.theredbrain.netheritebuckets.registry.BlockRegistry;
import com.github.theredbrain.netheritebuckets.registry.ItemRegistry;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import net.minecraft.class_6880;

public interface NetheriteCauldronBehaviour {
    public static final Map<String, NetheriteCauldronBehaviorMap> BEHAVIOR_MAPS = new Object2ObjectArrayMap();
    public static final Codec<NetheriteCauldronBehaviorMap> CODEC = Codec.stringResolver(NetheriteCauldronBehaviorMap::name, BEHAVIOR_MAPS::get);
    public static final NetheriteCauldronBehaviorMap EMPTY_NETHERITE_CAULDRON_BEHAVIOR = NetheriteCauldronBehaviour.createMap("empty");
    public static final NetheriteCauldronBehaviorMap NETHERITE_LAVA_CAULDRON_BEHAVIOR = NetheriteCauldronBehaviour.createMap("lava");
    public static final NetheriteCauldronBehaviour FILL_WITH_LAVA = (state, world, pos, player, hand, stack) -> NetheriteCauldronBehaviour.fillCauldron(world, pos, player, hand, stack, BlockRegistry.NETHERITE_LAVA_CAULDRON.method_9564(), class_3417.field_15010);

    public static NetheriteCauldronBehaviorMap createMap(String name) {
        Object2ObjectOpenHashMap object2ObjectOpenHashMap = new Object2ObjectOpenHashMap();
        object2ObjectOpenHashMap.defaultReturnValue((state, world, pos, player, hand, stack) -> class_1269.field_52423);
        NetheriteCauldronBehaviorMap cauldronBehaviorMap = new NetheriteCauldronBehaviorMap(name, (Map<class_1792, NetheriteCauldronBehaviour>)object2ObjectOpenHashMap);
        BEHAVIOR_MAPS.put(name, cauldronBehaviorMap);
        return cauldronBehaviorMap;
    }

    public class_1269 interact(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_1268 var5, class_1799 var6);

    public static void registerBehavior() {
        Map<class_1792, NetheriteCauldronBehaviour> map = EMPTY_NETHERITE_CAULDRON_BEHAVIOR.map();
        NetheriteCauldronBehaviour.registerBucketBehavior(map);
        Map<class_1792, NetheriteCauldronBehaviour> map3 = NETHERITE_LAVA_CAULDRON_BEHAVIOR.map();
        map3.put(ItemRegistry.NETHERITE_BUCKET, (state, world, pos, player, hand, stack) -> NetheriteCauldronBehaviour.emptyCauldron(state, world, pos, player, hand, stack, new class_1799((class_1935)ItemRegistry.NETHERITE_LAVA_BUCKET), statex -> true, class_3417.field_15202));
        NetheriteCauldronBehaviour.registerBucketBehavior(map3);
    }

    public static void registerBucketBehavior(Map<class_1792, NetheriteCauldronBehaviour> behavior) {
        behavior.put(ItemRegistry.NETHERITE_LAVA_BUCKET, FILL_WITH_LAVA);
    }

    public static class_1269 emptyCauldron(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack, class_1799 output, Predicate<class_2680> fullPredicate, class_3414 soundEvent) {
        if (!fullPredicate.test(state)) {
            return class_1269.field_52423;
        }
        if (!world.method_8608()) {
            class_1792 item = stack.method_7909();
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)output));
            player.method_7281(class_3468.field_15373);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8501(pos, BlockRegistry.NETHERITE_CAULDRON.method_9564());
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28167, pos);
        }
        return class_1269.field_5812;
    }

    public static class_1269 fillCauldron(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack, class_2680 state, class_3414 soundEvent) {
        if (!world.method_8608()) {
            class_1792 item = stack.method_7909();
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)ItemRegistry.NETHERITE_BUCKET)));
            player.method_7281(class_3468.field_15430);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            world.method_8501(pos, state);
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            world.method_33596(null, (class_6880)class_5712.field_28166, pos);
        }
        return class_1269.field_5812;
    }

    public record NetheriteCauldronBehaviorMap(String name, Map<class_1792, NetheriteCauldronBehaviour> map) {
    }
}

