package io.wispforest.okboomer;

import io.wispforest.okboomer.mixin.MouseAccessor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.lwjgl.glfw.GLFW;

@Environment(EnvType.CLIENT)
public class OkBoomer implements ClientModInitializer {

    public static final io.wispforest.okboomer.OkConfig CONFIG = io.wispforest.okboomer.OkConfig.createAndLoad();

    public static double boomDivisor = 1;
    public static double prevBoomDivisor = CONFIG.defaultBoom();
    public static boolean booming = false;

    public static double screenBoom = 1;
    public static float screenRotation = 0;
    public static boolean currentlyScreenBooming = false;

    public static boolean currentlyRotatIng = false;

    public static Matrix3x2fc renderTransform = new Matrix3x2f();
    public static Matrix3x2fc mouseTransform = new Matrix3x2f();

    private static boolean smoothCameraRestoreValue = false;

    public static final class_304 BOOM_BINDING = KeyBindingHelper.registerKeyBinding(
        new class_304("key.ok-boomer.boom", GLFW.GLFW_KEY_C, class_304.class_11900.field_62556)
    );

    public static final class_304 SCREEN_BOOM_BINDING = KeyBindingHelper.registerKeyBinding(
        new class_304("key.ok-boomer.screen_boom", GLFW.GLFW_KEY_UNKNOWN, class_304.class_11900.field_62556)
    );

    public static final class_304 ROTAT_BINDING = KeyBindingHelper.registerKeyBinding(
        new class_304("key.ok-boomer.rotat", GLFW.GLFW_KEY_UNKNOWN, class_304.class_11900.field_62556)
    );

    @Override
    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            var control = class_3675.method_15987(client.method_22683(), GLFW.GLFW_KEY_LEFT_CONTROL)
                || class_3675.method_15987(client.method_22683(), GLFW.GLFW_KEY_RIGHT_CONTROL);

            var shift = class_3675.method_15987(client.method_22683(), GLFW.GLFW_KEY_LEFT_SHIFT)
                || class_3675.method_15987(client.method_22683(), GLFW.GLFW_KEY_RIGHT_SHIFT);

            if (SCREEN_BOOM_BINDING.method_1415()) {
                currentlyScreenBooming = OkBoomer.CONFIG.enableScreenBooming()
                    && isPressed(BOOM_BINDING)
                    && ((control && shift) || currentlyScreenBooming);
            } else {
                currentlyScreenBooming = OkBoomer.CONFIG.enableScreenBooming() && isPressed(SCREEN_BOOM_BINDING);
            }

            currentlyRotatIng = isPressed(ROTAT_BINDING)
                && ((control && shift) || currentlyRotatIng);

            boolean nowBooming = isPressed(BOOM_BINDING)
                && client.field_1755 == null;

            if (booming != nowBooming) {
                if (booming) {
                    prevBoomDivisor = boomDivisor;
                    boomDivisor = 1;
                    client.field_1690.field_1914 = smoothCameraRestoreValue;
                } else {
                    if (CONFIG.resumeBoom()) {
                        boomDivisor = prevBoomDivisor;
                    } else {
                        boomDivisor = CONFIG.defaultBoom();
                    }
                    smoothCameraRestoreValue = client.field_1690.field_1914;

                    if (CONFIG.useCinematicCamera()) {
                        client.field_1690.field_1914 = true;
                    }
                }

                booming = nowBooming;
            }
        });
    }

    private static boolean isPressed(class_304 binding) {
        var boundKey = KeyBindingHelper.getBoundKeyOf(binding);
        if (boundKey.method_1444() < 0) return false;

        var window = class_310.method_1551().method_22683();
        if (boundKey.method_1442() == class_3675.class_307.field_1668) {
            return class_3675.method_15987(window, boundKey.method_1444());
        }

        if (boundKey.method_1442() == class_3675.class_307.field_1672) {
            var activeButton = ((MouseAccessor) class_310.method_1551().field_1729).boom$getActiveButton();
            return activeButton != null && activeButton.comp_4801() == boundKey.method_1444();
        }

        return false;
    }

    public static int minBoom() {
        return CONFIG.boomLimits.allowBoomingOut() ? 0 : 1;
    }

    public static int maxBoom() {
        return CONFIG.boomLimits.enableLimits() ? CONFIG.boomLimits.maxBoom() : Integer.MAX_VALUE;
    }

    public static int maxScreenBoom() {
        return CONFIG.boomLimits.enableLimits() ? CONFIG.boomLimits.maxScreenBoom() : Integer.MAX_VALUE;
    }
}
