/*
 * Decompiled with CFR 0.152.
 */
package pl.tbcore.lib;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.List;
import org.apache.logging.log4j.Logger;
import pl.tbcore.lib.DownloadableMod;
import pl.tbcore.lib.GUIThing;
import pl.tbcore.lib.KlocConfig;
import pl.tbcore.lib.ModPackData;
import pl.tbcore.lib.TechBlockAPI;

public class CommonMain {
    public static void main(Logger logger, File configDirectory, File modDirectory, boolean crashRatherThanQuit) throws Exception {
        ModPackData targetModPack;
        boolean certCheck = TechBlockAPI.connectionCertificateCheck();
        if (!certCheck) {
            logger.info("Either no connection or problem with certificates");
            return;
        }
        logger.info("Successful certificate check");
        File configFile = new File(configDirectory.getPath() + "/TBD.config");
        KlocConfig klocConfig = null;
        if (configFile.exists()) {
            try {
                Gson gson = new Gson();
                JsonReader reader = new JsonReader((Reader)new FileReader(configFile));
                klocConfig = (KlocConfig)gson.fromJson(reader, KlocConfig.class);
                reader.close();
            }
            catch (Exception e) {
                throw new Exception("Wrong config in TBD.config");
            }
        } else {
            throw new Exception("Unable to find TBD.config");
        }
        boolean dirty = false;
        try {
            targetModPack = TechBlockAPI.getModPackDataForPackId(klocConfig.getModPackID());
        }
        catch (Exception e) {
            logger.info("Issue with techblock API");
            e.printStackTrace();
            return;
        }
        try {
            if (!targetModPack.getVersions().contains(klocConfig.getVersion())) {
                throw new Exception("Wrong modpack version in TBD.config");
            }
        }
        catch (Exception e) {
            logger.info("Issue with getting version");
            e.printStackTrace();
            return;
        }
        List<DownloadableMod> candidates = targetModPack.getDownloadables(klocConfig.getVersion());
        dirty = false;
        for (DownloadableMod candidate : candidates) {
            if (!candidate.downLoadOrReplaceToLocation(modDirectory)) continue;
            dirty = true;
        }
        if (dirty) {
            System.setProperty("java.awt.headless", "false");
            GUIThing guiThing = new GUIThing();
            while (true) {
                Thread.sleep(1000L);
                if (!guiThing.didRaise()) continue;
                if (crashRatherThanQuit) {
                    throw new Exception("Please restart your minecraft client");
                }
                System.exit(1);
            }
        }
    }
}

