/*
 * Decompiled with CFR 0.152.
 */
package pl.tbcore.lib;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import pl.tbcore.lib.ModPackData;
import pl.tbcore.lib.TechBlockAPI;

class DownloadableMod {
    private ModPackData modPackData;
    private String version;
    private String name;
    private String md5;

    public DownloadableMod(ModPackData modPackData, String version, String name, String md5) {
        this.modPackData = modPackData;
        this.version = version;
        this.name = name;
        this.md5 = md5;
    }

    public String getName() {
        return this.name;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean downLoadOrReplaceToLocation(File directory) throws Exception {
        int bytesRead;
        if (!directory.exists()) {
            throw new Exception("Directory should exist");
        }
        if (!directory.isDirectory()) {
            throw new Exception("Destination is not a directory");
        }
        File destinationFile = null;
        if (this.getName().contains("|")) {
            String[] splited = this.getName().split("\\|");
            StringBuilder fullPath = new StringBuilder();
            fullPath.append(directory.toPath());
            for (int i = 0; i < splited.length - 1; ++i) {
                String toAdd = splited[i];
                fullPath.append("/" + toAdd);
                new File(fullPath.toString()).mkdir();
            }
            fullPath.append("/" + splited[splited.length - 1]);
            destinationFile = new File(fullPath.toString());
        } else {
            destinationFile = new File(directory.getPath() + "/" + this.name);
        }
        if (destinationFile.exists()) {
            return false;
        }
        InputStream inputStream = TechBlockAPI.getRequestToInputStream("repository/" + this.modPackData.getAuthor() + "/packs/" + this.modPackData.getPackID() + "/" + this.version + "/mods/" + this.name.replace("|", "/"));
        FileOutputStream writer = new FileOutputStream(destinationFile);
        byte[] buffer = new byte[8192];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            writer.write(buffer, 0, bytesRead);
        }
        inputStream.close();
        writer.close();
        return true;
    }
}

