/*
 * Decompiled with CFR 0.152.
 */
package pl.tbcore.lib;

import com.google.gson.internal.LinkedTreeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileSystem {
    public static Map<String, String> checkMD5ForDir(File directory) throws Exception {
        if (!directory.isDirectory()) {
            throw new Exception("Destination not a directory");
        }
        LinkedTreeMap collector = new LinkedTreeMap();
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) continue;
            try (FileInputStream inputStream = new FileInputStream(file);){
                int bytesRead;
                MessageDigest md = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[1024];
                while ((bytesRead = ((InputStream)inputStream).read(buffer)) != -1) {
                    md.update(buffer, 0, bytesRead);
                }
                byte[] digest = md.digest();
                StringBuilder hexString = new StringBuilder();
                for (byte b : digest) {
                    hexString.append(String.format("%02x", b));
                }
                collector.put((Object)file.getName(), (Object)hexString.toString());
            }
        }
        return collector;
    }

    public static List<Path> listFiles(Path path) throws IOException {
        List<Path> result;
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            result = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        return result;
    }

    public static void deleteNonEmptyDirectory(File directory) {
        File[] files;
        if (directory.isDirectory() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                FileSystem.deleteNonEmptyDirectory(file);
            }
        }
        try {
            if (directory.delete()) {
                System.out.println(directory + " is deleted");
            } else {
                System.out.println("Directory not deleted");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

