/*
 * Decompiled with CFR 0.152.
 */
package pl.tbcore.lib;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import pl.tbcore.lib.DownloadableMod;
import pl.tbcore.lib.TechBlockAPI;

class ModPackData {
    private String author;
    private int packID;
    private List<Map<String, String>> versions;

    public ModPackData(String author, int packID, List<Map<String, String>> versions) {
        this.author = author;
        this.packID = packID;
        this.versions = versions;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getPackID() {
        return this.packID;
    }

    public List<String> getVersions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Map<String, String> version : this.versions) {
            toReturn.add(version.get("v"));
        }
        return toReturn;
    }

    public List<DownloadableMod> getDownloadables(String version) throws Exception {
        String rawData = TechBlockAPI.sendGet("repository/" + this.getAuthor() + "/packs/" + this.packID + "/" + version + "/data.json");
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, Object>>(){}.getType();
        Map firstPass = (Map)gson.fromJson(rawData, type);
        List modsList = (List)firstPass.get("mods");
        ArrayList<DownloadableMod> mods = new ArrayList<DownloadableMod>();
        for (Map stringStringMap : modsList) {
            mods.add(new DownloadableMod(this, version, (String)stringStringMap.get("name"), ((String)stringStringMap.get("md5")).toLowerCase()));
        }
        return mods;
    }
}

