/*
 * Decompiled with CFR 0.152.
 */
package pl.tbcore.lib;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import pl.tbcore.lib.ModPackData;

public class TechBlockAPI {
    private static String api = "https://mdp.techblock.pl/launcher/";
    private static boolean checked = false;

    private static HttpsURLConnection openConnectionWithMyCert(URL url) throws Exception {
        TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                X509Certificate serverCert = chain[0];
                PublicKey knownServerCert = null;
                try {
                    knownServerCert = TechBlockAPI.getTechPublic();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!serverCert.getPublicKey().equals(knownServerCert)) {
                    throw new CertificateException("Certificate does not match");
                }
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, trustManagers, new SecureRandom());
        HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
        con.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        con.setSSLSocketFactory(sslContext.getSocketFactory());
        return con;
    }

    protected static boolean connectionCertificateCheck() {
        try {
            boolean ret;
            URL url = new URL(api);
            HttpsURLConnection con = TechBlockAPI.openConnectionWithMyCert(url);
            con.connect();
            PublicKey serverPublicKey = con.getServerCertificates()[0].getPublicKey();
            PublicKey knownTechBlockKey = TechBlockAPI.getTechPublic();
            checked = ret = serverPublicKey.equals(knownTechBlockKey);
            con.disconnect();
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static PublicKey getTechPublic() throws Exception {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classloader.getResourceAsStream("techblock-pl.pem");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)cf.generateCertificate(inputStream);
        inputStream.close();
        return certificate.getPublicKey();
    }

    protected static String sendGet(String appendTo) throws Exception {
        int numRead;
        if (!checked) {
            throw new Exception("Did not check for certificates");
        }
        URL url = new URL(new URI(null, null, api + appendTo, null).toString());
        HttpsURLConnection c = TechBlockAPI.openConnectionWithMyCert(url);
        c.setRequestMethod("GET");
        c.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; Java)");
        int bufferSize = 1024;
        char[] buffer = new char[bufferSize];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(c.getInputStream(), StandardCharsets.UTF_8);
        while ((numRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, numRead);
        }
        ((Reader)in).close();
        return out.toString();
    }

    protected static InputStream getRequestToInputStream(String appendTo) throws Exception {
        if (!checked) {
            throw new Exception("Did not check for certificates");
        }
        URL url = new URL(new URI(null, null, api + appendTo, null).toString());
        HttpsURLConnection c = TechBlockAPI.openConnectionWithMyCert(url);
        c.setRequestMethod("GET");
        c.setRequestProperty("User-Agent", "Mozilla/5.0 (compatible; Java)");
        return c.getInputStream();
    }

    private static Map<Integer, ModPackData> listModPacks() throws Exception {
        Gson gson = new Gson();
        Type type = new TypeToken<Map<String, List<Map<String, Object>>>>(){}.getType();
        String rawData = TechBlockAPI.sendGet("api/launcherData.php");
        Map data = (Map)gson.fromJson(rawData, type);
        LinkedHashMap<Integer, ModPackData> accumulator = new LinkedHashMap<Integer, ModPackData>();
        for (Map categories : (List)data.get("categories")) {
            String categoryID = (String)categories.get("categoryID");
            String user = (String)categories.get("user");
            String categoryName = (String)categories.get("categoryName");
            List packs = (List)categories.get("packs");
            for (Map pack : packs) {
                List versions = (List)pack.get("versions");
                accumulator.put(Integer.parseInt((String)pack.get("packid")), new ModPackData((String)pack.get("author"), Integer.parseInt((String)pack.get("packid")), versions));
            }
        }
        return accumulator;
    }

    public static ModPackData getModPackDataForPackId(int packID) throws Exception {
        Map<Integer, ModPackData> modPackDataMap = TechBlockAPI.listModPacks();
        return modPackDataMap.get(packID);
    }
}

