/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.appliedenergistics;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CalculationStrategy;
import appeng.api.networking.crafting.CraftingJobStatus;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.crafting.ICraftingSimulationRequester;
import appeng.api.networking.crafting.ICraftingSubmitResult;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.AdvancedPeripherals;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AEApi;
import de.srendi.advancedperipherals.common.blocks.blockentities.MEBridgeEntity;
import de.srendi.advancedperipherals.common.util.StatusConstants;
import de.srendi.advancedperipherals.common.util.inventory.BasicCraftJob;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AECraftJob
extends BasicCraftJob {
    private final IGridNode node;
    private final IActionSource source;
    private final ICraftingSimulationRequester simulationRequester;
    private final ICraftingRequester requester;
    private ICraftingCPU targetCpu;
    private final AEKey toCraft;
    private Future<ICraftingPlan> futureJob;
    private ICraftingPlan currentJob;
    @Nullable
    private ICraftingLink jobLink;
    private Supplier<CraftingJobStatus> jobStatus;
    private CraftingJobStatus cachedStatus;

    public AECraftJob(Level world, IComputerAccess computer, IGridNode node, AEKey item, long amount, MEBridgeEntity bridge, ICraftingCPU target) {
        super(computer, "ae", world, amount);
        this.node = node;
        this.source = bridge;
        this.toCraft = item;
        this.simulationRequester = bridge;
        this.requester = bridge;
        this.targetCpu = target;
    }

    @LuaFunction
    public final Object getCraftingCPU() {
        if (this.targetCpu == null) {
            return null;
        }
        return AEApi.parseCraftingCPU(this.targetCpu, true);
    }

    @Nullable
    public ICraftingLink getJobLink() {
        return this.jobLink;
    }

    public ICraftingCPU getTargetCpu() {
        return this.targetCpu;
    }

    public AEKey getToCraft() {
        return this.toCraft;
    }

    @Override
    protected boolean isJobDone() {
        return this.jobLink != null && this.jobLink.isDone();
    }

    @Override
    protected boolean isJobCanceled() {
        return this.jobLink != null && this.jobLink.isCanceled();
    }

    @Override
    public Object getParsedRequestedItemImpl() {
        return AEApi.parseGenericStack(new GenericStack(this.toCraft, this.amount));
    }

    @Override
    public long getElapsedTimeImpl() {
        if (this.getJobStatus() == null) {
            return -1L;
        }
        return this.getJobStatus().elapsedTimeNanos();
    }

    @Override
    public long getTotalItemsImpl() {
        if (this.getJobStatus() == null) {
            return -1L;
        }
        return this.getJobStatus().totalItems();
    }

    @Override
    public long getItemProgressImpl() {
        if (this.getJobStatus() == null) {
            return -1L;
        }
        return this.getJobStatus().progress();
    }

    @Override
    public Object getEmittedItemsImpl() {
        if (this.currentJob == null) {
            return null;
        }
        return AEApi.parseKeyCounter(this.currentJob.emittedItems());
    }

    @Override
    public Object getUsedItemsImpl() {
        if (this.currentJob == null) {
            return null;
        }
        return AEApi.parseKeyCounter(this.currentJob.usedItems());
    }

    @Override
    public Object getMissingItemsImpl() {
        if (this.currentJob == null) {
            return null;
        }
        return AEApi.parseKeyCounter(this.currentJob.missingItems());
    }

    @Override
    public boolean hasMultiplePathsImpl() {
        if (this.currentJob == null) {
            return false;
        }
        return this.currentJob.multiplePaths();
    }

    @Override
    public Object getFinalOutputImpl() {
        if (this.currentJob == null) {
            return null;
        }
        return AEApi.parseGenericStack(this.currentJob.finalOutput());
    }

    @Override
    public boolean cancelImpl() {
        if (this.targetCpu.isBusy()) {
            this.targetCpu.cancelJob();
            return true;
        }
        return false;
    }

    @LuaFunction
    public long getUsedBytes() {
        if (this.currentJob == null) {
            return -1L;
        }
        return this.currentJob.bytes();
    }

    public AECraftJob withJobStatus(Supplier<CraftingJobStatus> jobStatus) {
        this.jobStatus = jobStatus;
        return this;
    }

    public AECraftJob withCPU(ICraftingCPU craftingCpu) {
        if (this.targetCpu == null) {
            this.targetCpu = craftingCpu;
        }
        return this;
    }

    @Override
    public void startCalculation() {
        if (this.startedCalculation) {
            return;
        }
        this.startedCalculation = true;
        IGrid grid = this.node.getGrid();
        ICraftingService craftingService = (ICraftingService)grid.getService(ICraftingService.class);
        if (!craftingService.isCraftable(this.toCraft)) {
            this.fireEvent(true, StatusConstants.NOT_CRAFTABLE);
            this.calculationNotSuccessful = true;
            return;
        }
        this.futureJob = craftingService.beginCraftingCalculation(this.world, this.simulationRequester, this.toCraft, this.amount, CalculationStrategy.REPORT_MISSING_ITEMS);
        this.fireEvent(false, StatusConstants.CALCULATION_STARTED);
    }

    @Override
    public void maybeCraft() {
        ICraftingPlan job;
        if (this.startedCrafting || this.futureJob == null || !this.futureJob.isDone()) {
            return;
        }
        try {
            job = this.futureJob.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            AdvancedPeripherals.debug("Tried to get job, but job calculation is not done. Should be done.", org.apache.logging.log4j.Level.ERROR);
            ex.printStackTrace();
            this.fireEvent(true, StatusConstants.UNKNOWN_ERROR);
            return;
        }
        if (job == null) {
            AdvancedPeripherals.debug("Job is null, should not be null.", org.apache.logging.log4j.Level.ERROR);
            this.fireEvent(true, StatusConstants.UNKNOWN_ERROR);
            return;
        }
        this.currentJob = job;
        KeyCounter missing = job.missingItems();
        if (!missing.isEmpty()) {
            this.fireEvent(true, StatusConstants.MISSING_ITEMS);
            this.calculationNotSuccessful = true;
            return;
        }
        IGrid grid = this.node.getGrid();
        ICraftingService craftingService = (ICraftingService)grid.getService(ICraftingService.class);
        ICraftingSubmitResult submitResult = craftingService.submitJob(job, this.requester, this.targetCpu, false, this.source);
        if (!submitResult.successful()) {
            this.calculationNotSuccessful = true;
            this.fireEvent(true, submitResult.errorCode().toString());
            return;
        }
        this.jobLink = submitResult.link();
        this.futureJob = null;
        this.setStartedCrafting();
        this.prepareCPUAndStatus(craftingService);
    }

    @Override
    public void jobStateChanged() {
        ICraftingLink jobLink = this.jobLink;
        if (jobLink == null) {
            this.fireEvent(true, StatusConstants.UNKNOWN_ERROR);
            return;
        }
        if (jobLink.isCanceled() && !this.isJobCanceled) {
            this.fireEvent(false, StatusConstants.JOB_CANCELED);
            this.setJobCanceled();
            return;
        }
        if (jobLink.isDone() && !this.isJobDone) {
            this.fireEvent(false, StatusConstants.JOB_DONE);
            this.setJobDone();
        }
    }

    private void prepareCPUAndStatus(ICraftingService service) {
        if (this.jobLink == null || this.jobStatus != null || !this.startedCrafting) {
            return;
        }
        for (ICraftingCPU cpu : service.getCpus()) {
            if (!(cpu instanceof CraftingCPUCluster)) continue;
            CraftingCPUCluster cpuCluster = (CraftingCPUCluster)cpu;
            ICraftingLink lastLink = cpuCluster.craftingLogic.getLastLink();
            if (lastLink == null || !lastLink.getCraftingID().equals(this.jobLink.getCraftingID())) continue;
            this.jobStatus = () -> {
                if (cpuCluster.craftingLogic.getLastLink() != null && cpuCluster.craftingLogic.getLastLink().getCraftingID().equals(this.jobLink.getCraftingID())) {
                    return cpuCluster.getJobStatus();
                }
                return null;
            };
            cpuCluster.craftingLogic.addListener(key -> {
                if (cpuCluster.getJobStatus() != null) {
                    this.cachedStatus = cpuCluster.getJobStatus();
                }
            });
            this.targetCpu = cpu;
            return;
        }
        AdvancedPeripherals.debug("Could not find CPU or job link even after job started", org.apache.logging.log4j.Level.WARN);
    }

    private CraftingJobStatus getJobStatus() {
        if (this.jobStatus != null && this.jobStatus.get() != null) {
            this.cachedStatus = this.jobStatus.get();
        }
        return this.cachedStatus;
    }
}

