/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperation;
import de.srendi.advancedperipherals.common.addons.computercraft.operations.SingleOperationContext;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.FuelAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.TurtlePeripheralOwner;
import de.srendi.advancedperipherals.common.addons.computercraft.peripheral.plugins.AutomataCorePlugin;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.setup.DataComponents;
import de.srendi.advancedperipherals.common.util.NBTUtil;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.lib.peripherals.AutomataCorePeripheral;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomataWarpingPlugin
extends AutomataCorePlugin {
    public AutomataWarpingPlugin(AutomataCorePeripheral automataCore) {
        super(automataCore);
    }

    @Override
    @Nullable
    public IPeripheralOperation<?>[] getOperations() {
        return new IPeripheralOperation[]{SingleOperation.WARP};
    }

    @NotNull
    protected Pair<MethodResult, CompoundTag> getPointData() {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        PatchedDataComponentMap settings = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)owner.getDataStorage());
        if (!settings.has((DataComponentType)DataComponents.WORLD_DATA_MARK.get())) {
            settings.set((DataComponentType)DataComponents.WORLD_DATA_MARK.get(), (Object)owner.getLevel().dimension().location().toString());
        } else {
            String worldName = (String)settings.get((DataComponentType)DataComponents.WORLD_DATA_MARK.get());
            if (!owner.getLevel().dimension().location().toString().equals(worldName)) {
                return Pair.onlyLeft(MethodResult.of((Object[])new Object[]{null, "Incorrect world for this upgrade"}));
            }
        }
        if (!settings.has((DataComponentType)DataComponents.POINT_DATA_MARK.get())) {
            settings.set((DataComponentType)DataComponents.POINT_DATA_MARK.get(), (Object)new CompoundTag());
        }
        return Pair.onlyRight((CompoundTag)settings.get((DataComponentType)DataComponents.POINT_DATA_MARK.get()));
    }

    protected void setPointData(@NotNull CompoundTag data) {
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        PatchedDataComponentMap settings = PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)owner.getDataStorage());
        settings.set((DataComponentType)DataComponents.POINT_DATA_MARK.get(), (Object)data);
        owner.putDataStorage(settings.asPatch());
    }

    private int getWarpCost(SingleOperationContext context) {
        FuelAbility<?> fuelAbility = ((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getAbility(PeripheralOwnerAbility.FUEL);
        Objects.requireNonNull(fuelAbility);
        return SingleOperation.WARP.getCost(context) * fuelAbility.getFuelConsumptionMultiply();
    }

    @LuaFunction(mainThread=true)
    public final MethodResult savePoint(String name) {
        this.automataCore.addRotationCycle();
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        if (data.getAllKeys().size() >= (Integer)APConfig.METAPHYSICS_CONFIG.endAutomataCoreWarpPointLimit.get()) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot add new point, limit reached"});
        }
        data.put(name, (Tag)NBTUtil.toNBT(((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getPos()));
        this.setPointData(data);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult deletePoint(String name) {
        this.automataCore.addRotationCycle();
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        if (!data.contains(name)) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot find point to delete"});
        }
        data.remove(name);
        this.setPointData(data);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult points() {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        return MethodResult.of((Object)data.getAllKeys());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult warpToPoint(String name) throws LuaException {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        if (!data.contains(name)) {
            return MethodResult.of((Object[])new Object[]{null, "Cannot find point to teleport"});
        }
        TurtlePeripheralOwner owner = (TurtlePeripheralOwner)this.automataCore.getPeripheralOwner();
        Level level = owner.getLevel();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.getCompound(name));
        return this.automataCore.withOperation(SingleOperation.WARP, this.automataCore.toDistance(newPosition), context -> {
            boolean result = owner.move(level, newPosition);
            if (!result) {
                return MethodResult.of((Object[])new Object[]{null, "Cannot teleport to location"});
            }
            return MethodResult.of((Object)true);
        }, context -> {
            if (!owner.isMovementPossible(level, newPosition)) {
                return MethodResult.of((Object[])new Object[]{null, "Move forbidden"});
            }
            return null;
        });
    }

    @LuaFunction(mainThread=true)
    public final MethodResult estimateWarpCost(String name) {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.getCompound(name));
        return MethodResult.of((Object)this.getWarpCost(this.automataCore.toDistance(newPosition)));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult distanceToPoint(String name) {
        Pair<MethodResult, CompoundTag> pairData = this.getPointData();
        if (pairData.leftPresent()) {
            return pairData.getLeft();
        }
        CompoundTag data = pairData.getRight();
        BlockPos newPosition = NBTUtil.blockPosFromNBT(data.getCompound(name));
        return MethodResult.of((Object)newPosition.distManhattan((Vec3i)((TurtlePeripheralOwner)this.automataCore.getPeripheralOwner()).getPos()));
    }
}

