/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.minecolonies;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.requirements.BuildingResearchRequirement;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSkillHandler;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.srendi.advancedperipherals.common.util.LuaConverter;
import io.netty.buffer.Unpooled;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.connection.ConnectionType;

public class MineColonies {
    public static boolean hasAccess(Entity entity, IColony colony) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (colony != null) {
                return colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS);
            }
        }
        return false;
    }

    public static Object citizenToObject(ICitizenData citizen) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", citizen.getId());
        map.put("name", citizen.getName());
        map.put("bedPos", LuaConverter.posToObject(citizen.getBedPos()));
        map.put("children", citizen.getChildren());
        map.put("location", LuaConverter.posToObject(citizen.getLastPosition()));
        map.put("state", citizen.getStatus() == null ? "Idle" : Component.translatable((String)citizen.getStatus().getTranslationKey()).getString());
        map.put("isChild", citizen.isChild() ? "child" : "adult");
        map.put("gender", citizen.isFemale() ? "female" : "male");
        map.put("saturation", citizen.getSaturation());
        map.put("happiness", citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony(), citizen));
        map.put("skills", MineColonies.skillsToObject(citizen.getCitizenSkillHandler().getSkills()));
        map.put("work", citizen.getWorkBuilding() == null ? null : MineColonies.jobToObject(citizen.getWorkBuilding(), citizen.getJob()));
        map.put("home", citizen.getHomeBuilding() == null ? null : MineColonies.homeToObject(citizen.getHomeBuilding()));
        map.put("betterFood", citizen.needsBetterFood());
        map.put("isAsleep", citizen.getStatus() != null && citizen.getStatus().equals(VisibleCitizenStatus.SLEEP));
        map.put("isIdle", citizen.getStatus() == null || citizen.getStatus().equals(VisibleCitizenStatus.HOUSE));
        citizen.getEntity().ifPresent(entity -> {
            map.put("health", Float.valueOf(entity.getHealth()));
            map.put("maxHealth", Float.valueOf(entity.getMaxHealth()));
            map.put("armor", entity.getAttributeValue(Attributes.ARMOR));
            map.put("toughness", entity.getAttributeValue(Attributes.ARMOR_TOUGHNESS));
        });
        return map;
    }

    public static Object visitorToObject(IVisitorData visitor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", visitor.getId());
        map.put("name", visitor.getName());
        map.put("location", LuaConverter.posToObject(visitor.getSittingPosition()));
        map.put("isChild", visitor.isChild() ? "child" : "adult");
        map.put("gender", visitor.isFemale() ? "female" : "male");
        map.put("saturation", visitor.getSaturation());
        map.put("happiness", visitor.getCitizenHappinessHandler().getHappiness(visitor.getColony(), (ICitizenData)visitor));
        map.put("skills", MineColonies.skillsToObject(visitor.getCitizenSkillHandler().getSkills()));
        map.put("recruitCost", LuaConverter.itemStackToObject(visitor.getRecruitCost()));
        return map;
    }

    public static Object jobToObject(IBuilding work, IJob<?> job) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(work.getLocation().getInDimensionLocation()));
        map.put("type", work.getSchematicName());
        map.put("level", work.getBuildingLevel());
        map.put("name", work.getBuildingDisplayName());
        map.put("job", job.getJobRegistryEntry().getTranslationKey());
        return map;
    }

    public static Object homeToObject(IBuilding home) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(home.getLocation().getInDimensionLocation()));
        map.put("type", home.getSchematicName());
        map.put("level", home.getBuildingLevel());
        return map;
    }

    public static Object skillsToObject(Map<Skill, CitizenSkillHandler.SkillData> skills) {
        HashMap map = new HashMap();
        for (Map.Entry<Skill, CitizenSkillHandler.SkillData> skill : skills.entrySet()) {
            HashMap<String, Number> skillData = new HashMap<String, Number>();
            skillData.put("level", skill.getValue().getLevel());
            skillData.put("xp", skill.getValue().getExperience());
            map.put(skill.getKey().name(), skillData);
        }
        return map;
    }

    public static Object buildingToObject(IRegisteredStructureManager buildingManager, IBuilding building, BlockPos pos) {
        HashMap<String, Object> structureData = new HashMap<String, Object>();
        structureData.put("cornerA", LuaConverter.posToObject((BlockPos)building.getCorners().getA()));
        structureData.put("cornerB", LuaConverter.posToObject((BlockPos)building.getCorners().getB()));
        structureData.put("rotation", building.getRotationMirror().toString());
        structureData.put("mirror", building.getRotationMirror().isMirrored());
        ArrayList citizensData = new ArrayList();
        for (ICitizenData citizen : building.getAllAssignedCitizen()) {
            HashMap<String, Object> citizenData = new HashMap<String, Object>();
            citizenData.put("id", citizen.getId());
            citizenData.put("name", citizen.getName());
            citizensData.add(citizenData);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("location", LuaConverter.posToObject(pos));
        map.put("type", building.getSchematicName());
        map.put("style", building.getStructurePack());
        map.put("level", building.getBuildingLevel());
        map.put("maxLevel", building.getMaxBuildingLevel());
        map.put("name", building.getBuildingDisplayName());
        map.put("built", building.isBuilt());
        map.put("isWorking", building.hasWorkOrder());
        map.put("priority", building.getPickUpPriority());
        map.put("structure", structureData);
        map.put("citizens", citizensData);
        map.put("storageBlocks", building.getContainers().size());
        map.put("storageSlots", MineColonies.getStorageSize(building));
        map.put("guarded", buildingManager.hasGuardBuildingNear(building));
        return map;
    }

    public static int getStorageSize(IBuilding building) {
        int size = 0;
        for (IItemHandler itemHandler : building.getHandlers()) {
            size += itemHandler.getSlots();
        }
        return size;
    }

    public static int getAmountOfConstructionSites(IColony colony) {
        int constructionSites = 0;
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!building.hasWorkOrder()) continue;
            ++constructionSites;
        }
        return constructionSites;
    }

    public static Object workOrderToObject(IWorkOrder workOrder) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("builder", LuaConverter.posToObject(workOrder.getClaimedBy()));
        map.put("id", workOrder.getID());
        map.put("priority", workOrder.getPriority());
        map.put("isClaimed", workOrder.isClaimed());
        map.put("location", LuaConverter.posToObject(workOrder.getLocation()));
        map.put("type", workOrder.getClass().getSimpleName());
        map.put("buildingName", workOrder.getDisplayName().getString());
        map.put("targetLevel", workOrder.getTargetLevel());
        map.put("workOrderType", workOrder.getWorkOrderType().toString());
        return map;
    }

    public static List<Object> getResearch(ResourceLocation branch, List<ResourceLocation> researches, IColony colony) throws CommandSyntaxException {
        ArrayList<Object> result = new ArrayList<Object>();
        if (researches != null) {
            for (ResourceLocation researchName : researches) {
                Object researchEffect2;
                IGlobalResearchTree globalTree = IGlobalResearchTree.getInstance();
                ILocalResearchTree colonyTree = colony.getResearchManager().getResearchTree();
                IGlobalResearch research = globalTree.getResearch(branch, researchName);
                if (research == null || research.isHidden()) continue;
                ILocalResearch colonyResearch = colonyTree.getResearch(branch, researchName);
                ArrayList<String> effects = new ArrayList<String>();
                for (Object researchEffect2 : research.getEffects()) {
                    effects.add(Component.translatable((String)researchEffect2.getName().getKey(), (Object[])researchEffect2.getName().getArgs()).getString());
                }
                ArrayList cost = new ArrayList();
                researchEffect2 = research.getCostList().iterator();
                while (researchEffect2.hasNext()) {
                    SizedIngredient item = (SizedIngredient)researchEffect2.next();
                    HashMap<String, Serializable> researchCost = new HashMap<String, Serializable>();
                    ArrayList<Map<String, Object>> researchCostItems = new ArrayList<Map<String, Object>>();
                    for (ItemStack costItem : item.getItems()) {
                        researchCostItems.add(LuaConverter.itemStackToObject(costItem));
                    }
                    researchCost.put("validItems", researchCostItems);
                    researchCost.put("count", Integer.valueOf(item.count()));
                    cost.add(researchCost);
                }
                ArrayList requirements = new ArrayList();
                for (IResearchRequirement requirement : research.getResearchRequirements()) {
                    HashMap<String, Object> requirementItem = new HashMap<String, Object>();
                    requirementItem.put("fulfilled", requirement.isFulfilled(colony));
                    if (requirement instanceof BuildingResearchRequirement) {
                        BuildingResearchRequirement buildingRequirement = (BuildingResearchRequirement)requirement;
                        requirementItem.put("type", "building");
                        requirementItem.put("building", buildingRequirement.getBuilding());
                        requirementItem.put("level", buildingRequirement.getBuildingLevel());
                    } else {
                        requirementItem.put("type", requirement.getClass().getCanonicalName());
                    }
                    requirementItem.put("desc", requirement.getDesc().getString());
                    requirements.add(requirementItem);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", researchName.toString());
                map.put("name", Component.translatable((String)research.getName().getKey(), (Object[])research.getName().getArgs()).getString());
                map.put("requirements", requirements);
                map.put("cost", cost);
                map.put("researchEffects", effects);
                map.put("status", colonyResearch == null ? ResearchState.NOT_STARTED.toString() : colonyResearch.getState().toString());
                map.put("requiredTime", colonyResearch == null ? 0 : IGlobalResearchTree.getInstance().getBranchData(colonyResearch.getBranch()).getBaseTime(colonyResearch.getDepth()));
                map.put("progress", colonyResearch == null ? 0 : colonyResearch.getProgress());
                List<Object> childrenResearch = MineColonies.getResearch(branch, research.getChildren(), colony);
                if (!childrenResearch.isEmpty()) {
                    map.put("children", childrenResearch);
                }
                result.add(map);
            }
        }
        return result;
    }

    public static Object builderResourcesToObject(IColony colony, BlockPos pos) {
        IBuildingView buildingView;
        IBuilding building = colony.getBuildingManager().getBuilding(pos);
        if (!(building instanceof AbstractBuildingStructureBuilder)) {
            return null;
        }
        AbstractBuildingStructureBuilder builderBuilding = (AbstractBuildingStructureBuilder)building;
        RegistryFriendlyByteBuf buffer = new RegistryFriendlyByteBuf(Unpooled.buffer(), colony.getWorld().registryAccess(), ConnectionType.OTHER);
        builderBuilding.serializeToView(buffer, false);
        buffer.release();
        ArrayList resources = new ArrayList(builderBuilding.getNeededResources().values());
        resources.sort(new BuildingBuilderResource.ResourceComparator(new BuildingBuilderResource.RessourceAvailability[0]));
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colony.getID(), colony.getWorld().dimension());
        ArrayList<Delivery> deliveries = new ArrayList<Delivery>();
        if (colonyView != null && (buildingView = colonyView.getBuilding(pos)) instanceof BuildingBuilder.View) {
            BuildingBuilder.View builderBuildingView = (BuildingBuilder.View)buildingView;
            for (Map.Entry entry : builderBuildingView.getOpenRequestsByCitizen().entrySet()) {
                MineColonies.addDeliveryRequestsToList(builderBuildingView, deliveries, ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
            }
        }
        ArrayList result = new ArrayList();
        for (BuildingBuilderResource resource : resources) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ItemStack stack = resource.getItemStack().copy();
            map.put("item", LuaConverter.itemStackToObject(stack));
            map.put("displayName", resource.getName());
            map.put("available", resource.getAvailable());
            int amountInDelivery = 0;
            for (Delivery delivery : deliveries) {
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize((ItemStack)resource.getItemStack(), (ItemStack)delivery.getStack(), (boolean)false, (boolean)true)) continue;
                amountInDelivery += delivery.getStack().getCount();
            }
            map.put("delivering", amountInDelivery);
            map.put("status", resource.getAvailabilityStatus().toString());
            map.put("needs", resource.getAmount());
            result.add(map);
        }
        return result;
    }

    private static void addDeliveryRequestsToList(BuildingBuilder.View builder, List<Delivery> requestList, ImmutableCollection<IToken<?>> tokensToCheck) {
        for (IToken token : tokensToCheck) {
            IRequest request = builder.getColony().getRequestManager().getRequestForToken(token);
            if (request == null) continue;
            if (request.getRequest() instanceof Delivery && ((Delivery)request.getRequest()).getTarget().getInDimensionLocation().equals((Object)builder.getID())) {
                requestList.add((Delivery)request.getRequest());
            }
            if (!request.hasChildren()) continue;
            MineColonies.addDeliveryRequestsToList(builder, requestList, request.getChildren());
        }
    }
}

