/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.client.gui.GunTableScreenHandler;
import mod.azure.hwg.network.CraftingPacket;
import mod.azure.hwg.util.recipes.GunTableRecipe;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;

public class GunTableScreen
extends class_465<GunTableScreenHandler> {
    private static final class_2960 TEXTURE = CommonMod.modResource("textures/gui/gun_table_gui.png");
    private final WidgetButtonPage[] offers = new WidgetButtonPage[7];
    private int selectedIndex;
    private int indexStartOffset;
    private boolean scrolling;

    public GunTableScreen(GunTableScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 300;
        this.field_25269 = 107;
    }

    private void syncRecipeIndex() {
        ((GunTableScreenHandler)this.field_2797).setRecipeIndex(this.selectedIndex);
        ((GunTableScreenHandler)this.field_2797).switchTo(this.selectedIndex);
        CraftingPacket.send(this.selectedIndex);
    }

    protected void method_25426() {
        super.method_25426();
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        int k = j + 18;
        for (int l = 0; l < 7; ++l) {
            this.offers[l] = (WidgetButtonPage)this.method_37063((class_364)new WidgetButtonPage(i, k, l, button -> {
                if (button instanceof WidgetButtonPage) {
                    WidgetButtonPage widgetButtonPage = (WidgetButtonPage)button;
                    this.selectedIndex = widgetButtonPage.getIndex() + this.indexStartOffset;
                    this.syncRecipeIndex();
                }
            }));
            k += 20;
        }
    }

    protected void method_2388(class_332 matrices, int mouseX, int mouseY) {
        matrices.method_51439(this.field_22793, this.field_22785, 75 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 6, 0x404040, false);
    }

    protected void method_2389(class_332 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        int i = (this.field_22789 - this.field_2792) / 2 - 5;
        int j = (this.field_22790 - this.field_2779) / 2;
        matrices.method_25291(TEXTURE, i, j, 0, 0.0f, 0.0f, this.field_2792, this.field_2779, 512, 256);
    }

    private void renderScrollbar(class_332 matrices, int x, int y, List<class_8786<GunTableRecipe>> tradeOffers) {
        int i = tradeOffers.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int m = Math.min(113, this.indexStartOffset * k);
            if (this.indexStartOffset == i - 1) {
                m = 113;
            }
            matrices.method_25291(TEXTURE, x + 113, y + 18 + m, 0, 0.0f, 199.0f, 6, 27, 512, 256);
        } else {
            matrices.method_25291(TEXTURE, x + 113, y + 18, 0, 6.0f, 199.0f, 6, 27, 512, 256);
        }
    }

    public void method_25394(@NotNull class_332 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices, mouseX, mouseY, delta);
        super.method_25394(matrices, mouseX, mouseY, delta);
        List<class_8786<GunTableRecipe>> tradeOfferList = ((GunTableScreenHandler)this.field_2797).getRecipes();
        if (!tradeOfferList.isEmpty()) {
            int i = (this.field_22789 - this.field_2792) / 2;
            int j = (this.field_22790 - this.field_2779) / 2;
            int yPos = j + 17;
            int xPos = i + 3;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            this.renderScrollbar(matrices, i, j, tradeOfferList);
            int m = 0;
            for (class_8786<GunTableRecipe> recipeHolder : tradeOfferList) {
                if (this.canScroll(tradeOfferList.size()) && (m < this.indexStartOffset || m >= 7 + this.indexStartOffset)) {
                    ++m;
                    continue;
                }
                GunTableRecipe gunTableRecipe = (GunTableRecipe)recipeHolder.comp_1933();
                class_1799 output = gunTableRecipe.output();
                int n = yPos + 2;
                this.renderIngredients(matrices, gunTableRecipe, xPos, n, mouseX, mouseY);
                matrices.method_51448().method_22903();
                this.renderArrow(matrices, gunTableRecipe, i + 22, n);
                matrices.method_51445(output, i + 24 + 68, n);
                matrices.method_51431(this.field_22793, output, i + 24 + 68, n);
                if (this.isMouseOverSlot(i + 24 + 68, n, mouseX, mouseY)) {
                    matrices.method_51446(this.field_22793, output, mouseX, mouseY);
                }
                matrices.method_51448().method_22909();
                yPos += 20;
                ++m;
            }
            for (WidgetButtonPage widgetButtonPage : this.offers) {
                if (widgetButtonPage.method_49606()) {
                    widgetButtonPage.renderToolTip(matrices, mouseX, mouseY);
                }
                widgetButtonPage.field_22764 = widgetButtonPage.index < ((GunTableScreenHandler)this.field_2797).getRecipes().size();
            }
            RenderSystem.enableDepthTest();
        }
        this.method_2380(matrices, mouseX, mouseY);
    }

    private boolean isMouseOverSlot(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16;
    }

    private void renderArrow(class_332 matrices, GunTableRecipe tradeOffer, int x, int y) {
        RenderSystem.enableBlend();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
    }

    private void renderIngredients(class_332 matrices, GunTableRecipe gunTableRecipe, int x, int y, int mouseX, int mouseY) {
        for (int i = 0; i < gunTableRecipe.ingredients().size(); ++i) {
            class_1799 stack;
            class_1799[] displayStacks = gunTableRecipe.getIngredientForSlot(i).method_8105();
            if (displayStacks.length <= 0 || (stack = new class_1799((class_1935)displayStacks[0].method_7909(), gunTableRecipe.countRequired(i))).method_7960()) continue;
            matrices.method_51445(stack, x, y);
            matrices.method_51431(this.field_22793, stack, x, y);
            if (this.isMouseOverSlot(x, y, mouseX, mouseY)) {
                matrices.method_51446(this.field_22793, stack, mouseX, mouseY);
            }
            x += 16;
        }
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        int i = ((GunTableScreenHandler)this.field_2797).getRecipes().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.indexStartOffset = (int)((double)this.indexStartOffset - scrollY);
            this.indexStartOffset = class_3532.method_15340((int)this.indexStartOffset, (int)0, (int)j);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i = ((GunTableScreenHandler)this.field_2797).getRecipes().size();
        if (this.scrolling) {
            int j = this.field_2800 + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.indexStartOffset = class_3532.method_15340((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        if (this.canScroll(((GunTableScreenHandler)this.field_2797).getRecipes().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    class WidgetButtonPage
    extends class_4185 {
        final int index;

        public WidgetButtonPage(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 112, 20, class_5244.field_39003, onPress, field_40754);
            this.index = index;
            this.field_22764 = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void renderToolTip(class_332 matrices, int mouseX, int mouseY) {
            List<class_8786<GunTableRecipe>> recipes = ((GunTableScreenHandler)GunTableScreen.this.field_2797).getRecipes();
            if (this.field_22762 && recipes.size() > this.index + GunTableScreen.this.indexStartOffset) {
                if (mouseX < this.method_46426() + 20) {
                    GunTableScreen.this.method_2380(matrices, mouseX, mouseY);
                } else if (mouseX < this.method_46426() + 50 && mouseX > this.method_46426() + 30) {
                    class_1799 stack = ((GunTableRecipe)recipes.get(this.index + GunTableScreen.this.indexStartOffset).comp_1933()).output();
                    if (!stack.method_7960()) {
                        GunTableScreen.this.method_2380(matrices, mouseX, mouseY);
                    }
                } else if (mouseX > this.method_46426() + 65) {
                    GunTableScreen.this.method_2380(matrices, mouseX, mouseY);
                }
            }
        }
    }
}

