/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity;

import java.util.UUID;
import mod.azure.azurelib.common.util.MoveAnalysis;
import mod.azure.hwg.entity.animation.AnimationDispatcher;
import mod.azure.hwg.entity.projectiles.BlazeRodEntity;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.entity.projectiles.FireballEntity;
import mod.azure.hwg.entity.projectiles.FlameFiring;
import mod.azure.hwg.entity.projectiles.ShellEntity;
import mod.azure.hwg.item.enums.GunTypeEnum;
import mod.azure.hwg.item.weapons.AzureAnimatedGunItem;
import mod.azure.hwg.util.registry.HWGSounds;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5354;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class HWGEntity
extends class_1588
implements class_5354,
class_1569 {
    public static final class_2940<Integer> VARIANT = class_2945.method_12791(HWGEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> STATE = class_2945.method_12791(HWGEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANGER_TIME = class_2945.method_12791(HWGEntity.class, (class_2941)class_2943.field_13327);
    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505((int)20, (int)39);
    private UUID targetUuid;
    public MoveAnalysis moveAnalysis;
    public AnimationDispatcher animationDispatcher;

    protected HWGEntity(class_1299<? extends class_1588> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_5942().method_6354(true);
        this.field_5985 = true;
    }

    public static boolean canNetherSpawn(class_1299<? extends HWGEntity> type, class_1936 serverWorldAccess, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        if (serverWorldAccess.method_8407() == class_1267.field_5801) {
            return false;
        }
        if (spawnReason != class_3730.field_16472 && spawnReason != class_3730.field_16459) {
            return !serverWorldAccess.method_8320(pos.method_10074()).method_27852(class_2246.field_10541);
        }
        return !serverWorldAccess.method_8320(pos.method_10074()).method_27852(class_2246.field_10541);
    }

    protected boolean method_23734() {
        return true;
    }

    public int method_5945() {
        return 1;
    }

    public boolean method_5640(double distance) {
        return true;
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANGER_TIME, (Object)0);
        builder.method_56912(STATE, (Object)0);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGER_TIME);
    }

    public void method_29514(int ticks) {
        this.field_6011.method_12778(ANGER_TIME, (Object)ticks);
    }

    public UUID method_29508() {
        return this.targetUuid;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.targetUuid = uuid;
    }

    public void method_29509() {
        this.method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    public abstract int getVariants();

    public void shoot() {
        if (!this.method_37908().field_9236) {
            class_243 vector3d = this.method_5828(1.0f);
            class_1792 class_17922 = this.method_6118(class_1304.field_6173).method_7909();
            if (class_17922 instanceof AzureAnimatedGunItem) {
                AzureAnimatedGunItem weapon = (AzureAnimatedGunItem)class_17922;
                class_1676 bullet = this.getProjectile(weapon, weapon.getGunTypeEnum());
                bullet.method_5814(this.method_23317() + vector3d.field_1352 * 2.0, this.method_23323(0.5), this.method_23321() + vector3d.field_1350 * 2.0);
                bullet.method_24919((class_1297)this, this.method_36455(), this.method_36454(), 0.0f, 3.0f, 1.0f);
                weapon.animationDispatcher.sendFiringCommand((class_1297)this, this.method_6118(class_1304.field_6173));
                this.method_37908().method_45445((class_1297)this, this.method_24515(), this.getDefaultAttackSound(weapon.getGunTypeEnum()), class_3419.field_15251, 1.0f, 1.0f);
                this.method_37908().method_8649((class_1297)bullet);
            }
        }
    }

    public class_1676 getProjectile(AzureAnimatedGunItem item, GunTypeEnum gunTypeEnum) {
        switch (gunTypeEnum) {
            case PISTOL: 
            case LUGER: 
            case AK7: 
            case SMG: 
            case GOLDEN_PISTOL: 
            case SIL_PISTOL: 
            case HELLHORSE: 
            case MINIGUN: 
            case SNIPER: {
                return new BulletEntity(this.method_37908(), (class_1309)this, Float.valueOf(item.getAttackDamage()));
            }
            case FLAMETHROWER: {
                return new FlameFiring(this.method_37908(), (class_1309)this);
            }
            case BRIMSTONE: {
                return new BlazeRodEntity(this.method_37908(), (class_1309)this);
            }
            case BALROG: {
                return new FireballEntity(this.method_37908(), (class_1309)this);
            }
        }
        return new ShellEntity(this.method_37908(), (class_1309)this);
    }

    public class_3414 getDefaultAttackSound(GunTypeEnum gunTypeEnum) {
        switch (gunTypeEnum) {
            case PISTOL: 
            case GOLDEN_PISTOL: {
                return HWGSounds.PISTOL.get();
            }
            case LUGER: {
                return HWGSounds.LUGER.get();
            }
            case AK7: {
                return HWGSounds.AK.get();
            }
            case SMG: {
                return HWGSounds.SMG.get();
            }
            case HELLHORSE: {
                return HWGSounds.REVOLVER.get();
            }
            case SIL_PISTOL: {
                return HWGSounds.SPISTOL.get();
            }
            case FLAMETHROWER: {
                return class_3417.field_15090;
            }
            case BRIMSTONE: {
                return class_3417.field_15013;
            }
            case BALROG: {
                return (class_3414)class_3417.field_15152.comp_349();
            }
            case SNIPER: {
                return HWGSounds.SNIPER.get();
            }
            case MINIGUN: {
                return HWGSounds.MINIGUN.get();
            }
        }
        return HWGSounds.SHOTGUN.get();
    }

    public void setAnimation(Runnable animationAction) {
        animationAction.run();
    }

    protected void handleAnimations() {
        if (this.moveAnalysis.isMoving()) {
            this.setAnimation(this.animationDispatcher::sendWalkAnimation);
        } else {
            this.setAnimation(this.animationDispatcher::sendIdleAnimation);
        }
    }

    public void runAttackAnimations() {
        this.animationDispatcher.sendMeleeAnimation();
    }

    public void runRangeAttackAniamtions() {
        this.animationDispatcher.sendRangedAnimation();
    }
}

