/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons;

import commonnetwork.api.Network;
import io.netty.buffer.Unpooled;
import java.util.List;
import mod.azure.azurelib.common.util.client.ClientUtils;
import mod.azure.hwg.CommonMod;
import mod.azure.hwg.client.HWGKeybinds;
import mod.azure.hwg.entity.projectiles.BlazeRodEntity;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.entity.projectiles.FireballEntity;
import mod.azure.hwg.entity.projectiles.FlameFiring;
import mod.azure.hwg.entity.projectiles.MBulletEntity;
import mod.azure.hwg.entity.projectiles.RocketEntity;
import mod.azure.hwg.entity.projectiles.SBulletEntity;
import mod.azure.hwg.entity.projectiles.ShellEntity;
import mod.azure.hwg.item.enums.GunTypeEnum;
import mod.azure.hwg.item.enums.ProjectileEnum;
import mod.azure.hwg.item.weapons.animations.GunDispatcher;
import mod.azure.hwg.network.ReloadPacket;
import mod.azure.hwg.util.Helper;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

public abstract class AzureAnimatedGunItem
extends class_1792 {
    protected class_1792 ammoType;
    protected final String id;
    protected final class_3414 firingSound;
    protected final class_3414 reloadSound;
    protected final GunTypeEnum gunTypeEnum;
    public static final String firing = "firing";
    private static final String controller = "controller";
    protected final ProjectileEnum projectileTypeEnum;
    public GunDispatcher animationDispatcher;

    public AzureAnimatedGunItem(String id, ProjectileEnum projectileTypeEnum, GunTypeEnum gunTypeEnum, int maxClipSize, class_3414 reloadSound, class_3414 firingSound) {
        super(new class_1792.class_1793().method_7889(1).method_7895(maxClipSize + 1));
        this.id = id;
        this.projectileTypeEnum = projectileTypeEnum;
        this.gunTypeEnum = gunTypeEnum;
        this.reloadSound = reloadSound;
        this.firingSound = firingSound;
        this.animationDispatcher = new GunDispatcher();
    }

    public String getItemID() {
        return this.id;
    }

    public ProjectileEnum getProjectileTypeEnum() {
        return this.projectileTypeEnum;
    }

    public GunTypeEnum getGunTypeEnum() {
        return this.gunTypeEnum;
    }

    public class_1792 getAmmoType() {
        switch (this.getProjectileTypeEnum()) {
            case BULLET: 
            case HELL: {
                this.ammoType = HWGItems.BULLETS.get();
                break;
            }
            case BLAZE: {
                this.ammoType = class_1802.field_8894;
                break;
            }
            case MEANIE: {
                this.ammoType = class_1802.field_8725;
                break;
            }
            case SHELL: {
                this.ammoType = HWGItems.SHOTGUN_SHELL.get();
                break;
            }
            case ROCKET: {
                this.ammoType = HWGItems.ROCKET.get();
                break;
            }
            case FLAMES: 
            case FIREBALL: {
                this.ammoType = (class_1792)HWGItems.FUEL_TANK.get();
                break;
            }
            case SILVER_BULLET: {
                this.ammoType = HWGItems.SILVERBULLET.get();
            }
        }
        return this.ammoType;
    }

    public class_3414 getReloadSound() {
        return this.reloadSound;
    }

    public class_3414 getFiringSound() {
        return this.firingSound;
    }

    public int getReloadAmount() {
        if (this.gunTypeEnum == GunTypeEnum.FLAMETHROWER) {
            return CommonMod.config.gunconfigs.flammerconfigs.flammer_cap;
        }
        if (this.gunTypeEnum == GunTypeEnum.BRIMSTONE) {
            return CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_cap;
        }
        return 1;
    }

    public int getCoolDown() {
        switch (this.gunTypeEnum) {
            case FLAMETHROWER: {
                return CommonMod.config.gunconfigs.flammerconfigs.flammer_cooldown;
            }
            case SMG: {
                return CommonMod.config.gunconfigs.smgconfigs.smg_cooldown;
            }
            case AK7: {
                return CommonMod.config.gunconfigs.ak47configs.ak47_cooldown;
            }
            case TOMMYGUN: {
                return CommonMod.config.gunconfigs.tommyconfigs.tommy_cooldown;
            }
            case MINIGUN: {
                return CommonMod.config.gunconfigs.minigunconfigs.minigun_cooldown;
            }
            case GOLDEN_PISTOL: {
                return CommonMod.config.gunconfigs.gpistolconfigs.golden_pistol_cooldown;
            }
            case BALROG: {
                return CommonMod.config.gunconfigs.balrogconfigs.balrog_cooldown;
            }
            case BRIMSTONE: {
                return CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_cooldown;
            }
            case HELLHORSE: 
            case SILVER_HELL: {
                return CommonMod.config.gunconfigs.hellhorseconfigs.hellhorse_cooldown;
            }
            case LUGER: {
                return CommonMod.config.gunconfigs.lugerconfigs.luger_cooldown;
            }
            case MEANIE: {
                return CommonMod.config.gunconfigs.meanieconfigs.meanie_cooldown;
            }
            case PISTOL: 
            case SILVER_PISTOL: {
                return CommonMod.config.gunconfigs.pistolconfigs.pistol_cooldown;
            }
            case SIL_PISTOL: {
                return CommonMod.config.gunconfigs.silencedpistolconfigs.silenced_pistol_cooldown;
            }
            case ROCKETLAUNCHER: {
                return CommonMod.config.gunconfigs.rocketlauncherconfigs.rocketlauncherCooldown;
            }
            case SHOTGUN: {
                return CommonMod.config.gunconfigs.shotgunconfigs.shotgun_cooldown;
            }
            case SNIPER: {
                return CommonMod.config.gunconfigs.sniperconfigs.sniper_cooldown;
            }
        }
        return 10;
    }

    public int getReloadCoolDown() {
        switch (this.gunTypeEnum) {
            case FLAMETHROWER: {
                return CommonMod.config.gunconfigs.flammerconfigs.flammerReloadCooldown;
            }
            case SMG: {
                return CommonMod.config.gunconfigs.smgconfigs.smgReloadCooldown;
            }
            case AK7: {
                return CommonMod.config.gunconfigs.ak47configs.ak47ReloadCooldown;
            }
            case TOMMYGUN: {
                return CommonMod.config.gunconfigs.tommyconfigs.tommyReloadCooldown;
            }
            case MINIGUN: {
                return CommonMod.config.gunconfigs.minigunconfigs.minigunReloadCooldown;
            }
            case GOLDEN_PISTOL: {
                return CommonMod.config.gunconfigs.gpistolconfigs.goldenPistolReloadCooldown;
            }
            case BALROG: {
                return CommonMod.config.gunconfigs.balrogconfigs.balrogReloadCooldown;
            }
            case BRIMSTONE: {
                return CommonMod.config.gunconfigs.brimstoneconfigs.brimstoneReloadCooldown;
            }
            case HELLHORSE: 
            case SILVER_HELL: {
                return CommonMod.config.gunconfigs.hellhorseconfigs.hellhorseReloadCooldown;
            }
            case LUGER: {
                return CommonMod.config.gunconfigs.lugerconfigs.lugerReloadCooldown;
            }
            case MEANIE: {
                return CommonMod.config.gunconfigs.meanieconfigs.meanieReloadCooldown;
            }
            case PISTOL: 
            case SILVER_PISTOL: {
                return CommonMod.config.gunconfigs.pistolconfigs.pistolReloadCooldown;
            }
            case SIL_PISTOL: {
                return CommonMod.config.gunconfigs.silencedpistolconfigs.silencedPistolReloadCooldown;
            }
            case ROCKETLAUNCHER: {
                return CommonMod.config.gunconfigs.rocketlauncherconfigs.rocketlauncherReloadCooldown;
            }
            case SHOTGUN: {
                return CommonMod.config.gunconfigs.shotgunconfigs.shotgunReloadCooldown;
            }
            case SNIPER: {
                return CommonMod.config.gunconfigs.sniperconfigs.sniperReloadCooldown;
            }
        }
        return 10;
    }

    public float getAttackDamage() {
        switch (this.gunTypeEnum) {
            case FLAMETHROWER: 
            case BALROG: 
            case ROCKETLAUNCHER: {
                return 0.0f;
            }
            case SMG: {
                return CommonMod.config.gunconfigs.smgconfigs.smg_damage;
            }
            case AK7: {
                return CommonMod.config.gunconfigs.ak47configs.ak47_damage;
            }
            case TOMMYGUN: {
                return CommonMod.config.gunconfigs.tommyconfigs.tommy_damage;
            }
            case MINIGUN: {
                return CommonMod.config.gunconfigs.minigunconfigs.minigun_damage;
            }
            case GOLDEN_PISTOL: {
                return CommonMod.config.gunconfigs.gpistolconfigs.golden_pistol_damage;
            }
            case BRIMSTONE: {
                return CommonMod.config.gunconfigs.brimstoneconfigs.brimstone_damage;
            }
            case HELLHORSE: 
            case SILVER_HELL: {
                return CommonMod.config.gunconfigs.hellhorseconfigs.hellhorse_damage;
            }
            case LUGER: {
                return CommonMod.config.gunconfigs.lugerconfigs.luger_damage;
            }
            case MEANIE: {
                return CommonMod.config.gunconfigs.meanieconfigs.meanie_damage;
            }
            case PISTOL: 
            case SILVER_PISTOL: {
                return CommonMod.config.gunconfigs.pistolconfigs.pistol_damage;
            }
            case SIL_PISTOL: {
                return CommonMod.config.gunconfigs.silencedpistolconfigs.silenced_pistol_damage;
            }
            case SHOTGUN: {
                return CommonMod.config.gunconfigs.shotgunconfigs.shotgun_damage;
            }
            case SNIPER: {
                return CommonMod.config.gunconfigs.sniperconfigs.sniper_damage;
            }
        }
        return 0.0f;
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        player.method_6019(hand);
        return class_1271.method_22428((Object)itemStack);
    }

    public void method_7852(@NotNull class_1937 level, @NotNull class_1309 livingEntity, @NotNull class_1799 stack, int remainingUseDuration) {
        if (livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            AzureAnimatedGunItem.shoot(player);
            AzureAnimatedGunItem.recoil(player);
        }
        super.method_7852(level, livingEntity, stack, remainingUseDuration);
    }

    private void singleFire(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1657 player) {
        player.method_7357().method_7906((class_1792)this, this.getCoolDown());
        switch (this.getProjectileTypeEnum()) {
            case BULLET: {
                BulletEntity bullet = Helper.createBullet(level, (class_1309)player, this.getAttackDamage());
                bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 20.0f, 1.0f);
                bullet.field_6012 = -15;
                level.method_8649((class_1297)bullet);
                break;
            }
            case HELL: {
                BulletEntity bullet = Helper.createBullet(level, (class_1309)player, this.getAttackDamage());
                bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 60.0f, 1.0f);
                bullet.field_6012 = -15;
                level.method_8649((class_1297)bullet);
                break;
            }
            case BLAZE: {
                BlazeRodEntity rod = Helper.createBlazeRod(level, (class_1309)player);
                rod.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 3.0f, 1.0f);
                rod.method_5808(player.method_23317(), player.method_23323(0.85), player.method_23321(), 0.0f, 0.0f);
                rod.method_5740();
                rod.method_5809();
                BlazeRodEntity rod1 = Helper.createBlazeRod(level, (class_1309)player);
                rod1.method_24919((class_1297)player, player.method_36455() + 2.0f, player.method_36454(), 0.0f, 3.0f, 1.0f);
                rod1.method_5808(player.method_23317(), player.method_23323(0.85), player.method_23321(), 0.0f, 0.0f);
                rod1.method_5740();
                rod1.method_5809();
                BlazeRodEntity rod2 = Helper.createBlazeRod(level, (class_1309)player);
                rod2.method_24919((class_1297)player, player.method_36455(), player.method_36454() + 2.0f, 0.0f, 3.0f, 1.0f);
                rod2.method_5808(player.method_23317(), player.method_23323(0.85), player.method_23321(), 0.0f, 0.0f);
                rod2.method_5740();
                rod2.method_5809();
                BlazeRodEntity rod3 = Helper.createBlazeRod(level, (class_1309)player);
                rod3.method_24919((class_1297)player, player.method_36455(), player.method_36454() - 2.0f, 0.0f, 3.0f, 1.0f);
                rod3.method_5808(player.method_23317(), player.method_23323(0.85), player.method_23321(), 0.0f, 0.0f);
                rod3.method_5740();
                rod3.method_5809();
                level.method_8649((class_1297)rod);
                level.method_8649((class_1297)rod1);
                level.method_8649((class_1297)rod2);
                level.method_8649((class_1297)rod3);
                break;
            }
            case FIREBALL: {
                FireballEntity fireball = Helper.createFireball(level, (class_1309)player);
                fireball.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 0.75f, 1.0f);
                fireball.method_5808(player.method_23317(), player.method_23323(0.5), player.method_23321(), 0.0f, 0.0f);
                fireball.method_20803(100);
                FireballEntity fireball1 = Helper.createFireball(level, (class_1309)player);
                fireball1.method_24919((class_1297)player, player.method_36455(), player.method_36454() + 5.0f, 0.0f, 0.75f, 1.0f);
                fireball1.method_5808(player.method_23317(), player.method_23323(0.5), player.method_23321(), 0.0f, 0.0f);
                fireball1.method_20803(100);
                FireballEntity fireball2 = Helper.createFireball(level, (class_1309)player);
                fireball2.method_24919((class_1297)player, player.method_36455(), player.method_36454() - 5.0f, 0.0f, 0.75f, 1.0f);
                fireball2.method_5808(player.method_23317(), player.method_23323(0.5), player.method_23321(), 0.0f, 0.0f);
                fireball2.method_20803(100);
                level.method_8649((class_1297)fireball);
                level.method_8649((class_1297)fireball1);
                level.method_8649((class_1297)fireball2);
                break;
            }
            case MEANIE: {
                MBulletEntity bullet = Helper.createMeanieBullet(level, (class_1309)player);
                bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 60.0f, 1.0f);
                bullet.field_6012 = -15;
                level.method_8649((class_1297)bullet);
                break;
            }
            case SHELL: {
                ShellEntity bullet = Helper.createShell(level, (class_1309)player);
                bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454() + 1.0f, 0.5f, 20.0f, 1.0f);
                ShellEntity bullet1 = Helper.createShell(level, (class_1309)player);
                bullet1.method_24919((class_1297)player, player.method_36455(), player.method_36454() - 1.0f, 0.5f, 20.0f, 1.0f);
                bullet.field_6012 = -15;
                bullet1.field_6012 = -15;
                level.method_8649((class_1297)bullet);
                level.method_8649((class_1297)bullet1);
                break;
            }
            case ROCKET: {
                RocketEntity rocket = Helper.createRocket(level, (class_1309)player);
                rocket.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 1.5f, 1.0f);
                rocket.method_5808(player.method_23317(), player.method_23323(0.5), player.method_23321(), 0.0f, 0.0f);
                rocket.method_7438(2.5);
                level.method_8649((class_1297)rocket);
                break;
            }
            case SILVER_BULLET: {
                SBulletEntity bullet = Helper.createSilverBullet(level, (class_1309)player);
                bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 20.0f, 1.0f);
                bullet.field_6012 = -15;
                level.method_8649((class_1297)bullet);
                break;
            }
            case FLAMES: {
                FlameFiring flames = Helper.createFlame(level, (class_1309)player);
                flames.setProperties(player.method_36455(), player.method_36454(), 0.0f, 1.5f);
                flames.method_5841().method_12778(FlameFiring.FORCED_YAW, (Object)Float.valueOf(player.method_36454()));
                double d = player.method_23317();
                double d2 = d + (switch (player.method_5735()) {
                    case class_2350.field_11039 -> -0.5;
                    case class_2350.field_11034 -> 0.5;
                    default -> 0.0;
                });
                double d3 = player.method_23318();
                double d4 = d3 + (switch (player.method_5735()) {
                    case class_2350.field_11033 -> 0.5;
                    case class_2350.field_11036 -> (double)-1.85f;
                    default -> 0.75;
                });
                double d5 = player.method_23321();
                flames.method_5808(d2, d4, d5 + (switch (player.method_5735()) {
                    case class_2350.field_11043 -> -0.5;
                    case class_2350.field_11035 -> 0.5;
                    default -> 0.0;
                }), 0.0f, 0.0f);
                level.method_8649((class_1297)flames);
            }
        }
    }

    public void fireWeapon(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1657 player) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunItem = (AzureAnimatedGunItem)class_17922;
            if (!player.method_7357().method_7904((class_1792)gunItem)) {
                Helper.spawnLightSource((class_1297)player, player.method_37908().method_22351(player.method_24515()));
                itemStack.method_7970(1, (class_1309)player, player.method_32326(itemStack));
                if (this.getFiringSound() != null) {
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), this.getFiringSound(), class_3419.field_15248, 0.25f, 1.3f);
                }
                if (!level.field_9236) {
                    this.singleFire(itemStack, level, player);
                    gunItem.animationDispatcher.sendFiringCommand((class_1297)player, itemStack);
                }
            }
        }
    }

    public void autoFire(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1657 player) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunItem = (AzureAnimatedGunItem)class_17922;
            if (!player.method_7357().method_7904((class_1792)gunItem)) {
                Helper.spawnLightSource((class_1297)player, player.method_37908().method_22351(player.method_24515()));
                itemStack.method_7970(1, (class_1309)player, player.method_32326(itemStack));
                if (this.getFiringSound() != null) {
                    level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), this.getFiringSound(), class_3419.field_15248, 0.25f, 1.3f);
                }
                if (!level.field_9236) {
                    if (this.getProjectileTypeEnum() == ProjectileEnum.BULLET) {
                        BulletEntity bullet = Helper.createBullet(level, (class_1309)player, this.getAttackDamage());
                        bullet.method_24919((class_1297)player, player.method_36455(), player.method_36454(), 0.0f, 20.0f, 1.0f);
                        bullet.field_6012 = -15;
                        level.method_8649((class_1297)bullet);
                    }
                    gunItem.animationDispatcher.sendFiringCommand((class_1297)player, itemStack);
                }
            }
        }
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 world, @NotNull class_1297 entity, int slot, boolean selected) {
        class_1657 player;
        if (world.field_9236 && entity instanceof class_1657 && (player = (class_1657)entity).method_5998(player.method_6058()).method_7909() instanceof AzureAnimatedGunItem && selected) {
            if (HWGKeybinds.RELOAD.method_1436()) {
                class_2540 passedData = new class_2540(Unpooled.buffer());
                passedData.method_52964(true);
                Network.getNetworkHandler().sendToServer((Object)new ReloadPacket());
            }
            if (this.gunTypeEnum == GunTypeEnum.BRIMSTONE || this.gunTypeEnum == GunTypeEnum.BALROG) {
                this.animationDispatcher.sendIdleCommand(entity, stack);
            }
        }
    }

    public static void recoil(class_1657 player) {
        class_1792 class_17922;
        if (player.method_5998(player.method_6058()).method_7919() < player.method_5998(player.method_6058()).method_7936() - 1 && (class_17922 = player.method_5998(player.method_6058()).method_7909()) instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunBase = (AzureAnimatedGunItem)class_17922;
            if (player.method_37908().method_8608()) {
                float baseRecoilX = player.method_37908().method_8409().method_43056() ? 1.0f : -1.0f;
                float recoilY = 1.25f;
                ClientUtils.getClientPlayer().method_5872((double)(baseRecoilX * 5.0f), (double)(-recoilY * 5.0f));
            }
        }
    }

    public static void shoot(class_1657 player) {
        class_1792 class_17922;
        if (player.method_5998(player.method_6058()).method_7919() < player.method_5998(player.method_6058()).method_7936() - 1 && (class_17922 = player.method_5998(player.method_6058()).method_7909()) instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunBase = (AzureAnimatedGunItem)class_17922;
            if (!player.method_7357().method_7904(player.method_5998(player.method_6058()).method_7909()) && !player.method_5998(player.method_6058()).method_31574((class_1792)HWGItems.MINIGUN.get())) {
                gunBase.fireWeapon(player.method_5998(player.method_6058()), player.method_37908(), player);
            } else {
                gunBase.autoFire(player.method_5998(player.method_6058()), player.method_37908(), player);
            }
            if (player.method_37908().method_8608()) {
                float baseRecoilX = player.method_37908().method_8409().method_43056() ? 1.0f : -1.0f;
                float recoilY = 1.25f;
                ClientUtils.getClientPlayer().method_5872((double)(baseRecoilX * 5.0f), (double)(-recoilY * 5.0f));
            }
        } else {
            player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14762, class_3419.field_15248, 0.25f, 1.3f);
        }
    }

    public static void reload(class_1657 user, class_1268 hand) {
        class_1792 class_17922 = user.method_5998(user.method_6058()).method_7909();
        if (class_17922 instanceof AzureAnimatedGunItem) {
            AzureAnimatedGunItem gunBase = (AzureAnimatedGunItem)class_17922;
            while (!user.method_7337() && user.method_5998(user.method_6058()).method_7919() != 0 && user.method_31548().method_18861(gunBase.getAmmoType()) > 0) {
                Helper.removeAmmo(gunBase.getAmmoType(), user);
                user.method_7357().method_7906((class_1792)gunBase, gunBase.getReloadCoolDown());
                user.method_5998(user.method_6058()).method_7970(-gunBase.getReloadAmount(), (class_1309)user, user.method_32326(user.method_5998(user.method_6058())));
                user.method_5998(user.method_6058()).method_7912(3);
                if (gunBase.getReloadSound() != null) {
                    user.method_37908().method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), gunBase.getReloadSound(), class_3419.field_15248, 1.0f, 1.0f);
                }
                if (user.method_37908().field_9236) continue;
                if (user.method_59922().method_43051(0, 100) >= 95 && gunBase.getItemID().equalsIgnoreCase("tommy_gun")) {
                    gunBase.animationDispatcher.sendTommyReloadCommand((class_1297)user, user.method_5998(hand));
                    continue;
                }
                gunBase.animationDispatcher.sendReloadCommand((class_1297)user, user.method_5998(hand));
            }
        }
    }

    public int method_7881(@NotNull class_1799 stack, @NotNull class_1309 livingEntity) {
        return 72000;
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltip, tooltipFlag);
        tooltip.add((class_2561)class_2561.method_43471((String)("Fuel: " + (stack.method_7936() - stack.method_7919() - 1) + " / " + (stack.method_7936() - 1))).method_27692(class_124.field_1056));
        switch (this.getProjectileTypeEnum()) {
            case BULLET: 
            case HELL: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadbullets").method_27692(class_124.field_1056));
                break;
            }
            case BLAZE: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadblazerod").method_27692(class_124.field_1056));
                break;
            }
            case FLAMES: 
            case FIREBALL: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadfuel").method_27692(class_124.field_1056));
                tooltip.add((class_2561)class_2561.method_43471((String)("Fuel: " + (stack.method_7936() - stack.method_7919() - 1) + " / " + (stack.method_7936() - 1))).method_27692(class_124.field_1056));
                break;
            }
            case MEANIE: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadredstone").method_27692(class_124.field_1056));
                break;
            }
            case SHELL: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadshells").method_27692(class_124.field_1056));
                break;
            }
            case ROCKET: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadrockets").method_27692(class_124.field_1056));
                break;
            }
            case SILVER_BULLET: {
                tooltip.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadsilverbullets").method_27692(class_124.field_1056));
            }
        }
    }
}

