/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import mod.azure.hwg.entity.projectiles.BaseFlareEntity;
import mod.azure.hwg.item.weapons.HWGGunLoadedBase;
import mod.azure.hwg.item.weapons.animations.GunDispatcher;
import mod.azure.hwg.util.registry.HWGItems;
import mod.azure.hwg.util.registry.HWGSounds;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_5244;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class FlareGunItem
extends HWGGunLoadedBase {
    private GunDispatcher animationDispatcher = new GunDispatcher();
    private boolean loaded = false;
    private boolean charged = false;
    private static final Predicate<class_1799> BLACK_FLARE = stack -> stack.method_7909() == HWGItems.BLACK_FLARE;
    public static final Predicate<class_1799> FLARE = BLACK_FLARE.or(stack -> stack.method_7909() == HWGItems.BLUE_FLARE).or(stack -> stack.method_7909() == HWGItems.BROWN_FLARE).or(stack -> stack.method_7909() == HWGItems.CYAN_FLARE).or(stack -> stack.method_7909() == HWGItems.GRAY_FLARE).or(stack -> stack.method_7909() == HWGItems.GREEN_FLARE).or(stack -> stack.method_7909() == HWGItems.LIGHTBLUE_FLARE).or(stack -> stack.method_7909() == HWGItems.LIGHTGRAY_FLARE).or(stack -> stack.method_7909() == HWGItems.LIME_FLARE).or(stack -> stack.method_7909() == HWGItems.MAGENTA_FLARE).or(stack -> stack.method_7909() == HWGItems.ORANGE_FLARE).or(stack -> stack.method_7909() == HWGItems.PINK_FLARE).or(stack -> stack.method_7909() == HWGItems.PURPLE_FLARE).or(stack -> stack.method_7909() == HWGItems.RED_FLARE).or(stack -> stack.method_7909() == HWGItems.WHITE_FLARE).or(stack -> stack.method_7909() == HWGItems.YELLOW_FLARE);

    public FlareGunItem() {
        super(new class_1792.class_1793().method_7889(1).method_7895(31).method_57349(class_9334.field_49649, (Object)class_9278.field_49298));
    }

    private void shootFlare(class_1937 level, class_1309 shooter, class_1268 hand, class_1799 stack, List<class_1799> projectile, boolean creative, float speed, float divergence) {
        float i = 1.0f;
        for (class_1799 itemStack : projectile) {
            boolean yellow;
            if (itemStack.method_7960()) continue;
            i = -i;
            if (!creative) {
                stack.method_7970(this.method_57345(itemStack), shooter, class_1309.method_56079((class_1268)hand));
            }
            BaseFlareEntity flareEntity = new BaseFlareEntity(level, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true);
            boolean black = itemStack.method_7909() == HWGItems.BLACK_FLARE;
            boolean blue = itemStack.method_7909() == HWGItems.BLUE_FLARE;
            boolean brown = itemStack.method_7909() == HWGItems.BROWN_FLARE;
            boolean cyan = itemStack.method_7909() == HWGItems.CYAN_FLARE;
            boolean gray = itemStack.method_7909() == HWGItems.GRAY_FLARE;
            boolean green = itemStack.method_7909() == HWGItems.GREEN_FLARE;
            boolean lightBlue = itemStack.method_7909() == HWGItems.LIGHTBLUE_FLARE;
            boolean lightGray = itemStack.method_7909() == HWGItems.LIGHTGRAY_FLARE;
            boolean lime = itemStack.method_7909() == HWGItems.LIME_FLARE;
            boolean magenta = itemStack.method_7909() == HWGItems.MAGENTA_FLARE;
            boolean orange = itemStack.method_7909() == HWGItems.ORANGE_FLARE;
            boolean pink = itemStack.method_7909() == HWGItems.PINK_FLARE;
            boolean purple = itemStack.method_7909() == HWGItems.PURPLE_FLARE;
            boolean red = itemStack.method_7909() == HWGItems.RED_FLARE;
            boolean bl = yellow = itemStack.method_7909() == HWGItems.YELLOW_FLARE;
            if (black) {
                flareEntity.setColor(1);
            } else if (blue) {
                flareEntity.setColor(2);
            } else if (brown) {
                flareEntity.setColor(3);
            } else if (cyan) {
                flareEntity.setColor(4);
            } else if (gray) {
                flareEntity.setColor(5);
            } else if (green) {
                flareEntity.setColor(6);
            } else if (lightBlue) {
                flareEntity.setColor(7);
            } else if (lightGray) {
                flareEntity.setColor(8);
            } else if (lime) {
                flareEntity.setColor(9);
            } else if (magenta) {
                flareEntity.setColor(10);
            } else if (orange) {
                flareEntity.setColor(11);
            } else if (pink) {
                flareEntity.setColor(12);
            } else if (purple) {
                flareEntity.setColor(13);
            } else if (red) {
                flareEntity.setColor(14);
            } else if (yellow) {
                flareEntity.setColor(15);
            } else {
                flareEntity.setColor(16);
            }
            class_243 vec3d = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            class_243 vec3d2 = shooter.method_5828(1.0f);
            Vector3f vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
            vector3f.rotate((Quaternionfc)quaternionf);
            flareEntity.method_7485(vector3f.x, vector3f.y, vector3f.z, speed, divergence);
            flareEntity.method_7438(0.3);
            flareEntity.field_7572 = class_1665.class_1666.field_7592;
            if (!creative) {
                stack.method_7970(1, shooter, shooter.method_32326(shooter.method_6030()));
            }
            level.method_8649((class_1297)flareEntity);
        }
    }

    private static boolean tryLoadProjectiles(class_1309 shooter, class_1799 crossbowStack) {
        List list = FlareGunItem.method_57390((class_1799)crossbowStack, (class_1799)shooter.method_18808(crossbowStack), (class_1309)shooter);
        if (!list.isEmpty()) {
            crossbowStack.method_57379(class_9334.field_49649, (Object)class_9278.method_57441((List)list));
            return true;
        }
        return false;
    }

    public static boolean isCharged(class_1799 stack) {
        class_9278 chargedProjectiles = (class_9278)stack.method_57825(class_9334.field_49649, (Object)class_9278.field_49298);
        return !chargedProjectiles.method_57442();
    }

    /*
     * Unable to fully structure code
     */
    public void shootAll(class_1937 level, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        block2: {
            if (level.method_8608() || (chargedProjectiles = (class_9278)stack.method_57379(class_9334.field_49649, (Object)class_9278.field_49298)) == null || chargedProjectiles.method_57442()) break block2;
            if (!(entity instanceof class_1657)) ** GOTO lbl-1000
            player = (class_1657)entity;
            if (player.method_31549().field_7477) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            bl = v0;
            this.shootFlare(level, entity, hand, stack, chargedProjectiles.method_57437(), bl, speed, divergence);
        }
    }

    public static int getPullTime() {
        return 25;
    }

    public boolean method_7878(@NotNull class_1799 stack, @NotNull class_1799 ingredient) {
        return class_1834.field_8923.method_8023().method_8093(ingredient) || super.method_7878(stack, ingredient);
    }

    @NotNull
    public Predicate<class_1799> method_20310() {
        return FLARE;
    }

    @NotNull
    public Predicate<class_1799> method_19268() {
        return FLARE;
    }

    public int method_24792() {
        return 16;
    }

    protected void method_7763(@NotNull class_1309 shooter, @NotNull class_1676 projectile, int index, float velocity, float inaccuracy, float angle, @Nullable class_1309 target) {
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 usedHand) {
        class_1799 itemStack = player.method_5998(usedHand);
        class_9278 chargedProjectiles = (class_9278)itemStack.method_57824(class_9334.field_49649);
        if (chargedProjectiles != null && !chargedProjectiles.method_57442()) {
            this.shootAll(level, (class_1309)player, usedHand, itemStack, 2.6f, 1.0f);
            player.method_7357().method_7906((class_1792)this, 25);
            if (!level.field_9236) {
                this.animationDispatcher.sendFiringCommand((class_1297)player, itemStack);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        if (!player.method_18808(itemStack).method_7960()) {
            player.method_6019(usedHand);
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 livingEntity, int remainingUseTicks) {
        if (!FlareGunItem.isCharged(stack) && FlareGunItem.tryLoadProjectiles(livingEntity, stack)) {
            class_3419 soundCategory = livingEntity instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            level.method_43128(null, livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321(), HWGSounds.GLAUNCHERRELOAD.get(), soundCategory, 0.5f, 1.0f);
            if (!level.field_9236 && stack.method_7909() instanceof FlareGunItem) {
                this.animationDispatcher.sendLoadingCommand((class_1297)livingEntity, stack);
            }
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                player.method_7357().method_7906((class_1792)this, 15);
            }
        }
    }

    public void method_7852(class_1937 world, @NotNull class_1309 user, @NotNull class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            float f = (float)(stack.method_7935(user) - remainingUseTicks) / (float)FlareGunItem.getPullTime();
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
            }
            if (f >= 0.5f && !this.loaded) {
                this.loaded = true;
            }
        }
    }

    @Override
    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        class_9278 chargedProjectiles = (class_9278)stack.method_57824(class_9334.field_49649);
        if (chargedProjectiles != null && !chargedProjectiles.method_57442()) {
            class_1799 itemStack = (class_1799)chargedProjectiles.method_57437().getFirst();
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Ammo").method_10852(class_5244.field_41874).method_10852(itemStack.method_7954()));
            if (tooltipFlag.method_8035() && itemStack.method_7909() == FLARE) {
                ArrayList list = Lists.newArrayList();
                HWGItems.FLARE_GUN.get().method_7851(itemStack, context, list, tooltipFlag);
                if (!list.isEmpty()) {
                    list.replaceAll(component -> class_2561.method_43470((String)"  ").method_10852(component).method_27692(class_124.field_1080));
                    tooltipComponents.addAll(list);
                }
            }
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"hwg.ammo.reloadflares").method_27692(class_124.field_1056));
    }
}

