/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class BlockBreakProgressManager {
    private static final Map<class_2338, Map.Entry<Long, Float>> BLOCK_BREAK_PROGRESS_MAP = new HashMap<class_2338, Map.Entry<Long, Float>>();

    public static void tick(class_1937 level) {
        long gameTime = level.method_8510();
        if (gameTime % 400L != 0L) {
            return;
        }
        BLOCK_BREAK_PROGRESS_MAP.entrySet().removeIf(entry -> {
            Long lastUpdateTimeMillis = (Long)((Map.Entry)entry.getValue()).getKey();
            return System.currentTimeMillis() > lastUpdateTimeMillis;
        });
    }

    public static void damage(class_1937 level, class_2338 blockPos, float damage) {
        class_2338 immutableBlockPos = blockPos.method_10062();
        BLOCK_BREAK_PROGRESS_MAP.compute(immutableBlockPos, (key, entry) -> {
            class_2680 blockState = level.method_8320(immutableBlockPos);
            class_2248 block = blockState.method_26204();
            float currentDestroyProgress = entry == null ? 0.0f : ((Float)entry.getValue()).floatValue();
            float defaultDestroyTimeInSeconds = block.method_36555();
            if (defaultDestroyTimeInSeconds < 0.0f) {
                return null;
            }
            float destroyTimeInTicks = block.method_36555() * 20.0f;
            float weight = Math.max(destroyTimeInTicks, 1.0f);
            float newDestroyProgress = currentDestroyProgress + damage / weight;
            int progress = (int)class_3532.method_15363((float)newDestroyProgress, (float)0.0f, (float)9.0f);
            int hash = Objects.hash(immutableBlockPos);
            if (progress >= 9) {
                level.method_8517(hash, immutableBlockPos, -1);
                level.method_22352(immutableBlockPos, false);
                return null;
            }
            level.method_8517(hash, immutableBlockPos, progress);
            return Map.entry(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L), Float.valueOf(newDestroyProgress));
        });
    }

    private BlockBreakProgressManager() {
        throw new UnsupportedOperationException();
    }
}

