/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.h2.command.ddl;

import jn.willfrydev.xhubblocks.lib.h2.command.ddl.AlterTable;
import jn.willfrydev.xhubblocks.lib.h2.constraint.ConstraintReferential;
import jn.willfrydev.xhubblocks.lib.h2.engine.Database;
import jn.willfrydev.xhubblocks.lib.h2.engine.DbObject;
import jn.willfrydev.xhubblocks.lib.h2.engine.SessionLocal;
import jn.willfrydev.xhubblocks.lib.h2.schema.Schema;
import jn.willfrydev.xhubblocks.lib.h2.table.Column;
import jn.willfrydev.xhubblocks.lib.h2.table.Table;

public class AlterTableRenameColumn
extends AlterTable {
    private boolean ifExists;
    private String oldName;
    private String newName;

    public AlterTableRenameColumn(SessionLocal sessionLocal, Schema schema) {
        super(sessionLocal, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setOldColumnName(String string) {
        this.oldName = string;
    }

    public void setNewColumnName(String string) {
        this.newName = string;
    }

    @Override
    public long update(Table table) {
        Column column = table.getColumn(this.oldName, this.ifExists);
        if (column == null) {
            return 0L;
        }
        table.checkSupportAlter();
        table.renameColumn(column, this.newName);
        table.setModified();
        Database database = this.session.getDatabase();
        database.updateMeta(this.session, table);
        for (DbObject dbObject : table.getChildren()) {
            if (!(dbObject instanceof ConstraintReferential)) continue;
            ConstraintReferential constraintReferential = (ConstraintReferential)dbObject;
            constraintReferential.updateOnTableColumnRename();
        }
        for (DbObject dbObject : table.getChildren()) {
            if (dbObject.getCreateSQL() == null) continue;
            database.updateMeta(this.session, dbObject);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 16;
    }
}

