/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.h2.expression.function;

import jn.willfrydev.xhubblocks.lib.h2.engine.SessionLocal;
import jn.willfrydev.xhubblocks.lib.h2.expression.Expression;
import jn.willfrydev.xhubblocks.lib.h2.expression.TypedValueExpression;
import jn.willfrydev.xhubblocks.lib.h2.expression.ValueExpression;
import jn.willfrydev.xhubblocks.lib.h2.expression.function.Function1;
import jn.willfrydev.xhubblocks.lib.h2.schema.Domain;
import jn.willfrydev.xhubblocks.lib.h2.table.Column;
import jn.willfrydev.xhubblocks.lib.h2.value.TypeInfo;
import jn.willfrydev.xhubblocks.lib.h2.value.Value;
import jn.willfrydev.xhubblocks.lib.h2.value.ValueNull;

public final class CastSpecification
extends Function1 {
    private Domain domain;

    public CastSpecification(Expression expression, Column column) {
        super(expression);
        this.type = column.getType();
        this.domain = column.getDomain();
    }

    public CastSpecification(Expression expression, TypeInfo typeInfo) {
        super(expression);
        this.type = typeInfo;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = this.arg.getValue(sessionLocal).castTo(this.type, sessionLocal);
        if (this.domain != null) {
            this.domain.checkConstraints(sessionLocal, value);
        }
        return value;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        Value value;
        this.arg = this.arg.optimize(sessionLocal);
        if (this.arg.isConstant() && ((value = this.getValue(sessionLocal)) == ValueNull.INSTANCE || CastSpecification.canOptimizeCast(this.arg.getType().getValueType(), this.type.getValueType()))) {
            return TypedValueExpression.get(value, this.type);
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        return this.arg instanceof ValueExpression && CastSpecification.canOptimizeCast(this.arg.getType().getValueType(), this.type.getValueType());
    }

    private static boolean canOptimizeCast(int n, int n2) {
        switch (n) {
            case 18: {
                switch (n2) {
                    case 19: 
                    case 20: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 19: {
                switch (n2) {
                    case 18: 
                    case 20: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 17: {
                if (n2 != 21) break;
                return false;
            }
            case 20: {
                switch (n2) {
                    case 19: 
                    case 21: {
                        return false;
                    }
                }
                break;
            }
            case 21: {
                switch (n2) {
                    case 17: 
                    case 18: 
                    case 20: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        stringBuilder.append("CAST(");
        this.arg.getUnenclosedSQL(stringBuilder, this.arg instanceof ValueExpression ? n | 4 : n).append(" AS ");
        return (this.domain != null ? this.domain : this.type).getSQL(stringBuilder, n).append(')');
    }

    @Override
    public String getName() {
        return "CAST";
    }
}

