/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.h2.expression.function;

import jn.willfrydev.xhubblocks.lib.h2.engine.SessionLocal;
import jn.willfrydev.xhubblocks.lib.h2.expression.Expression;
import jn.willfrydev.xhubblocks.lib.h2.expression.TypedValueExpression;
import jn.willfrydev.xhubblocks.lib.h2.expression.function.Function2;
import jn.willfrydev.xhubblocks.lib.h2.value.TypeInfo;
import jn.willfrydev.xhubblocks.lib.h2.value.Value;
import jn.willfrydev.xhubblocks.lib.h2.value.ValueNull;

public final class NullIfFunction
extends Function2 {
    public NullIfFunction(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = this.left.getValue(sessionLocal);
        if (sessionLocal.compareWithNull(value, this.right.getValue(sessionLocal), true) == 0) {
            value = ValueNull.INSTANCE;
        }
        return value;
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.left = this.left.optimize(sessionLocal);
        this.right = this.right.optimize(sessionLocal);
        this.type = this.left.getType();
        TypeInfo.checkComparable(this.type, this.right.getType());
        if (this.left.isConstant() && this.right.isConstant()) {
            return TypedValueExpression.getTypedIfNull(this.getValue(sessionLocal), this.type);
        }
        return this;
    }

    @Override
    public String getName() {
        return "NULLIF";
    }
}

