/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.h2.expression.function.table;

import java.util.ArrayList;
import jn.willfrydev.xhubblocks.lib.h2.engine.Database;
import jn.willfrydev.xhubblocks.lib.h2.engine.SessionLocal;
import jn.willfrydev.xhubblocks.lib.h2.expression.Expression;
import jn.willfrydev.xhubblocks.lib.h2.expression.ExpressionColumn;
import jn.willfrydev.xhubblocks.lib.h2.expression.function.table.TableFunction;
import jn.willfrydev.xhubblocks.lib.h2.message.DbException;
import jn.willfrydev.xhubblocks.lib.h2.result.LocalResult;
import jn.willfrydev.xhubblocks.lib.h2.result.ResultInterface;
import jn.willfrydev.xhubblocks.lib.h2.table.Column;
import jn.willfrydev.xhubblocks.lib.h2.value.Value;
import jn.willfrydev.xhubblocks.lib.h2.value.ValueCollectionBase;
import jn.willfrydev.xhubblocks.lib.h2.value.ValueInteger;
import jn.willfrydev.xhubblocks.lib.h2.value.ValueNull;

public final class ArrayTableFunction
extends TableFunction {
    public static final int UNNEST = 0;
    public static final int TABLE = 1;
    public static final int TABLE_DISTINCT = 2;
    private Column[] columns;
    private static final String[] NAMES = new String[]{"UNNEST", "TABLE", "TABLE_DISTINCT"};
    private final int function;

    public ArrayTableFunction(int n) {
        super(new Expression[1]);
        this.function = n;
    }

    @Override
    public ResultInterface getValue(SessionLocal sessionLocal) {
        return this.getTable(sessionLocal, false);
    }

    @Override
    public void optimize(SessionLocal sessionLocal) {
        super.optimize(sessionLocal);
        if (this.args.length < 1) {
            throw DbException.get(7001, this.getName(), ">0");
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, int n) {
        if (this.function == 0) {
            super.getSQL(stringBuilder, n);
            if (this.args.length < this.columns.length) {
                stringBuilder.append(" WITH ORDINALITY");
            }
        } else {
            stringBuilder.append(this.getName()).append('(');
            for (int i = 0; i < this.args.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.columns[i].getCreateSQL()).append('=');
                this.args[i].getUnenclosedSQL(stringBuilder, n);
            }
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    @Override
    public ResultInterface getValueTemplate(SessionLocal sessionLocal) {
        return this.getTable(sessionLocal, true);
    }

    public void setColumns(ArrayList<Column> arrayList) {
        this.columns = arrayList.toArray(new Column[0]);
    }

    private ResultInterface getTable(SessionLocal sessionLocal, boolean bl) {
        int n = this.columns.length;
        Expression[] expressionArray = new Expression[n];
        Database database = sessionLocal.getDatabase();
        for (int i = 0; i < n; ++i) {
            Column column = this.columns[i];
            ExpressionColumn expressionColumn = new ExpressionColumn(database, column);
            expressionArray[i] = expressionColumn;
        }
        LocalResult localResult = new LocalResult(sessionLocal, expressionArray, n, n);
        if (!bl && this.function == 2) {
            localResult.setDistinct();
        }
        if (!bl) {
            Value[] valueArray;
            int n2;
            Object object;
            int n3;
            int n4 = n;
            boolean bl2 = this.function == 0;
            boolean bl3 = false;
            if (bl2 && (n4 = this.args.length) < n) {
                bl3 = true;
            }
            Value[][] valueArrayArray = new Value[n4][];
            int n5 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                object = this.args[n3].getValue(sessionLocal);
                if (object == ValueNull.INSTANCE) {
                    valueArrayArray[n3] = Value.EMPTY_VALUES;
                    continue;
                }
                n2 = object.getValueType();
                if (n2 != 40 && n2 != 41) {
                    object = object.convertToAnyArray(sessionLocal);
                }
                valueArrayArray[n3] = valueArray = ((ValueCollectionBase)object).getList();
                n5 = Math.max(n5, valueArray.length);
            }
            for (n3 = 0; n3 < n5; ++n3) {
                object = new Value[n];
                for (n2 = 0; n2 < n4; ++n2) {
                    Value value;
                    valueArray = valueArrayArray[n2];
                    if (valueArray.length <= n3) {
                        value = ValueNull.INSTANCE;
                    } else {
                        Column column = this.columns[n2];
                        value = valueArray[n3];
                        if (!bl2) {
                            value = value.convertForAssignTo(column.getType(), sessionLocal, column);
                        }
                    }
                    object[n2] = value;
                }
                if (bl3) {
                    object[n4] = ValueInteger.get(n3 + 1);
                }
                localResult.addRow((Value)object);
            }
        }
        localResult.done();
        return localResult;
    }

    @Override
    public String getName() {
        return NAMES[this.function];
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    public int getFunctionType() {
        return this.function;
    }
}

