/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.hikari.metrics.prometheus;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jn.willfrydev.xhubblocks.lib.hikari.metrics.IMetricsTracker;
import jn.willfrydev.xhubblocks.lib.hikari.metrics.MetricsTrackerFactory;
import jn.willfrydev.xhubblocks.lib.hikari.metrics.PoolStats;
import jn.willfrydev.xhubblocks.lib.hikari.metrics.prometheus.HikariCPCollector;
import jn.willfrydev.xhubblocks.lib.hikari.metrics.prometheus.PrometheusHistogramMetricsTracker;
import jn.willfrydev.xhubblocks.lib.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

public class PrometheusHistogramMetricsTrackerFactory
implements MetricsTrackerFactory {
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> registrationStatuses = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final HikariCPCollector collector = new HikariCPCollector();
    private final CollectorRegistry collectorRegistry;

    public PrometheusHistogramMetricsTrackerFactory() {
        this(CollectorRegistry.defaultRegistry);
    }

    public PrometheusHistogramMetricsTrackerFactory(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
    }

    @Override
    public IMetricsTracker create(String poolName, PoolStats poolStats) {
        this.registerCollector(this.collector, this.collectorRegistry);
        this.collector.add(poolName, poolStats);
        return new PrometheusHistogramMetricsTracker(poolName, this.collectorRegistry, this.collector);
    }

    private void registerCollector(Collector collector, CollectorRegistry collectorRegistry) {
        if (registrationStatuses.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            collector.register(collectorRegistry);
        }
    }
}

