/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import jn.willfrydev.xhubblocks.lib.mysql.cj.conf.PropertyKey;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.CJException;
import jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.JdbcConnection;
import jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.MysqlDataSource;
import jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.MysqlXAConnection;
import jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.SuspendableXAConnection;
import jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;

public class MysqlXADataSource
extends MysqlDataSource
implements XADataSource {
    static final long serialVersionUID = 7911390333152247455L;

    @Override
    public XAConnection getXAConnection() throws SQLException {
        try {
            Connection conn = this.getConnection();
            return this.wrapConnection(conn);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    @Override
    public XAConnection getXAConnection(String u, String p) throws SQLException {
        try {
            Connection conn = this.getConnection(u, p);
            return this.wrapConnection(conn);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    private XAConnection wrapConnection(Connection conn) throws SQLException {
        if (this.getBooleanProperty(PropertyKey.pinGlobalTxToPhysicalConnection).getValue().booleanValue() || ((JdbcConnection)conn).getPropertySet().getBooleanProperty(PropertyKey.pinGlobalTxToPhysicalConnection).getValue().booleanValue()) {
            return SuspendableXAConnection.getInstance((JdbcConnection)conn);
        }
        return MysqlXAConnection.getInstance((JdbcConnection)conn, this.getBooleanProperty(PropertyKey.logXaCommands).getValue());
    }
}

