/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.interceptors;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jn.willfrydev.xhubblocks.lib.mysql.cj.Messages;
import jn.willfrydev.xhubblocks.lib.mysql.cj.MysqlConnection;
import jn.willfrydev.xhubblocks.lib.mysql.cj.Query;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.ExceptionFactory;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.WrongArgumentException;
import jn.willfrydev.xhubblocks.lib.mysql.cj.interceptors.QueryInterceptor;
import jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.result.ResultSetInternalMethods;
import jn.willfrydev.xhubblocks.lib.mysql.cj.log.Log;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.Resultset;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.ServerSession;

public class ResultSetScannerInterceptor
implements QueryInterceptor {
    public static final String PNAME_resultSetScannerRegex = "resultSetScannerRegex";
    protected Pattern regexP;

    @Override
    public QueryInterceptor init(MysqlConnection conn, Properties props, Log log) {
        String regexFromUser = props.getProperty(PNAME_resultSetScannerRegex);
        if (regexFromUser == null || regexFromUser.length() == 0) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ResultSetScannerInterceptor.0"));
        }
        try {
            this.regexP = Pattern.compile(regexFromUser);
        }
        catch (Throwable t) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ResultSetScannerInterceptor.1"), t);
        }
        return this;
    }

    @Override
    public <T extends Resultset> T postProcess(Supplier<String> sql, Query interceptedQuery, T originalResultSet, ServerSession serverSession) {
        final T finalResultSet = originalResultSet;
        return (T)((Resultset)Proxy.newProxyInstance(originalResultSet.getClass().getClassLoader(), new Class[]{Resultset.class, ResultSetInternalMethods.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Matcher matcher;
                if ("equals".equals(method.getName())) {
                    return args[0].equals(this);
                }
                Object invocationResult = method.invoke((Object)finalResultSet, args);
                String methodName = method.getName();
                if ((invocationResult != null && invocationResult instanceof String || "getString".equals(methodName) || "getObject".equals(methodName) || "getObjectStoredProc".equals(methodName)) && (matcher = ResultSetScannerInterceptor.this.regexP.matcher(invocationResult.toString())).matches()) {
                    throw new SQLException(Messages.getString("ResultSetScannerInterceptor.2"));
                }
                return invocationResult;
            }
        }));
    }

    @Override
    public <T extends Resultset> T preProcess(Supplier<String> sql, Query interceptedQuery) {
        return null;
    }

    @Override
    public boolean executeTopLevelOnly() {
        return false;
    }

    @Override
    public void destroy() {
    }
}

