/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.a;

import java.nio.charset.StandardCharsets;
import jn.willfrydev.xhubblocks.lib.mysql.cj.BindValue;
import jn.willfrydev.xhubblocks.lib.mysql.cj.conf.PropertyKey;
import jn.willfrydev.xhubblocks.lib.mysql.cj.conf.PropertySet;
import jn.willfrydev.xhubblocks.lib.mysql.cj.conf.RuntimeProperty;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.ExceptionInterceptor;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.Message;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.ServerSession;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.a.AbstractValueEncoder;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.a.NativeConstants;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.a.NativePacketPayload;
import jn.willfrydev.xhubblocks.lib.mysql.cj.util.StringUtils;

public class ByteArrayValueEncoder
extends AbstractValueEncoder {
    protected RuntimeProperty<Integer> maxByteArrayAsHex;

    @Override
    public void init(PropertySet pset, ServerSession serverSess, ExceptionInterceptor excInterceptor) {
        super.init(pset, serverSess, excInterceptor);
        this.maxByteArrayAsHex = pset.getIntegerProperty(PropertyKey.maxByteArrayAsHex);
    }

    @Override
    public byte[] getBytes(BindValue binding) {
        if (binding.escapeBytesIfNeeded()) {
            return this.escapeBytesIfNeeded((byte[])binding.getValue());
        }
        return (byte[])binding.getValue();
    }

    @Override
    public String getString(BindValue binding) {
        if (binding.escapeBytesIfNeeded() && binding.getBinaryLength() <= (long)this.maxByteArrayAsHex.getValue().intValue()) {
            return StringUtils.toString(this.escapeBytesIfNeeded((byte[])binding.getValue()), StandardCharsets.US_ASCII);
        }
        return "** BYTE ARRAY DATA **";
    }

    @Override
    public void encodeAsBinary(Message msg, BindValue binding) {
        ((NativePacketPayload)msg).writeBytes(NativeConstants.StringSelfDataType.STRING_LENENC, (byte[])binding.getValue());
    }
}

