/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x;

import java.io.InputStream;
import java.io.OutputStream;
import jn.willfrydev.xhubblocks.lib.mysql.cj.Messages;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.CJException;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.ExceptionFactory;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.WrongArgumentException;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.CompressionAlgorithm;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.CompressionMode;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.ContinuousInputStream;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.ContinuousOutputStream;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.ReusableOutputStream;
import jn.willfrydev.xhubblocks.lib.mysql.cj.util.Util;

public class CompressorStreamsFactory {
    private CompressionAlgorithm compressionAlgorithm;
    private InputStream compressorInputStreamInstance = null;
    private ContinuousInputStream underlyingInputStream = null;
    private OutputStream compressorOutputStreamInstance = null;
    private ReusableOutputStream underlyingOutputStream = null;

    public CompressorStreamsFactory(CompressionAlgorithm algorithm) {
        this.compressionAlgorithm = algorithm;
    }

    public CompressionMode getCompressionMode() {
        return this.compressionAlgorithm.getCompressionMode();
    }

    public boolean areCompressedStreamsContinuous() {
        return this.getCompressionMode() == CompressionMode.STREAM;
    }

    public InputStream getInputStreamInstance(InputStream in) {
        InputStream compressionIn;
        InputStream underlyingIn = in;
        if (this.areCompressedStreamsContinuous()) {
            if (this.compressorInputStreamInstance != null) {
                this.underlyingInputStream.addInputStream(underlyingIn);
                return this.compressorInputStreamInstance;
            }
            this.underlyingInputStream = new ContinuousInputStream(underlyingIn);
            underlyingIn = this.underlyingInputStream;
        }
        try {
            compressionIn = Util.getInstance(InputStream.class, this.compressionAlgorithm.getInputStreamClassName(), new Class[]{InputStream.class}, new Object[]{underlyingIn}, null);
        }
        catch (CJException e) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Protocol.Compression.IoFactory.0", new Object[]{this.compressionAlgorithm.getInputStreamClassName(), this.compressionAlgorithm.getAlgorithmIdentifier()}), e);
        }
        if (this.areCompressedStreamsContinuous()) {
            this.compressorInputStreamInstance = compressionIn;
        }
        return compressionIn;
    }

    public OutputStream getOutputStreamInstance(OutputStream out) {
        OutputStream compressionOut;
        OutputStream underlyingOut = out;
        if (this.areCompressedStreamsContinuous()) {
            if (this.compressorOutputStreamInstance != null) {
                this.underlyingOutputStream.setOutputStream(underlyingOut);
                return this.compressorOutputStreamInstance;
            }
            this.underlyingOutputStream = new ReusableOutputStream(underlyingOut);
            underlyingOut = this.underlyingOutputStream;
        }
        try {
            compressionOut = Util.getInstance(OutputStream.class, this.compressionAlgorithm.getOutputStreamClassName(), new Class[]{OutputStream.class}, new Object[]{underlyingOut}, null);
        }
        catch (CJException e) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Protocol.Compression.IoFactory.1", new Object[]{this.compressionAlgorithm.getOutputStreamClassName(), this.compressionAlgorithm.getAlgorithmIdentifier()}), e);
        }
        if (this.areCompressedStreamsContinuous()) {
            this.compressorOutputStreamInstance = compressionOut = new ContinuousOutputStream(compressionOut);
        }
        return compressionOut;
    }
}

