/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.mysql.cj.result;

import java.time.LocalDate;
import jn.willfrydev.xhubblocks.lib.mysql.cj.Messages;
import jn.willfrydev.xhubblocks.lib.mysql.cj.WarningListener;
import jn.willfrydev.xhubblocks.lib.mysql.cj.conf.PropertySet;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.DataReadException;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.InternalDate;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.InternalTime;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.InternalTimestamp;
import jn.willfrydev.xhubblocks.lib.mysql.cj.result.AbstractDateTimeValueFactory;

public class LocalDateValueFactory
extends AbstractDateTimeValueFactory<LocalDate> {
    private WarningListener warningListener;

    public LocalDateValueFactory(PropertySet pset) {
        super(pset);
    }

    public LocalDateValueFactory(PropertySet pset, WarningListener warningListener) {
        this(pset);
        this.warningListener = warningListener;
    }

    @Override
    public LocalDate localCreateFromDate(InternalDate idate) {
        if (idate.getYear() == 0 && idate.getMonth() == 0 && idate.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDate.of(idate.getYear(), idate.getMonth(), idate.getDay());
    }

    @Override
    public LocalDate localCreateFromTimestamp(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalDate)this.createFromDate(its);
    }

    @Override
    public LocalDate localCreateFromDatetime(InternalTimestamp its) {
        if (this.warningListener != null) {
            this.warningListener.warningEncountered(Messages.getString("ResultSet.PrecisionLostWarning", new Object[]{this.getTargetTypeName()}));
        }
        return (LocalDate)this.createFromDate(its);
    }

    @Override
    LocalDate localCreateFromTime(InternalTime it) {
        return LocalDate.of(1970, 1, 1);
    }

    @Override
    public String getTargetTypeName() {
        return LocalDate.class.getName();
    }
}

