/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.lib.mysql.cj.xdevapi;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import jn.willfrydev.xhubblocks.lib.mysql.cj.MysqlxSession;
import jn.willfrydev.xhubblocks.lib.mysql.cj.conf.PropertySet;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.ExceptionFactory;
import jn.willfrydev.xhubblocks.lib.mysql.cj.exceptions.WrongArgumentException;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.ColumnDefinition;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.ProtocolEntity;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.ResultBuilder;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.FetchDoneEntity;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.Notice;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.StatementExecuteOk;
import jn.willfrydev.xhubblocks.lib.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import jn.willfrydev.xhubblocks.lib.mysql.cj.result.BufferedRowList;
import jn.willfrydev.xhubblocks.lib.mysql.cj.result.DefaultColumnDefinition;
import jn.willfrydev.xhubblocks.lib.mysql.cj.result.Field;
import jn.willfrydev.xhubblocks.lib.mysql.cj.result.Row;
import jn.willfrydev.xhubblocks.lib.mysql.cj.xdevapi.RowResult;
import jn.willfrydev.xhubblocks.lib.mysql.cj.xdevapi.RowResultImpl;

public class RowResultBuilder
implements ResultBuilder<RowResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private RowResult result;
    TimeZone defaultTimeZone;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public RowResultBuilder(MysqlxSession sess) {
        this.defaultTimeZone = sess.getServerSession().getDefaultTimeZone();
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public RowResult build() {
        if (this.metadata == null) {
            this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
        }
        this.result = new RowResultImpl(this.metadata, this.defaultTimeZone, new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

