/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import jn.willfrydev.xhubblocks.storage.IDataStorage;
import jn.willfrydev.xhubblocks.storage.StorageManager;

public class H2Storage
implements IDataStorage {
    private final StorageManager storageManager;
    private final String TABLE_NAME = "XHUBBLOCKS_DATA_V3";

    public H2Storage(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    @Override
    public void initTables() {
        String sql = "CREATE TABLE IF NOT EXISTS XHUBBLOCKS_DATA_V3 (uuid VARCHAR(36) NOT NULL PRIMARY KEY,placed_blocks INT NOT NULL DEFAULT 0,coins DOUBLE NOT NULL DEFAULT 0,unlocked VARCHAR(4096) NOT NULL DEFAULT 'WOOL:0',selected VARCHAR(64) NOT NULL DEFAULT 'WOOL:0');";
        try (Connection conn = this.storageManager.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CompletableFuture<IDataStorage.PlayerData> loadPlayerStats(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT placed_blocks, coins, unlocked, selected FROM XHUBBLOCKS_DATA_V3 WHERE uuid = ?;";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);){
                ps.setString(1, uuid.toString());
                try (ResultSet rs = ps.executeQuery();){
                    if (!rs.next()) return new IDataStorage.PlayerData(0, 0.0, "WOOL:0", "WOOL:0");
                    IDataStorage.PlayerData playerData = new IDataStorage.PlayerData(rs.getInt("placed_blocks"), rs.getDouble("coins"), rs.getString("unlocked"), rs.getString("selected"));
                    return playerData;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return new IDataStorage.PlayerData(0, 0.0, "WOOL:0", "WOOL:0");
        });
    }

    @Override
    public void savePlayerData(UUID uuid, int placedBlocks, double coins, String unlocked, String selected) {
        String sql = "MERGE INTO XHUBBLOCKS_DATA_V3 (uuid, placed_blocks, coins, unlocked, selected) KEY(uuid) VALUES (?, ?, ?, ?, ?);";
        try (Connection conn = this.storageManager.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setInt(2, placedBlocks);
            ps.setDouble(3, coins);
            ps.setString(4, unlocked);
            ps.setString(5, selected);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public CompletableFuture<Integer> getTotalPlacedBlocks() {
        return CompletableFuture.supplyAsync(() -> {
            String sql = "SELECT SUM(placed_blocks) AS total FROM XHUBBLOCKS_DATA_V3;";
            try (Connection conn = this.storageManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement(sql);
                 ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return 0;
                Integer n = rs.getInt("total");
                return n;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return 0;
        });
    }
}

