/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks.storage;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import jn.willfrydev.xhubblocks.lib.hikari.HikariConfig;
import jn.willfrydev.xhubblocks.lib.hikari.HikariDataSource;
import jn.willfrydev.xhubblocks.storage.H2Storage;
import jn.willfrydev.xhubblocks.storage.IDataStorage;
import jn.willfrydev.xhubblocks.storage.MySQLStorage;
import jn.willfrydev.xhubblocks.xHubBlocks;
import org.bukkit.configuration.file.FileConfiguration;

public class StorageManager {
    private final xHubBlocks plugin;
    private HikariDataSource dataSource;
    private IDataStorage dataStorage;

    public StorageManager(xHubBlocks plugin) {
        this.plugin = plugin;
    }

    public void init() {
        FileConfiguration config = this.plugin.getConfig();
        String storageType = config.getString("storage.type", "H2").toUpperCase();
        HikariConfig hikariConfig = new HikariConfig();
        try {
            if (storageType.equals("MYSQL")) {
                this.plugin.getLogger().info("Usando almacenamiento MySQL.");
                String jdbcUrl = String.format("jdbc:mysql://%s:%d/%s?useSSL=false&autoReconnect=true", config.getString("storage.mysql.host"), config.getInt("storage.mysql.port"), config.getString("storage.mysql.database"));
                hikariConfig.setDriverClassName("jn.willfrydev.xhubblocks.lib.mysql.cj.jdbc.Driver");
                hikariConfig.setJdbcUrl(jdbcUrl);
                hikariConfig.setUsername(config.getString("storage.mysql.username"));
                hikariConfig.setPassword(config.getString("storage.mysql.password"));
                hikariConfig.setMaximumPoolSize(config.getInt("storage.mysql.pool-settings.maximum-pool-size", 10));
                hikariConfig.setConnectionTimeout(config.getInt("storage.mysql.pool-settings.connection-timeout", 30000));
                this.dataStorage = new MySQLStorage(this);
            } else {
                this.plugin.getLogger().info("Usando almacenamiento H2.");
                File dbFile = new File(this.plugin.getDataFolder(), "database/xhubblocks");
                String jdbcUrl = "jdbc:h2:" + dbFile.getAbsolutePath();
                hikariConfig.setDriverClassName("jn.willfrydev.xhubblocks.lib.h2.Driver");
                hikariConfig.setJdbcUrl(jdbcUrl);
                hikariConfig.setUsername("sa");
                hikariConfig.setPassword("");
                hikariConfig.setMaximumPoolSize(config.getInt("storage.h2.pool-settings.maximum-pool-size", 5));
                this.dataStorage = new H2Storage(this);
            }
            hikariConfig.setPoolName("xHubBlocks-Pool");
            hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
            this.dataSource = new HikariDataSource(hikariConfig);
            this.plugin.getLogger().info("Pool de conexiones inicializado.");
            this.dataStorage.initTables();
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u00a1No se pudo inicializar la base de datos! " + e.getMessage());
            e.printStackTrace();
        }
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("Pool de conexiones cerrado.");
        }
    }

    public IDataStorage getDataStorage() {
        return this.dataStorage;
    }
}

