/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xhubblocks;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jn.willfrydev.xhubblocks.api.xHubBlocksAPI;
import jn.willfrydev.xhubblocks.storage.IDataStorage;
import jn.willfrydev.xhubblocks.storage.StorageManager;
import jn.willfrydev.xhubblocks.xHubBlocksPlaceholder;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class xHubBlocks
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private FileConfiguration config;
    private StorageManager storageManager;
    private IDataStorage dataStorage;
    private xHubBlocksAPI api;
    private boolean IS_LEGACY;
    private Material DEFAULT_WOOL;
    private final Map<UUID, Integer> placedBlocksCache = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Integer> sessionPlacedCache = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Double> coinsCache = new ConcurrentHashMap<UUID, Double>();
    private final Map<UUID, Set<String>> unlockedCache = new ConcurrentHashMap<UUID, Set<String>>();
    private final Map<UUID, String> selectedCache = new ConcurrentHashMap<UUID, String>();
    private int totalServerBlocksCache = 0;
    private long lastTotalCacheUpdateTime = 0L;
    private String shopTitle;
    private String mainCommandAlias = "blocks";

    public void onEnable() {
        String version = Bukkit.getServer().getClass().getPackage().getName();
        this.IS_LEGACY = (version = version.substring(version.lastIndexOf(46) + 1)).contains("v1_8") || version.contains("v1_9") || version.contains("v1_10") || version.contains("v1_11") || version.contains("v1_12");
        this.DEFAULT_WOOL = Material.getMaterial((String)"WOOL");
        if (this.DEFAULT_WOOL == null) {
            this.DEFAULT_WOOL = Material.getMaterial((String)"WHITE_WOOL");
        }
        if (this.DEFAULT_WOOL == null) {
            this.DEFAULT_WOOL = Material.STONE;
        }
        this.loadConfiguration();
        this.registerDynamicCommands();
        this.storageManager = new StorageManager(this);
        this.storageManager.init();
        this.dataStorage = this.storageManager.getDataStorage();
        this.api = new xHubBlocksAPI(this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new xHubBlocksPlaceholder(this).register();
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.loadPlayerData(p);
        }
        this.getLogger().info("xHubBlocks V3.2 Enabled. (Legacy: " + this.IS_LEGACY + ")");
    }

    public void onDisable() {
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.savePlayerData(p.getUniqueId(), false);
        }
        if (this.storageManager != null) {
            this.storageManager.close();
        }
    }

    public void loadConfiguration() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.config = this.getConfig();
        this.shopTitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("shop.title", "Shop"));
    }

    public xHubBlocksAPI getApi() {
        return this.api;
    }

    private void registerDynamicCommands() {
        List aliases = this.config.getStringList("settings.command-aliases");
        if (aliases.isEmpty()) {
            aliases.add("blocks");
        }
        this.mainCommandAlias = (String)aliases.get(0);
        try {
            Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            bukkitCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
            for (String alias : aliases) {
                Command cmd = new Command(alias){

                    public boolean execute(CommandSender sender, String label, String[] args) {
                        return xHubBlocks.this.onCommand(sender, this, label, args);
                    }

                    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
                        return xHubBlocks.this.onTabComplete(sender, this, alias, args);
                    }
                };
                cmd.setPermission("xhubblocks.use");
                commandMap.register("xhubblocks", cmd);
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Error registering dynamic commands: " + e.getMessage());
        }
    }

    private void loadPlayerData(Player player) {
        UUID uuid = player.getUniqueId();
        this.sessionPlacedCache.put(uuid, 0);
        this.dataStorage.loadPlayerStats(uuid).thenAccept(data -> {
            this.placedBlocksCache.put(uuid, data.placedBlocks);
            this.coinsCache.put(uuid, data.coins);
            HashSet<String> unlocked = new HashSet<String>();
            if (data.unlocked != null && !data.unlocked.isEmpty()) {
                Collections.addAll(unlocked, data.unlocked.split(","));
            }
            String defaultBlock = this.config.getString("block.material", "WOOL") + ":" + this.config.getInt("block.data", 0);
            unlocked.add(defaultBlock);
            this.unlockedCache.put(uuid, unlocked);
            this.selectedCache.put(uuid, data.selected);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.giveHubBlock(player));
        });
    }

    private void savePlayerData(UUID uuid, boolean async) {
        if (!this.placedBlocksCache.containsKey(uuid)) {
            return;
        }
        int placed = this.placedBlocksCache.get(uuid);
        double coins = this.coinsCache.get(uuid);
        String selected = this.selectedCache.get(uuid);
        String unlocked = String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.unlockedCache.get(uuid));
        Runnable save = () -> this.dataStorage.savePlayerData(uuid, placed, coins, unlocked, selected);
        if (async) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, save);
        } else {
            save.run();
        }
        if (async) {
            this.placedBlocksCache.remove(uuid);
            this.sessionPlacedCache.remove(uuid);
            this.coinsCache.remove(uuid);
            this.unlockedCache.remove(uuid);
            this.selectedCache.remove(uuid);
        }
    }

    private ItemStack createHubBlock(Player player) {
        byte data;
        String selectedRaw = this.selectedCache.getOrDefault(player.getUniqueId(), "WOOL:0");
        String[] parts = selectedRaw.split(":");
        Material mat = Material.getMaterial((String)parts[0]);
        byte by = data = parts.length > 1 ? Byte.parseByte(parts[1]) : (byte)0;
        if (mat == null) {
            mat = this.DEFAULT_WOOL;
        }
        ItemStack item = new ItemStack(mat, 64, (short)data);
        ItemMeta meta = item.getItemMeta();
        String name = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("block.name", "Block"));
        List lore = this.config.getStringList("block.lore").stream().map(l -> ChatColor.translateAlternateColorCodes((char)'&', (String)l)).collect(Collectors.toList());
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void giveHubBlock(Player player) {
        int slot = this.config.getInt("block.slot", 4);
        player.getInventory().setItem(slot, this.createHubBlock(player));
    }

    private boolean isHubBlock(ItemStack item) {
        if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasDisplayName()) {
            return false;
        }
        String cfgName = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("block.name"));
        return item.getItemMeta().getDisplayName().equals(cfgName);
    }

    private void openShop(Player player) {
        String perm = this.config.getString("shop.permission", "");
        if (!perm.isEmpty() && !player.hasPermission(perm)) {
            player.sendMessage(this.getMsg("messages.no-permission"));
            return;
        }
        Inventory shop = Bukkit.createInventory(null, (int)this.config.getInt("shop.size", 27), (String)this.shopTitle);
        ConfigurationSection items = this.config.getConfigurationSection("shop.items");
        if (items == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        double balance = this.coinsCache.getOrDefault(uuid, 0.0);
        Set unlocked = this.unlockedCache.getOrDefault(uuid, new HashSet());
        String selected = this.selectedCache.getOrDefault(uuid, "WOOL:0");
        for (String key : items.getKeys(false)) {
            ItemStack icon;
            ItemMeta meta;
            String matName = items.getString(key + ".material");
            int data = items.getInt(key + ".data", 0);
            double price = items.getDouble(key + ".price");
            int slot = items.getInt(key + ".slot");
            String name = items.getString(key + ".name");
            String id = matName + ":" + data;
            boolean isUnlocked = unlocked.contains(id);
            boolean isSelected = selected.equals(id);
            Material mat = Material.getMaterial((String)matName);
            if (mat == null) {
                mat = this.DEFAULT_WOOL;
            }
            if ((meta = (icon = new ItemStack(mat, 1, (short)((byte)data))).getItemMeta()) != null) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
                ArrayList<String> lore = new ArrayList<String>();
                lore.add("");
                if (isSelected) {
                    lore.add("\u00a7aSELECTED");
                    meta.addEnchant(Enchantment.DURABILITY, 1, true);
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                } else if (isUnlocked) {
                    lore.add("\u00a7eClick to Select");
                } else {
                    lore.add("\u00a77Price: \u00a76" + price + " coins");
                    if (balance >= price) {
                        lore.add("\u00a7aClick to Buy");
                    } else {
                        lore.add("\u00a7cNot enough coins");
                    }
                }
                meta.setLore(lore);
                icon.setItemMeta(meta);
            }
            shop.setItem(slot, icon);
        }
        player.openInventory(shop);
    }

    @EventHandler
    public void onShopClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(this.shopTitle)) {
            return;
        }
        event.setCancelled(true);
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        int slot = event.getSlot();
        ConfigurationSection items = this.config.getConfigurationSection("shop.items");
        if (items == null) {
            return;
        }
        for (String key : items.getKeys(false)) {
            if (items.getInt(key + ".slot") != slot) continue;
            String matName = items.getString(key + ".material");
            int data = items.getInt(key + ".data", 0);
            double price = items.getDouble(key + ".price");
            String displayName = items.getString(key + ".name");
            String id = matName + ":" + data;
            Set<String> unlocked = this.unlockedCache.get(uuid);
            double balance = this.coinsCache.get(uuid);
            if (unlocked.contains(id)) {
                if (this.selectedCache.get(uuid).equals(id)) {
                    player.sendMessage(this.getMsg("shop.messages.already-selected"));
                } else {
                    this.selectedCache.put(uuid, id);
                    player.sendMessage(this.getMsg("shop.messages.selected").replace("%item%", displayName));
                    player.closeInventory();
                    this.giveHubBlock(player);
                    player.playSound(player.getLocation(), this.getSafeSound("ORB_PICKUP", "ENTITY_EXPERIENCE_ORB_PICKUP"), 1.0f, 1.0f);
                }
            } else if (balance >= price) {
                this.coinsCache.put(uuid, balance - price);
                unlocked.add(id);
                this.unlockedCache.put(uuid, unlocked);
                this.selectedCache.put(uuid, id);
                player.sendMessage(this.getMsg("shop.messages.purchased").replace("%item%", displayName).replace("%price%", String.valueOf(price)));
                player.playSound(player.getLocation(), this.getSafeSound("LEVEL_UP", "ENTITY_PLAYER_LEVELUP"), 1.0f, 2.0f);
                player.closeInventory();
                this.giveHubBlock(player);
            } else {
                player.sendMessage(this.getMsg("shop.messages.no-funds").replace("%price%", String.valueOf(price)));
                player.playSound(player.getLocation(), this.getSafeSound("VILLAGER_NO", "ENTITY_VILLAGER_NO"), 1.0f, 1.0f);
            }
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent e) {
        this.loadPlayerData(e.getPlayer());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        this.savePlayerData(e.getPlayer().getUniqueId(), true);
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.isHubBlock(event.getItemInHand())) {
            Player player = event.getPlayer();
            UUID uuid = player.getUniqueId();
            this.placedBlocksCache.merge(uuid, 1, Integer::sum);
            this.sessionPlacedCache.merge(uuid, 1, Integer::sum);
            double earn = this.config.getDouble("economy.coins-per-block", 0.5);
            if (earn > 0.0) {
                this.coinsCache.merge(uuid, earn, Double::sum);
                this.sendNotification(player, earn);
            }
            event.getItemInHand().setAmount(64);
            long despawnTime = this.config.getLong("block.despawn-time-seconds", 5L) * 20L;
            if (despawnTime > 0L) {
                Location loc = event.getBlockPlaced().getLocation();
                Material mat = event.getBlockPlaced().getType();
                MaterialData data = event.getBlockPlaced().getState().getData();
                Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                    if (loc.getBlock().getType() == mat) {
                        this.spawnBreakParticle(loc, mat, data);
                        loc.getBlock().setType(Material.AIR);
                    }
                }, despawnTime);
            }
        }
    }

    private void spawnBreakParticle(Location loc, Material mat, MaterialData data) {
        if (this.IS_LEGACY) {
            loc.getWorld().playEffect(loc.clone().add(0.5, 0.5, 0.5), Effect.STEP_SOUND, (Object)data);
        } else {
            try {
                Class<?> particleClass = Class.forName("org.bukkit.Particle");
                Object blockCrack = particleClass.getField("BLOCK_CRACK").get(null);
                Object blockData = mat.getClass().getMethod("createBlockData", new Class[0]).invoke((Object)mat, new Object[0]);
                World world = loc.getWorld();
                world.getClass().getMethod("spawnParticle", particleClass, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Object.class).invoke((Object)world, blockCrack, loc.clone().add(0.5, 0.5, 0.5), 20, 0.2, 0.2, 0.2, blockData);
            }
            catch (Exception ignored) {
                try {
                    Class<?> particleClass = Class.forName("org.bukkit.Particle");
                    Object cloud = particleClass.getField("CLOUD").get(null);
                    World world = loc.getWorld();
                    world.getClass().getMethod("spawnParticle", particleClass, Location.class, Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).invoke((Object)world, cloud, loc.clone().add(0.5, 0.5, 0.5), 10, 0.1, 0.1, 0.1, 0.05);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private Sound getSafeSound(String legacy, String modern) {
        try {
            return Sound.valueOf((String)legacy);
        }
        catch (IllegalArgumentException e) {
            try {
                return Sound.valueOf((String)modern);
            }
            catch (IllegalArgumentException ex) {
                return Sound.values()[0];
            }
        }
    }

    private void sendNotification(Player player, double amount) {
        String msg = this.getMsg("economy.message").replace("%coins%", String.valueOf(amount));
        if (msg.isEmpty()) {
            return;
        }
        String type = this.config.getString("economy.notification-type", "ACTIONBAR").toUpperCase();
        try {
            switch (type) {
                case "CHAT": {
                    player.sendMessage(msg);
                    break;
                }
                case "TITLE": {
                    player.sendTitle("", msg);
                    break;
                }
                case "ACTIONBAR": {
                    this.sendReflectionActionBar(player, msg);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendReflectionActionBar(Player player, String message) {
        try {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
        }
        catch (Throwable e) {
            try {
                String v = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
                Class<?> c1 = Class.forName("net.minecraft.server." + v + ".PacketPlayOutChat");
                Class<?> c2 = Class.forName("net.minecraft.server." + v + ".IChatBaseComponent");
                Class<?> c3 = Class.forName("net.minecraft.server." + v + ".IChatBaseComponent$ChatSerializer");
                Object comp = c3.getMethod("a", String.class).invoke(null, "{\"text\":\"" + message + "\"}");
                Object packet = c1.getConstructor(c2, Byte.TYPE).newInstance(comp, (byte)2);
                Object entityPlayer = player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
                Object connection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
                connection.getClass().getMethod("sendPacket", Class.forName("net.minecraft.server." + v + ".Packet")).invoke(connection, packet);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getClickedInventory() != null && event.getClickedInventory().getType() == InventoryType.PLAYER && this.isHubBlock(event.getCurrentItem())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (this.isHubBlock(event.getItemDrop().getItemStack())) {
            event.setCancelled(true);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("xhubblocks.reload")) {
                    sender.sendMessage(this.getMsg("messages.no-permission"));
                    return true;
                }
                this.loadConfiguration();
                sender.sendMessage(this.getMsg("messages.config-reloaded"));
                return true;
            }
            if (args[0].equalsIgnoreCase("shop")) {
                if (sender instanceof Player) {
                    this.openShop((Player)sender);
                }
                return true;
            }
        }
        String cmd = this.mainCommandAlias;
        sender.sendMessage(this.getMsg("messages.help-header"));
        sender.sendMessage(this.getMsg("messages.help-command").replace("%cmd%", cmd));
        sender.sendMessage(this.getMsg("messages.shop-command").replace("%cmd%", cmd));
        return true;
    }

    public int getPlayerPlacedCount(UUID uuid) {
        return this.placedBlocksCache.getOrDefault(uuid, 0);
    }

    public int getSessionPlacedCount(UUID uuid) {
        return this.sessionPlacedCache.getOrDefault(uuid, 0);
    }

    public double getPlayerCoins(UUID uuid) {
        return this.coinsCache.getOrDefault(uuid, 0.0);
    }

    public int getTotalServerPlacedBlocks() {
        long now = System.currentTimeMillis();
        if (now - this.lastTotalCacheUpdateTime > TimeUnit.MINUTES.toMillis(1L)) {
            this.lastTotalCacheUpdateTime = now;
            this.dataStorage.getTotalPlacedBlocks().thenAcceptAsync(total -> {
                int sessionTotal = this.sessionPlacedCache.values().stream().mapToInt(Integer::intValue).sum();
                this.totalServerBlocksCache = total + sessionTotal;
            }, runnable -> Bukkit.getScheduler().runTask((Plugin)this, runnable));
        }
        return this.totalServerBlocksCache;
    }

    private String getMsg(String path) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(path, ""));
    }
}

