/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.config.ServerConfig;

public class OvergearedShapelessRecipe
extends ShapelessRecipe {
    private final NonNullList<ExtraIngredient> extraIngredients;

    public OvergearedShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<ExtraIngredient> extraIngredients) {
        super(id, group, category, result, OvergearedShapelessRecipe.toIngredientList(extraIngredients));
        this.extraIngredients = extraIngredients;
    }

    private static NonNullList<Ingredient> toIngredientList(NonNullList<ExtraIngredient> extras) {
        NonNullList list = NonNullList.m_122779_();
        for (ExtraIngredient ex : extras) {
            list.add((Object)ex.ingredient);
        }
        return list;
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = super.m_5874_(container, registryAccess);
        if (!((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue()) {
            boolean hasUnpolishedQualityItem = false;
            boolean unquenched = false;
            String foundQuality = null;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack ingredient = container.m_8020_(i);
                if (!ingredient.m_41782_()) continue;
                CompoundTag tag = ingredient.m_41783_();
                if (!tag.m_128441_("Polished") || !tag.m_128471_("Polished")) {
                    hasUnpolishedQualityItem = true;
                    break;
                }
                if (tag.m_128441_("Heated") && tag.m_128471_("Heated")) {
                    unquenched = true;
                    break;
                }
                if (!tag.m_128441_("ForgingQuality")) continue;
                foundQuality = tag.m_128461_("ForgingQuality");
            }
            if (hasUnpolishedQualityItem || unquenched) {
                return ItemStack.f_41583_;
            }
            if (foundQuality != null) {
                CompoundTag resultTag = new CompoundTag();
                ForgingQuality quality = ForgingQuality.fromString(foundQuality);
                resultTag.m_128359_("ForgingQuality", quality.getDisplayName());
                result.m_41751_(resultTag);
            } else {
                result.m_41751_(null);
            }
            return result;
        }
        String foundQuality = null;
        boolean isPolished = false;
        boolean unquenched = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack ingredient = container.m_8020_(i);
            if (!ingredient.m_41782_()) continue;
            CompoundTag tag = ingredient.m_41783_();
            if (tag.m_128441_("ForgingQuality")) {
                foundQuality = tag.m_128461_("ForgingQuality");
            }
            if (tag.m_128441_("Polished") && tag.m_128471_("Polished")) {
                isPolished = true;
            }
            if (!tag.m_128441_("Heated") || !tag.m_128471_("Heated")) continue;
            unquenched = true;
        }
        if (foundQuality != null) {
            ForgingQuality quality = ForgingQuality.fromString(foundQuality);
            if (!isPolished) {
                quality = quality.getLowerQuality();
            }
            if (unquenched) {
                quality = quality.getLowerQuality();
            }
            CompoundTag resultTag = new CompoundTag();
            resultTag.m_128359_("ForgingQuality", quality.getDisplayName());
            result.m_41751_(resultTag);
        } else {
            if (unquenched) {
                return ItemStack.f_41583_;
            }
            result.m_41751_(null);
        }
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList remains = NonNullList.m_122780_((int)container.m_6643_(), (Object)ItemStack.f_41583_);
        block0: for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            if (stack.m_41619_()) continue;
            for (ExtraIngredient ex : this.extraIngredients) {
                if (!ex.ingredient.test(stack)) continue;
                if (ex.durabilityDecrease > 0) {
                    ItemStack copy = stack.m_41777_();
                    int newDamage = copy.m_41773_() + ex.durabilityDecrease;
                    if (newDamage >= copy.m_41776_()) {
                        remains.set(slot, (Object)ItemStack.f_41583_);
                        continue block0;
                    }
                    copy.m_41721_(newDamage);
                    remains.set(slot, (Object)copy);
                    continue block0;
                }
                if (ex.remainder) {
                    remains.set(slot, (Object)stack.m_41777_());
                    continue block0;
                }
                if (!stack.hasCraftingRemainingItem()) continue block0;
                remains.set(slot, (Object)stack.getCraftingRemainingItem());
                continue block0;
            }
        }
        return remains;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class ExtraIngredient {
        public final Ingredient ingredient;
        public final boolean remainder;
        public final int durabilityDecrease;

        public ExtraIngredient(Ingredient ingredient, boolean remainder, int durabilityDecrease) {
            this.ingredient = ingredient;
            this.remainder = remainder;
            this.durabilityDecrease = durabilityDecrease;
        }
    }

    public static class Serializer
    implements RecipeSerializer<OvergearedShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public OvergearedShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            JsonArray ingArray = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList extraList = NonNullList.m_122779_();
            for (JsonElement el : ingArray) {
                JsonObject obj = el.getAsJsonObject();
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)obj);
                boolean remainder = obj.has("remainder") && obj.get("remainder").getAsBoolean();
                int durability = obj.has("durability_decrease") ? obj.get("durability_decrease").getAsInt() : 0;
                extraList.add((Object)new ExtraIngredient(ingredient, remainder, durability));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory cat = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)"misc"), (Enum)CraftingBookCategory.MISC);
            return new OvergearedShapelessRecipe(recipeId, group, cat, result, (NonNullList<ExtraIngredient>)extraList);
        }

        public OvergearedShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
            String group = buf.m_130277_();
            CraftingBookCategory cat = (CraftingBookCategory)buf.m_130066_(CraftingBookCategory.class);
            ItemStack result = buf.m_130267_();
            int count = buf.m_130242_();
            NonNullList extraList = NonNullList.m_122780_((int)count, null);
            for (int i = 0; i < count; ++i) {
                Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buf);
                boolean rem = buf.readBoolean();
                int dur = buf.m_130242_();
                extraList.set(i, (Object)new ExtraIngredient(ing, rem, dur));
            }
            return new OvergearedShapelessRecipe(recipeId, group, cat, result, (NonNullList<ExtraIngredient>)extraList);
        }

        public void toNetwork(FriendlyByteBuf buf, OvergearedShapelessRecipe recipe) {
            buf.m_130070_(recipe.m_6076_());
            buf.m_130068_((Enum)recipe.m_245232_());
            buf.m_130055_(recipe.m_8043_(null));
            buf.m_130130_(recipe.extraIngredients.size());
            for (ExtraIngredient ex : recipe.extraIngredients) {
                ex.ingredient.m_43923_(buf);
                buf.writeBoolean(ex.remainder);
                buf.m_130130_(ex.durabilityDecrease);
            }
        }
    }

    public static class Type
    implements RecipeType<OvergearedShapelessRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crafting_shapeless";
    }
}

