/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.block.entity;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.stirdrem.overgeared.AnvilTier;
import net.stirdrem.overgeared.BlueprintQuality;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.block.custom.TierBSmithingAnvil;
import net.stirdrem.overgeared.block.entity.AbstractSmithingAnvilBlockEntity;
import net.stirdrem.overgeared.block.entity.ModBlockEntities;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.recipe.ForgingRecipe;
import net.stirdrem.overgeared.screen.TierBSmithingAnvilMenu;
import org.jetbrains.annotations.Nullable;

public class TierBSmithingAnvilBlockEntity
extends AbstractSmithingAnvilBlockEntity {
    private static final int BLUEPRINT_SLOT = 11;

    public TierBSmithingAnvilBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(AnvilTier.ABOVE_B, (BlockEntityType)ModBlockEntities.TIER_B_SMITHING_ANVIL_BE.get(), pPos, pBlockState);
    }

    @Override
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.overgeared.smithing_anvil");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (!pPlayer.m_6047_()) {
            return new TierBSmithingAnvilMenu(pContainerId, pPlayerInventory, this, this.data);
        }
        return null;
    }

    @Override
    protected String determineForgingQuality() {
        String quality = TierBSmithingAnvil.getQuality();
        if (quality == null) {
            return "no_quality";
        }
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        ForgingRecipe recipe = recipeOptional.get();
        if (!recipe.getBlueprintTypes().isEmpty()) {
            ItemStack blueprint = this.itemHandler.getStackInSlot(11);
            List<String> qualityTiers = List.of("poor", "well", "expert", "perfect", "master");
            if (blueprint.m_41619_() || !blueprint.m_41782_()) {
                return switch (quality.toLowerCase()) {
                    case "poor" -> ForgingQuality.POOR.getDisplayName();
                    default -> "well";
                };
            }
            CompoundTag nbt = blueprint.m_41783_();
            if (nbt == null || !nbt.m_128441_("Quality")) {
                return switch (quality.toLowerCase()) {
                    case "poor" -> ForgingQuality.POOR.getDisplayName();
                    default -> "well";
                };
            }
            String blueprintToolType = nbt.m_128461_("Quality").toLowerCase();
            int anvilTierIndex = qualityTiers.indexOf(quality.toLowerCase());
            int blueprintTierIndex = qualityTiers.indexOf(blueprintToolType);
            if (anvilTierIndex == -1 || blueprintTierIndex == -1) {
                return ForgingQuality.POOR.getDisplayName();
            }
            int finalIndex = Math.min(anvilTierIndex, blueprintTierIndex);
            switch (qualityTiers.get(finalIndex)) {
                case "poor": {
                    return ForgingQuality.POOR.getDisplayName();
                }
                case "well": {
                    return ForgingQuality.WELL.getDisplayName();
                }
                case "expert": {
                    return ForgingQuality.EXPERT.getDisplayName();
                }
                case "perfect": {
                    boolean ingredientMasterRoll;
                    Random random = new Random();
                    boolean hasMasterIngredient = false;
                    for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                        String ingQuality;
                        ItemStack stack;
                        if (i == 10 || i == 11 || (stack = this.itemHandler.getStackInSlot(i)).m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128441_("ForgingQuality") || !"master".equals(ingQuality = stack.m_41783_().m_128461_("ForgingQuality").toLowerCase())) continue;
                        hasMasterIngredient = true;
                        break;
                    }
                    boolean masterRoll = (Double)ServerConfig.MASTER_QUALITY_CHANCE.get() != 0.0 && (double)random.nextFloat() < (Double)ServerConfig.MASTER_QUALITY_CHANCE.get();
                    boolean bl = ingredientMasterRoll = hasMasterIngredient && (double)random.nextFloat() < (Double)ServerConfig.MASTER_FROM_INGREDIENT_CHANCE.get();
                    if ("master".equals(blueprintToolType) || masterRoll || ingredientMasterRoll) {
                        return ForgingQuality.MASTER.getDisplayName();
                    }
                    return ForgingQuality.PERFECT.getDisplayName();
                }
                case "master": {
                    return ForgingQuality.MASTER.getDisplayName();
                }
            }
            return "no_quality";
        }
        return quality;
    }

    @Override
    protected void craftItem() {
        CompoundTag tag;
        super.craftItem();
        ItemStack result = this.itemHandler.getStackInSlot(10);
        if (result.m_41619_()) {
            return;
        }
        ItemStack blueprint = this.itemHandler.getStackInSlot(11);
        if (!blueprint.m_41619_() && blueprint.m_41782_() && (tag = blueprint.m_41784_()).m_128441_("Quality") && tag.m_128441_("Uses") && tag.m_128441_("UsesToLevel")) {
            String currentQualityStr = tag.m_128461_("Quality");
            int uses = tag.m_128451_("Uses");
            int usesToLevel = tag.m_128451_("UsesToLevel");
            BlueprintQuality currentQuality = BlueprintQuality.fromString(currentQualityStr);
            String forgingQualityStr = TierBSmithingAnvil.getQuality();
            ForgingQuality resultQuality = ForgingQuality.fromString(forgingQualityStr);
            if (currentQuality != null && currentQuality != BlueprintQuality.PERFECT && currentQuality != BlueprintQuality.MASTER) {
                uses = resultQuality == ForgingQuality.PERFECT ? (uses += 2) : (resultQuality == ForgingQuality.MASTER ? (uses += 3) : ++uses);
                if (uses >= usesToLevel) {
                    BlueprintQuality nextQuality = BlueprintQuality.getNext(currentQuality);
                    if (nextQuality != null) {
                        tag.m_128359_("Quality", nextQuality.getDisplayName());
                        tag.m_128405_("Uses", 0);
                        tag.m_128405_("UsesToLevel", nextQuality.getUse());
                    } else {
                        tag.m_128405_("Uses", usesToLevel);
                    }
                } else {
                    tag.m_128405_("Uses", uses);
                }
                blueprint.m_41751_(tag);
                this.itemHandler.setStackInSlot(11, blueprint);
            }
        }
    }

    @Override
    public boolean hasRecipe() {
        ItemStack resultStack;
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return false;
        }
        ForgingRecipe recipe = recipeOptional.get();
        AnvilTier requiredTier = AnvilTier.fromDisplayName(recipe.getAnvilTier());
        if (requiredTier == null || !requiredTier.isEqualOrLowerThan(this.anvilTier)) {
            return false;
        }
        ItemStack blueprint = this.itemHandler.getStackInSlot(11);
        if (recipe.requiresBlueprint()) {
            if (blueprint.m_41619_() || !blueprint.m_41782_() || !blueprint.m_41783_().m_128441_("ToolType")) {
                return false;
            }
            blueprintToolType = blueprint.m_41783_().m_128461_("ToolType").toLowerCase(Locale.ROOT);
            if (!recipe.getBlueprintTypes().contains(blueprintToolType)) {
                return false;
            }
        } else if (!blueprint.m_41619_() && blueprint.m_41782_() && blueprint.m_41783_().m_128441_("ToolType")) {
            blueprintToolType = blueprint.m_41783_().m_128461_("ToolType").toLowerCase(Locale.ROOT);
            if (!recipe.getBlueprintTypes().contains(blueprintToolType)) {
                return false;
            }
        }
        return this.canInsertItemIntoOutputSlot(resultStack = recipe.m_8043_(this.f_58857_.m_9598_())) && this.canInsertAmountIntoOutputSlot(resultStack.m_41613_());
    }

    @Override
    public String blueprintQuality() {
        String quality = TierBSmithingAnvil.getQuality();
        if (quality == null) {
            return "no_quality";
        }
        Optional<ForgingRecipe> recipeOptional = this.getCurrentRecipe();
        if (recipeOptional.isEmpty()) {
            return "poor";
        }
        ForgingRecipe recipe = recipeOptional.get();
        if (!recipe.getBlueprintTypes().isEmpty()) {
            String poor;
            ItemStack blueprint = this.itemHandler.getStackInSlot(11);
            List<String> qualityTiers = List.of("poor", "well", "expert", "perfect", "master");
            String string = poor = quality.equalsIgnoreCase("poor") ? ForgingQuality.POOR.getDisplayName() : "well";
            if (blueprint.m_41619_() || !blueprint.m_41782_()) {
                return poor;
            }
            CompoundTag nbt = blueprint.m_41783_();
            if (nbt == null || !nbt.m_128441_("Quality")) {
                return poor;
            }
            String bpQuality = nbt.m_128461_("Quality").toLowerCase();
            return qualityTiers.contains(bpQuality) ? bpQuality : "well";
        }
        return "well";
    }
}

