/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.event;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.stirdrem.overgeared.config.ServerConfig;
import net.stirdrem.overgeared.event.ModItemInteractEvents;
import net.stirdrem.overgeared.networking.ModMessages;
import net.stirdrem.overgeared.networking.packet.SetMinigameVisibleC2SPacket;

@Mod.EventBusSubscriber(modid="overgeared", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class AnvilMinigameEvents {
    public static UUID ownerUUID = null;
    private static boolean isVisible = false;
    public static boolean minigameStarted = false;
    public static ItemStack resultItem = null;
    public static int hitsRemaining = 0;
    public static float arrowPosition = 1.0f;
    public static float arrowSpeed = ((Double)ServerConfig.POOR_ARROW_SPEED.get()).floatValue();
    public static float maxArrowSpeed = ((Double)ServerConfig.POOR_MAX_ARROW_SPEED.get()).floatValue();
    public static float speedIncreasePerHit = ((Double)ServerConfig.POOR_ARROW_SPEED_INCREASE.get()).floatValue();
    public static boolean movingRight = true;
    public static int perfectHits = 0;
    public static int goodHits = 0;
    public static int missedHits = 0;
    public static int perfectZoneStart = (100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
    public static int perfectZoneEnd = (100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
    public static int goodZoneStart = Math.max((100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
    public static int goodZoneEnd = Math.min((100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
    public static float zoneShrinkFactor = ((Double)ServerConfig.POOR_ZONE_SHRINK_FACTOR.get()).floatValue();
    public static float zoneShiftAmount = 15.0f;
    public static float perfectZoneSize = perfectZoneEnd - perfectZoneStart;
    public static Map<BlockPos, UUID> occupiedAnvils = Collections.synchronizedMap(new HashMap());
    public static int skillLevel = 0;
    private static int TICKS_PER_PRINT = 1;
    private static int tickAccumulator = 0;
    private static boolean movingDown = false;
    private static float currentPerfectZoneSize = 0.0f;
    private static float currentGoodZoneSize = 0.0f;

    public static void setupForQuality(String quality) {
        switch (quality.toLowerCase()) {
            case "master": {
                arrowSpeed = ((Double)ServerConfig.MASTER_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.MASTER_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.MASTER_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.MASTER_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.MASTER_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "perfect": {
                arrowSpeed = ((Double)ServerConfig.PERFECT_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.PERFECT_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.PERFECT_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.PERFECT_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.PERFECT_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "expert": {
                arrowSpeed = ((Double)ServerConfig.EXPERT_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.EXPERT_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.EXPERT_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.EXPERT_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.EXPERT_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            case "well": {
                arrowSpeed = ((Double)ServerConfig.WELL_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.WELL_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.WELL_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.WELL_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.WELL_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
                break;
            }
            default: {
                arrowSpeed = ((Double)ServerConfig.POOR_ARROW_SPEED.get()).floatValue();
                speedIncreasePerHit = ((Double)ServerConfig.POOR_ARROW_SPEED_INCREASE.get()).floatValue();
                maxArrowSpeed = ((Double)ServerConfig.POOR_MAX_ARROW_SPEED.get()).floatValue();
                zoneShrinkFactor = ((Double)ServerConfig.POOR_ZONE_SHRINK_FACTOR.get()).floatValue();
                perfectZoneStart = (100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
                perfectZoneEnd = (100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get()) / 2;
                goodZoneStart = Math.max((100 - (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get() * 3) / 2, 1);
                goodZoneEnd = Math.min((100 + (Integer)ServerConfig.POOR_ZONE_STARTING_SIZE.get() * 3) / 2, 100);
                perfectZoneSize = perfectZoneEnd - perfectZoneStart;
            }
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.m_91104_() || !AnvilMinigameEvents.isIsVisible()) {
            return;
        }
        if (++tickAccumulator < TICKS_PER_PRINT) {
            return;
        }
        tickAccumulator = 0;
        if (arrowPosition >= 100.0f) {
            movingDown = true;
        } else if (arrowPosition <= 1.0f) {
            movingDown = false;
        }
        float delta = arrowSpeed * (float)(movingDown ? -1 : 1);
        arrowPosition = Math.max(1.0f, Math.min(arrowPosition + delta, 100.0f));
    }

    public static void speedUp() {
        arrowSpeed = Math.min(arrowSpeed + speedIncreasePerHit, maxArrowSpeed);
    }

    public static float getArrowPosition() {
        return arrowPosition;
    }

    public static boolean isIsVisible() {
        return isVisible;
    }

    public static void setIsVisible(BlockPos pos, boolean isVisible) {
        AnvilMinigameEvents.isVisible = isVisible;
        ModMessages.sendToServer(new SetMinigameVisibleC2SPacket(pos, isVisible));
    }

    public static void reset(String blueprintQuality) {
        isVisible = false;
        minigameStarted = false;
        hitsRemaining = 0;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        arrowPosition = 50.0f;
        movingDown = false;
        currentPerfectZoneSize = 0.0f;
        currentGoodZoneSize = 0.0f;
        AnvilMinigameEvents.setupForQuality(blueprintQuality);
        AnvilMinigameEvents.randomizeCenter();
    }

    public static void reset() {
        isVisible = false;
        minigameStarted = false;
        hitsRemaining = 0;
        perfectHits = 0;
        goodHits = 0;
        missedHits = 0;
        arrowPosition = 50.0f;
        movingDown = false;
        AnvilMinigameEvents.setupForQuality("poor");
        AnvilMinigameEvents.randomizeCenter();
    }

    private static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    private static void randomizeCenter() {
        float randomCenter = 20.0f + (float)Math.random() * 60.0f;
        float zoneSize = perfectZoneEnd - perfectZoneStart;
        float goodZoneSize = goodZoneEnd - goodZoneStart;
        int halfPerfect = (int)(zoneSize / 2.0f);
        int halfGood = (int)(goodZoneSize / 2.0f);
        perfectZoneStart = AnvilMinigameEvents.clamp((int)randomCenter - halfPerfect, 0, 100);
        perfectZoneEnd = AnvilMinigameEvents.clamp((int)randomCenter + halfPerfect, 0, 100);
        goodZoneStart = AnvilMinigameEvents.clamp((int)randomCenter - halfGood, 0, 100);
        goodZoneEnd = AnvilMinigameEvents.clamp((int)randomCenter + halfGood, 0, 100);
    }

    public static int getPerfectZoneStart() {
        return perfectZoneStart;
    }

    public static int getPerfectZoneEnd() {
        return perfectZoneEnd;
    }

    public static int getGoodZoneStart() {
        return goodZoneStart;
    }

    public static int getGoodZoneEnd() {
        return goodZoneEnd;
    }

    public static int getHitsRemaining() {
        return hitsRemaining;
    }

    public static int getPerfectHits() {
        return perfectHits;
    }

    public static int getGoodHits() {
        return goodHits;
    }

    public static int getMissedHits() {
        return missedHits;
    }

    public static String handleHit() {
        arrowSpeed = Math.min(arrowSpeed + speedIncreasePerHit, maxArrowSpeed);
        if (arrowPosition >= (float)perfectZoneStart && arrowPosition <= (float)perfectZoneEnd) {
            ++perfectHits;
        } else if (arrowPosition >= (float)goodZoneStart && arrowPosition <= (float)goodZoneEnd) {
            ++goodHits;
        } else {
            ++missedHits;
        }
        AnvilMinigameEvents.shrinkAndShiftZones();
        if (--hitsRemaining <= 0) {
            return AnvilMinigameEvents.finishForging();
        }
        return "poor";
    }

    public static void setHitsRemaining(int hitsRemaining) {
        AnvilMinigameEvents.hitsRemaining = hitsRemaining;
    }

    public static String finishForging() {
        isVisible = false;
        minigameStarted = false;
        int totalHits = perfectHits + goodHits + missedHits;
        float qualityScore = 0.0f;
        if (totalHits > 0) {
            qualityScore = ((float)perfectHits * 1.0f + (float)goodHits * 0.6f) / (float)totalHits;
        }
        if ((double)qualityScore > (Double)ServerConfig.PERFECT_QUALITY_SCORE.get()) {
            return "perfect";
        }
        if ((double)qualityScore > (Double)ServerConfig.EXPERT_QUALITY_SCORE.get()) {
            return "expert";
        }
        if ((double)qualityScore > (Double)ServerConfig.WELL_QUALITY_SCORE.get()) {
            return "well";
        }
        return "poor";
    }

    public static void shrinkAndShiftZones() {
        if (currentPerfectZoneSize == 0.0f || currentGoodZoneSize == 0.0f) {
            currentPerfectZoneSize = perfectZoneEnd - perfectZoneStart;
            currentGoodZoneSize = goodZoneEnd - goodZoneStart;
        }
        currentPerfectZoneSize *= zoneShrinkFactor;
        currentGoodZoneSize *= zoneShrinkFactor;
        currentPerfectZoneSize = Math.max(currentPerfectZoneSize, perfectZoneSize);
        currentGoodZoneSize = Math.max(currentGoodZoneSize, currentPerfectZoneSize * 3.0f);
        float originalCenter = (float)(perfectZoneStart + perfectZoneEnd) / 2.0f;
        boolean shifted = false;
        int newPerfectStart = perfectZoneStart;
        int newPerfectEnd = perfectZoneEnd;
        int newGoodStart = goodZoneStart;
        int newGoodEnd = goodZoneEnd;
        for (int attempts = 0; !shifted && attempts < 5; ++attempts) {
            float zoneCenter = AnvilMinigameEvents.getWeightedRandomCenter(originalCenter);
            int ps = (int)(zoneCenter - currentPerfectZoneSize / 2.0f);
            int pe = (int)(zoneCenter + currentPerfectZoneSize / 2.0f);
            int gs = (int)(zoneCenter - currentGoodZoneSize / 2.0f);
            int ge = (int)(zoneCenter + currentGoodZoneSize / 2.0f);
            ps = AnvilMinigameEvents.clamp(ps, 0, 100);
            pe = AnvilMinigameEvents.clamp(pe, 0, 100);
            gs = AnvilMinigameEvents.clamp(gs, 0, 100);
            ge = AnvilMinigameEvents.clamp(ge, 0, 100);
            if (ps == perfectZoneStart && pe == perfectZoneEnd) continue;
            newPerfectStart = ps;
            newPerfectEnd = pe;
            newGoodStart = gs;
            newGoodEnd = ge;
            shifted = true;
        }
        perfectZoneStart = newPerfectStart;
        perfectZoneEnd = newPerfectEnd;
        goodZoneStart = newGoodStart;
        goodZoneEnd = newGoodEnd;
    }

    public static float getWeightedRandomCenter(float currentCenter) {
        float rand = (float)Math.random();
        float shiftMagnitude = (double)rand < 0.7 ? 0.5f : ((double)rand < 0.9 ? 1.5f : 3.0f);
        float direction = Math.signum((float)Math.random() - 0.5f);
        return Math.max(20.0f, Math.min(80.0f, currentCenter + direction * zoneShiftAmount * shiftMagnitude));
    }

    public static BlockPos getAnvilPos(UUID playerId) {
        return ModItemInteractEvents.playerAnvilPositions.getOrDefault(playerId, BlockPos.f_121853_);
    }

    public static void setAnvilPos(UUID playerId, BlockPos pos) {
        ModItemInteractEvents.playerAnvilPositions.put(playerId, pos);
    }

    public static void clearAnvilPos(UUID playerId) {
        ModItemInteractEvents.playerAnvilPositions.remove(playerId);
    }

    public static void setMinigameStarted(BlockPos pos, boolean minigameStarted) {
        AnvilMinigameEvents.minigameStarted = minigameStarted;
    }

    public static UUID getOccupiedAnvil(BlockPos pos) {
        return occupiedAnvils.get(pos);
    }

    public static void putOccupiedAnvil(BlockPos pos, UUID me) {
        occupiedAnvils.put(pos, me);
    }

    public static boolean hasAnvilPosition(UUID playerId) {
        BlockPos pos = ModItemInteractEvents.playerAnvilPositions.get(playerId);
        return pos != null && !pos.equals((Object)BlockPos.f_121853_);
    }

    public static void hideMinigame(UUID playerId) {
        isVisible = false;
        BlockPos pos = ModItemInteractEvents.playerAnvilPositions.get(playerId);
        if (pos != null && !pos.equals((Object)BlockPos.f_121853_)) {
            ModMessages.sendToServer(new SetMinigameVisibleC2SPacket(pos, false));
        }
    }
}

