/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.networking.packet;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.stirdrem.overgeared.OvergearedMod;
import net.stirdrem.overgeared.item.ToolType;
import net.stirdrem.overgeared.item.ToolTypeRegistry;
import net.stirdrem.overgeared.screen.BlueprintWorkbenchMenu;

public class SelectToolTypeC2SPacket {
    private final String toolTypeId;
    private final int containerId;

    public SelectToolTypeC2SPacket(String toolTypeId, int containerId) {
        this.toolTypeId = toolTypeId;
        this.containerId = containerId;
    }

    public SelectToolTypeC2SPacket(FriendlyByteBuf buf) {
        this.toolTypeId = buf.m_130277_();
        this.containerId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.toolTypeId);
        buf.writeInt(this.containerId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                OvergearedMod.LOGGER.warn("SelectToolTypeC2SPacket received from null sender (toolTypeId='{}')", (Object)this.toolTypeId);
            } else {
                Optional<ToolType> optional = ToolTypeRegistry.byId(this.toolTypeId);
                if (optional.isPresent()) {
                    OvergearedMod.LOGGER.debug("ToolType '{}' found. Proceeding to create blueprint.", (Object)this.toolTypeId);
                    AbstractContainerMenu patt1826$temp = player.f_36096_;
                    if (patt1826$temp instanceof BlueprintWorkbenchMenu) {
                        BlueprintWorkbenchMenu menu = (BlueprintWorkbenchMenu)patt1826$temp;
                        menu.createBlueprint(optional.get());
                        menu.m_38946_();
                    } else {
                        OvergearedMod.LOGGER.warn("Player '{}' is not in BlueprintWorkbenchMenu, but in {}", (Object)player.m_36316_().getName(), (Object)player.f_36096_.getClass().getSimpleName());
                    }
                } else {
                    OvergearedMod.LOGGER.error("ToolTypeRegistry.byId('{}') returned empty; cannot create blueprint.", (Object)this.toolTypeId);
                }
            }
        });
        context.setPacketHandled(true);
        return true;
    }
}

