/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared.recipe;

import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.stirdrem.overgeared.ForgingQuality;
import net.stirdrem.overgeared.config.ServerConfig;

public class OvergearedShapelessRecipe
extends ShapelessRecipe {
    public OvergearedShapelessRecipe(ResourceLocation id, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(id, group, category, result, ingredients);
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack result = super.m_5874_(container, registryAccess);
        if (!((Boolean)ServerConfig.ENABLE_MINIGAME.get()).booleanValue()) {
            boolean hasUnpolishedQualityItem = false;
            boolean unquenched = false;
            String foundQuality = null;
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack ingredient = container.m_8020_(i);
                if (!ingredient.m_41782_()) continue;
                CompoundTag tag = ingredient.m_41783_();
                if (!tag.m_128441_("Polished") || !tag.m_128471_("Polished")) {
                    hasUnpolishedQualityItem = true;
                    break;
                }
                if (tag.m_128441_("Heated") && tag.m_128471_("Heated")) {
                    unquenched = true;
                    break;
                }
                if (!tag.m_128441_("ForgingQuality")) continue;
                foundQuality = tag.m_128461_("ForgingQuality");
            }
            if (hasUnpolishedQualityItem || unquenched) {
                return ItemStack.f_41583_;
            }
            CompoundTag resultTag = result.m_41784_();
            ForgingQuality quality = ForgingQuality.fromString(foundQuality);
            resultTag.m_128359_("ForgingQuality", quality.getDisplayName());
            result.m_41751_(resultTag);
            return result;
        }
        CompoundTag resultTag = result.m_41784_();
        String foundQuality = null;
        boolean isPolished = false;
        boolean unquenched = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack ingredient = container.m_8020_(i);
            if (!ingredient.m_41782_()) continue;
            CompoundTag tag = ingredient.m_41783_();
            if (tag.m_128441_("ForgingQuality")) {
                foundQuality = tag.m_128461_("ForgingQuality");
            }
            if (tag.m_128441_("Polished") && tag.m_128471_("Polished")) {
                isPolished = true;
            }
            if (!tag.m_128441_("Heated") || !tag.m_128471_("Heated")) continue;
            unquenched = true;
        }
        if (foundQuality != null) {
            ForgingQuality quality = ForgingQuality.fromString(foundQuality);
            if (!isPolished) {
                quality = quality.getLowerQuality();
            }
            if (unquenched) {
                quality = quality.getLowerQuality();
            }
            resultTag.m_128359_("ForgingQuality", quality.getDisplayName());
            result.m_41751_(resultTag);
        } else if (unquenched) {
            return ItemStack.f_41583_;
        }
        return result;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<OvergearedShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public OvergearedShapelessRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ShapelessRecipe baseRecipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_6729_(recipeId, json);
            return new OvergearedShapelessRecipe(recipeId, baseRecipe.m_6076_(), baseRecipe.m_245232_(), baseRecipe.m_8043_(null), (NonNullList<Ingredient>)baseRecipe.m_7527_());
        }

        public OvergearedShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            ShapelessRecipe baseRecipe = (ShapelessRecipe)ShapelessRecipe.Serializer.f_44077_.m_8005_(recipeId, buffer);
            return new OvergearedShapelessRecipe(recipeId, baseRecipe.m_6076_(), baseRecipe.m_245232_(), baseRecipe.m_8043_(null), (NonNullList<Ingredient>)baseRecipe.m_7527_());
        }

        public void toNetwork(FriendlyByteBuf buffer, OvergearedShapelessRecipe recipe) {
            ShapelessRecipe.Serializer.f_44077_.m_6178_(buffer, (Recipe)recipe);
        }
    }

    public static class Type
    implements RecipeType<OvergearedShapelessRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "crafting_shapeless";
    }
}

