/*
 * Decompiled with CFR 0.152.
 */
package net.stirdrem.overgeared;

import net.minecraft.ChatFormatting;
import net.stirdrem.overgeared.config.ServerConfig;

public enum BlueprintQuality {
    POOR("poor", (Integer)ServerConfig.POOR_MAX_USE.get(), ChatFormatting.RED),
    WELL("well", (Integer)ServerConfig.WELL_MAX_USE.get(), ChatFormatting.YELLOW),
    EXPERT("expert", (Integer)ServerConfig.EXPERT_MAX_USE.get(), ChatFormatting.BLUE),
    PERFECT("perfect", (Integer)ServerConfig.PERFECT_MAX_USE.get(), ChatFormatting.GOLD),
    MASTER("master", (Integer)ServerConfig.MASTER_MAX_USE.get(), ChatFormatting.LIGHT_PURPLE);

    private final String id;
    private final int use;
    private final ChatFormatting color;

    private BlueprintQuality(String id, int use, ChatFormatting color) {
        this.id = id;
        this.use = use;
        this.color = color;
    }

    public static int compare(String q1, String q2) {
        BlueprintQuality a = BlueprintQuality.fromString(q1);
        BlueprintQuality b = BlueprintQuality.fromString(q2);
        return Integer.compare(a.ordinal(), b.ordinal());
    }

    public String getDisplayName() {
        return this.id;
    }

    public int getUse() {
        return this.use;
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public String getTranslationKey() {
        return "tooltip.overgeared.blueprint.quality." + this.name().toLowerCase();
    }

    public static BlueprintQuality fromString(String id) {
        for (BlueprintQuality q : BlueprintQuality.values()) {
            if (!q.id.equalsIgnoreCase(id)) continue;
            return q;
        }
        return POOR;
    }

    public static BlueprintQuality getNext(BlueprintQuality current) {
        int index = current.ordinal();
        if (index + 1 < BlueprintQuality.values().length) {
            return BlueprintQuality.values()[index + 1];
        }
        return null;
    }

    public static BlueprintQuality getPrevious(BlueprintQuality current) {
        int index = current.ordinal();
        if (index - 1 >= 0) {
            return BlueprintQuality.values()[index - 1];
        }
        return null;
    }

    public String getId() {
        return this.id;
    }
}

